/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cina.dss.bundle.registrators;

import ch.systemsx.cisd.cina.dss.CinaImageDataSetInformation;
import ch.systemsx.cisd.cina.dss.bundle.registrators.BundleDataSetHelper;
import ch.systemsx.cisd.cina.dss.bundle.registrators.BundleRegistrationState;
import ch.systemsx.cisd.cina.shared.metadata.ImageMetadataExtractor;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewProperty;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CollectionAnnotatedImagesRegistrator
extends BundleDataSetHelper {
    private final ImageMetadataExtractor imageMetadataExtractor;
    private final SampleIdentifier replicaSampleId;
    private final DataSetInformation bundleMetadataDataSetInformation;

    CollectionAnnotatedImagesRegistrator(BundleRegistrationState globalState, ImageMetadataExtractor imageMetadataExtractor, Sample replicaSample, SampleIdentifier replicaSampleId, DataSetInformation bundleMetadataDataSetInformation) {
        super(globalState, imageMetadataExtractor.getRepresentationsFolder());
        this.imageMetadataExtractor = imageMetadataExtractor;
        this.replicaSampleId = replicaSampleId;
        this.bundleMetadataDataSetInformation = bundleMetadataDataSetInformation;
    }

    public List<DataSetInformation> register() {
        CinaImageDataSetInformation metadataDataSetInfo = this.createDataSetInformation();
        ArrayList<NewProperty> properties = this.createDataSetProperties(this.globalState.getImageDataSetType(), this.imageMetadataExtractor);
        metadataDataSetInfo.setDataSetProperties(properties);
        this.registerLinkedDataSet(this.dataSet, metadataDataSetInfo);
        return this.getDataSetInformation();
    }

    private CinaImageDataSetInformation createDataSetInformation() {
        CinaImageDataSetInformation metadataDataSetInfo = new CinaImageDataSetInformation();
        metadataDataSetInfo.setSampleCode(this.replicaSampleId.getSampleCode());
        metadataDataSetInfo.setSpaceCode(this.replicaSampleId.getSpaceLevel().getSpaceCode());
        metadataDataSetInfo.setInstanceCode(this.replicaSampleId.getSpaceLevel().getDatabaseInstanceCode());
        metadataDataSetInfo.setDataSetType(this.globalState.getImageDataSetType().getDataSetType());
        List<String> parentDataSetCodes = Collections.singletonList(this.bundleMetadataDataSetInformation.getDataSetCode());
        metadataDataSetInfo.setParentDataSetCodes(parentDataSetCodes);
        metadataDataSetInfo.setShareId(this.bundleMetadataDataSetInformation.getShareId());
        return metadataDataSetInfo;
    }
}

