/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cina.dss.bundle.registrators;

import ch.systemsx.cisd.cina.dss.bundle.registrators.BundleDataSetHelper;
import ch.systemsx.cisd.cina.dss.bundle.registrators.BundleRegistrationState;
import ch.systemsx.cisd.cina.shared.metadata.CollectionMetadataExtractor;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PhysicalDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewProperty;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CollectionMetadataRegistrator
extends BundleDataSetHelper {
    private final CollectionMetadataExtractor replicaMetadataExtractor;
    private final SampleIdentifier replicaSampleId;
    private final DataSetInformation bundleMetadataDataSetInformation;
    private File metadataDataSetFile = null;

    CollectionMetadataRegistrator(BundleRegistrationState globalState, CollectionMetadataExtractor replicaMetadataExtractor, Sample replicaSample, SampleIdentifier replicaSampleId, DataSetInformation bundleMetadataDataSetInformation) {
        super(globalState, replicaMetadataExtractor.getFolder());
        this.replicaMetadataExtractor = replicaMetadataExtractor;
        this.replicaSampleId = replicaSampleId;
        this.bundleMetadataDataSetInformation = bundleMetadataDataSetInformation;
    }

    public List<DataSetInformation> register() {
        String dataSetFileName = this.dataSet.getName();
        DataSetInformation metadataDataSetInfo = this.createDataSetInformation();
        ArrayList<NewProperty> properties = this.createDataSetProperties(this.globalState.getMetadataDataSetType(), this.replicaMetadataExtractor);
        metadataDataSetInfo.setDataSetProperties(properties);
        this.registerDataSet(this.dataSet, metadataDataSetInfo);
        DataSetInformation registeredDataSetInformation = (DataSetInformation)this.getDataSetInformation().get(0);
        this.initializeMetadataDataSetFile(registeredDataSetInformation, dataSetFileName);
        return this.getDataSetInformation();
    }

    public File getMetadataDataSetFile() {
        assert (this.metadataDataSetFile != null) : "Can get metadataDataSetFile only after calling register";
        return this.metadataDataSetFile;
    }

    private DataSetInformation createDataSetInformation() {
        DataSetInformation metadataDataSetInfo = new DataSetInformation();
        metadataDataSetInfo.setSampleCode(this.replicaSampleId.getSampleCode());
        metadataDataSetInfo.setSpaceCode(this.replicaSampleId.getSpaceLevel().getSpaceCode());
        metadataDataSetInfo.setInstanceCode(this.replicaSampleId.getSpaceLevel().getDatabaseInstanceCode());
        metadataDataSetInfo.setDataSetType(this.globalState.getMetadataDataSetType().getDataSetType());
        List<String> parentDataSetCodes = Collections.singletonList(this.bundleMetadataDataSetInformation.getDataSetCode());
        metadataDataSetInfo.setParentDataSetCodes(parentDataSetCodes);
        return metadataDataSetInfo;
    }

    private void initializeMetadataDataSetFile(DataSetInformation registeredDataSetInformation, String dataSetFileName) {
        AbstractExternalData metadataExternalData = this.getOpenbisService().tryGetDataSet(this.getSessionContext().getSessionToken(), registeredDataSetInformation.getDataSetCode());
        PhysicalDataSet metadataDataSet = metadataExternalData.tryGetAsDataSet();
        assert (metadataDataSet != null) : "Data set not found";
        assert (metadataDataSet != null) : "";
        String shareId = registeredDataSetInformation.getShareId();
        File containerFile = this.getDelegator().getFileForDataSet(metadataDataSet, shareId);
        this.metadataDataSetFile = new File(containerFile, dataSetFileName);
    }
}

