/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.etlserver.proteomics;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.maintenance.IMaintenanceTask;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.etlserver.proteomics.DataSetInfoExtractorForProteinResults;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetBatchUpdateDetails;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PhysicalDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.dto.AtomicEntityOperationDetails;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetBatchUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ProteinResultDataSetParentLinkingTask
implements IMaintenanceTask {
    private static final String PARENT_DATA_SET_CODES_KEY = "parent-data-set-codes".toUpperCase();
    private static final String BASE_EXPERIMENT_KEY = "base-experiment".toUpperCase();
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, ProteinResultDataSetParentLinkingTask.class);
    private final IEncapsulatedOpenBISService service;

    public ProteinResultDataSetParentLinkingTask() {
        this(ServiceProvider.getOpenBISService());
    }

    ProteinResultDataSetParentLinkingTask(IEncapsulatedOpenBISService service) {
        this.service = service;
    }

    public void setUp(String pluginName, Properties properties) {
    }

    public void execute() {
        ArrayList<DataSetBatchUpdatesDTO> dataSetUpdates = new ArrayList<DataSetBatchUpdatesDTO>();
        List projects = this.service.listProjects();
        for (Project project : projects) {
            List experiments = this.service.listExperiments(new ProjectIdentifier(project.getSpace().getCode(), project.getCode()));
            for (Experiment experiment : experiments) {
                List dataSets;
                Map<String, IEntityProperty> propertiesMap = this.getPropertiesMap(experiment);
                String baseExperimentIdentifier = this.tryGetProperty(propertiesMap, BASE_EXPERIMENT_KEY);
                String parentDataSetCodes = this.tryGetProperty(propertiesMap, PARENT_DATA_SET_CODES_KEY);
                List<String> codes = DataSetInfoExtractorForProteinResults.getParentDataSetCodes(parentDataSetCodes, baseExperimentIdentifier, this.service).getDataSetCodes();
                if (codes.isEmpty() || (dataSets = this.service.listDataSetsByExperimentID(experiment.getId().longValue())).isEmpty()) continue;
                for (AbstractExternalData ds : dataSets) {
                    if (!(ds instanceof PhysicalDataSet)) continue;
                    PhysicalDataSet dataSet = (PhysicalDataSet)ds;
                    DataSetBatchUpdatesDTO update = new DataSetBatchUpdatesDTO();
                    update.setDatasetId(new TechId(dataSet.getId()));
                    update.setVersion(dataSet.getVersion());
                    update.setExperimentIdentifierOrNull(ExperimentIdentifierFactory.parse((String)dataSet.getExperiment().getIdentifier()));
                    update.setFileFormatTypeCode(dataSet.getFileFormatType().getCode());
                    update.setProperties(dataSet.getProperties());
                    update.setDatasetCode(dataSet.getCode());
                    update.setModifiedParentDatasetCodesOrNull(codes.toArray(new String[0]));
                    DataSetBatchUpdateDetails details = new DataSetBatchUpdateDetails();
                    details.setParentsUpdateRequested(true);
                    operationLog.info((Object)("Parent data set links of data set " + dataSet.getCode() + " from experiment " + experiment.getIdentifier() + " will be updated."));
                    dataSetUpdates.add(update);
                }
            }
        }
        this.service.performEntityOperations(new AtomicEntityOperationDetails(null, null, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyMap(), Collections.emptyList(), Collections.emptyList(), dataSetUpdates, Collections.emptyList(), Collections.emptyList(), Collections.emptyList()));
        operationLog.info((Object)("Parent data set links for " + dataSetUpdates.size() + " data sets have been updated."));
    }

    private Map<String, IEntityProperty> getPropertiesMap(Experiment experiment) {
        List properties = experiment.getProperties();
        HashMap<String, IEntityProperty> propertiesMap = new HashMap<String, IEntityProperty>();
        for (IEntityProperty property : properties) {
            propertiesMap.put(property.getPropertyType().getCode(), property);
        }
        return propertiesMap;
    }

    private String tryGetProperty(Map<String, IEntityProperty> propertiesMap, String key) {
        IEntityProperty property = propertiesMap.get(key);
        return property == null ? null : property.tryGetAsString();
    }
}

