/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.etlserver.proteomics;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.io.PropertyIOUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

class Util {
    private Util() {
    }

    static IEntityProperty[] getAndCheckProperties(Properties properties, EntityType entityType) {
        ArrayList<String> missingMandatoryProperties = new ArrayList<String>();
        List<IEntityProperty> sampleProperties = Util.getProperties(properties, entityType, missingMandatoryProperties);
        if (!missingMandatoryProperties.isEmpty()) {
            throw new UserFailureException("The following mandatory properties are missed: " + missingMandatoryProperties);
        }
        return sampleProperties.toArray(new IEntityProperty[sampleProperties.size()]);
    }

    static List<IEntityProperty> getProperties(Properties properties, EntityType entityType, List<String> missingMandatoryProperties) {
        ArrayList<IEntityProperty> sampleProperties = new ArrayList<IEntityProperty>();
        List sampleTypePropertyTypes = entityType.getAssignedPropertyTypes();
        for (EntityTypePropertyType entityTypePropertyType : sampleTypePropertyTypes) {
            boolean mandatory = entityTypePropertyType.isMandatory();
            PropertyType propertyType = entityTypePropertyType.getPropertyType();
            String key = propertyType.getCode();
            String value = properties.getProperty(key);
            if (value == null) {
                if (!mandatory) continue;
                missingMandatoryProperties.add(key);
                continue;
            }
            EntityProperty property = new EntityProperty();
            property.setPropertyType(propertyType);
            property.setValue(value);
            sampleProperties.add((IEntityProperty)property);
        }
        return sampleProperties;
    }

    static Properties loadPropertiesFile(File incomingDataSetDirectory, String propertiesFileName) {
        File propertiesFile = new File(incomingDataSetDirectory, propertiesFileName);
        if (!propertiesFile.exists()) {
            throw new UserFailureException("Missing properties file '" + propertiesFileName + "'.");
        }
        if (!propertiesFile.isFile()) {
            throw new UserFailureException("Properties file '" + propertiesFileName + "' is a folder.");
        }
        return PropertyIOUtils.loadProperties((File)propertiesFile);
    }
}

