/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.etlserver.proteomics.dto;

import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.Parameter;
import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.PeptideModification;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType
public class Peptide {
    private String sequence;
    private int charge;
    private double initialProbability;
    private double weight;
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private List<PeptideModification> modifications = new ArrayList<PeptideModification>();

    @XmlAttribute(name="peptide_sequence", required=true)
    public final String getSequence() {
        return this.sequence;
    }

    public final void setSequence(String sequence) {
        this.sequence = sequence;
    }

    @XmlAttribute(name="charge", required=true)
    public final int getCharge() {
        return this.charge;
    }

    public final void setCharge(int charge) {
        this.charge = charge;
    }

    @XmlAttribute(name="initial_probability", required=true)
    public final double getInitialProbability() {
        return this.initialProbability;
    }

    public final void setInitialProbability(double initialProbability) {
        this.initialProbability = initialProbability;
    }

    @XmlAttribute(name="weight")
    public final double getWeight() {
        return this.weight;
    }

    public final void setWeight(double weight) {
        this.weight = weight;
    }

    @XmlElement(name="modification_info", namespace="http://regis-web.systemsbiology.net/protXML")
    public final List<PeptideModification> getModifications() {
        return this.modifications;
    }

    public final void setModifications(List<PeptideModification> modifications) {
        this.modifications = modifications;
    }

    @XmlElement(name="parameter", namespace="http://regis-web.systemsbiology.net/protXML")
    public final List<Parameter> getParameters() {
        return this.parameters;
    }

    public final void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.sequence);
        if (this.charge > 0) {
            builder.append("(");
            int i = 0;
            while (i < this.charge) {
                builder.append('+');
                ++i;
            }
            builder.append(")");
        }
        builder.append("[initialProbability=").append(this.initialProbability);
        builder.append(", weight=").append(this.weight);
        builder.append("]");
        return builder.toString();
    }
}

