/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.shared.dto;

import ch.systemsx.cisd.openbis.plugin.proteomics.shared.dto.ProteinReference;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ProteinWithAbundances
extends ProteinReference {
    private static final long serialVersionUID = 1L;
    private static final double[] EMPTY_ARRAY = new double[0];
    private double coverage;
    private final Map<Long, DoubleArrayList> abundances = new LinkedHashMap<Long, DoubleArrayList>();

    public double getCoverage() {
        return this.coverage;
    }

    public void setCoverage(double coverage) {
        this.coverage = coverage;
    }

    public void addAbundanceFor(long sampleID, double abundance) {
        DoubleArrayList list = this.abundances.get(sampleID);
        if (list == null) {
            list = new DoubleArrayList();
            this.abundances.put(sampleID, list);
        }
        list.add(abundance);
    }

    public Set<Long> getSampleIDs() {
        return this.abundances.keySet();
    }

    public double[] getAbundancesForSample(long sampleID) {
        DoubleArrayList list = this.abundances.get(sampleID);
        return list == null ? EMPTY_ARRAY : list.toDoubleArray();
    }
}

