/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cina.client.util.cli;

import ch.systemsx.cisd.args4j.CmdLineParser;
import ch.systemsx.cisd.cina.client.util.cli.AbstractCinaCommand;
import ch.systemsx.cisd.cina.client.util.v1.ICinaUtilities;
import ch.systemsx.cisd.common.cli.ConsoleClientArguments;
import ch.systemsx.cisd.openbis.dss.client.api.cli.GlobalArguments;
import ch.systemsx.cisd.openbis.dss.client.api.cli.ResultCode;

abstract class AbstractExecutor<A extends GlobalArguments> {
    protected final A arguments;
    private final CmdLineParser parser;
    private final AbstractCinaCommand<A> command;

    AbstractExecutor(AbstractCinaCommand<A> command) {
        this.command = command;
        this.arguments = command.getArguments();
        this.parser = command.getParser();
    }

    final ResultCode execute(String[] args) {
        this.parser.parseArgument(args);
        if (((ConsoleClientArguments)this.arguments).isHelp()) {
            this.command.printUsage(System.out);
            return ResultCode.OK;
        }
        if (!((ConsoleClientArguments)this.arguments).isComplete()) {
            this.command.printUsage(System.err);
            return ResultCode.INVALID_ARGS;
        }
        ICinaUtilities component = null;
        try {
            component = this.command.login();
            if (component == null) {
                ResultCode resultCode = ResultCode.INVALID_UNAME_PASS;
                return resultCode;
            }
            ResultCode resultCode = this.doExecute(component);
            return resultCode;
        }
        finally {
            if (component != null) {
                component.logout();
            }
        }
    }

    protected abstract ResultCode doExecute(ICinaUtilities var1);
}

