/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cina.client.util.cli;

import ch.systemsx.cisd.cina.client.util.v1.ICinaUtilities;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.client.api.v1.FileInfoDssDownloader;
import ch.systemsx.cisd.openbis.dss.client.api.v1.IDataSetDss;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.FileInfoDssDTO;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import java.io.File;
import java.util.HashMap;
import java.util.List;

class BundleDownloader {
    private final ICinaUtilities component;
    private final SampleIdentifier gridIdentifier;
    private final List<String> collectionIdentifierStrings;
    private final File outputDir;
    private final Sample gridSample;
    private final HashMap<String, HashMap<String, DataSet>> sampleDataSetMap = new HashMap();

    BundleDownloader(ICinaUtilities component, String bundleIdentifier, List<String> collectionIdentifierStrings, File outputDir) {
        this.component = component;
        this.outputDir = outputDir;
        this.collectionIdentifierStrings = collectionIdentifierStrings;
        SampleIdentifier userGridIdentifier = SampleIdentifierFactory.parse(bundleIdentifier);
        this.gridSample = this.searchForSample(userGridIdentifier);
        this.gridIdentifier = SampleIdentifierFactory.parse(this.gridSample.getIdentifier());
    }

    public void download() {
        this.buildSampleDataSetMap();
        this.downloadDataSets();
    }

    private void buildSampleDataSetMap() {
        List<DataSet> dataSets = this.component.listDataSetsForSample(this.gridSample, false);
        for (DataSet dataSet : dataSets) {
            String typeCode;
            String sampleIdentifierString = dataSet.getSampleIdentifierOrNull();
            if (sampleIdentifierString == null) continue;
            HashMap<String, DataSet> dataSetTypeMap = this.getOrCreateDataSetTypeMap(sampleIdentifierString);
            DataSet oldValue = dataSetTypeMap.get(typeCode = dataSet.getDataSetTypeCode());
            if (oldValue == null) {
                dataSetTypeMap.put(typeCode, dataSet);
                continue;
            }
            dataSetTypeMap.put(typeCode, this.compareReturningMoreRecent(oldValue, dataSet));
        }
    }

    private void downloadDataSets() {
        for (String sampleIdentifierString : this.sampleDataSetMap.keySet()) {
            if (!this.shouldCollectionBeIncluded(sampleIdentifierString)) continue;
            HashMap<String, DataSet> dataSetTypeMap = this.sampleDataSetMap.get(sampleIdentifierString);
            for (String dataSetType : dataSetTypeMap.keySet()) {
                DataSet dataSet = dataSetTypeMap.get(dataSetType);
                String typeCode = dataSet.getDataSetTypeCode();
                if (typeCode.equals("RAW_IMAGES")) {
                    this.downloadDataSet(dataSet, "RawData");
                    continue;
                }
                if (!typeCode.equals("METADATA")) continue;
                if (sampleIdentifierString.equals(this.gridIdentifier.toString())) {
                    this.downloadDataSet(dataSet, null);
                    continue;
                }
                this.downloadDataSet(dataSet, "Annotations");
            }
        }
    }

    private boolean shouldCollectionBeIncluded(String sampleIdentifierString) {
        if (this.collectionIdentifierStrings.isEmpty()) {
            return true;
        }
        if (sampleIdentifierString.equals(this.gridIdentifier.toString())) {
            return true;
        }
        return this.collectionIdentifierStrings.contains(sampleIdentifierString);
    }

    private HashMap<String, DataSet> getOrCreateDataSetTypeMap(String sampleIdentifierString) {
        HashMap<String, DataSet> dataSetTypeMap = this.sampleDataSetMap.get(sampleIdentifierString);
        if (dataSetTypeMap == null) {
            dataSetTypeMap = new HashMap();
            this.sampleDataSetMap.put(sampleIdentifierString, dataSetTypeMap);
        }
        return dataSetTypeMap;
    }

    private DataSet compareReturningMoreRecent(DataSet mostRecentReplicaMetadata, DataSet dataSet) {
        if (mostRecentReplicaMetadata == null) {
            return dataSet;
        }
        if (mostRecentReplicaMetadata.getRegistrationDate().compareTo(dataSet.getRegistrationDate()) < 0) {
            return dataSet;
        }
        return mostRecentReplicaMetadata;
    }

    private Sample searchForSample(SampleIdentifier identifier) {
        SearchCriteria searchCriteria = new SearchCriteria();
        searchCriteria.addMatchClause(SearchCriteria.MatchClause.createAttributeMatch(SearchCriteria.MatchClauseAttribute.CODE, identifier.getSampleCode()));
        List<Sample> samples = this.component.searchForSamples(searchCriteria);
        if (samples.size() < 1) {
            throw new UserFailureException("No sample with specified code.");
        }
        if (samples.size() > 1) {
            throw new EnvironmentFailureException("Found multiple matching samples -- this should not happen. Please contact administrator to resolve this problem.");
        }
        return samples.get(0);
    }

    private void downloadDataSet(DataSet dataSet, String subfolderNameOrNull) {
        IDataSetDss dataSetDss = this.component.getDataSet(dataSet.getCode());
        FileInfoDssDTO[] fileInfos = dataSetDss.listFiles("original/", true);
        File targetDir = subfolderNameOrNull != null ? new File(this.outputDir, subfolderNameOrNull) : this.outputDir;
        FileInfoDssDownloader downloader = new FileInfoDssDownloader(dataSetDss, fileInfos, targetDir, new DownloaderListener(targetDir));
        downloader.downloadFiles();
    }

    private static class DownloaderListener
    implements FileInfoDssDownloader.FileInfoDssDownloaderListener {
        private final File targetDir;

        DownloaderListener(File targetDir) {
            this.targetDir = targetDir;
        }

        @Override
        public void willDownload(FileInfoDssDTO fileInfo) {
            System.out.println("downloading " + this.getPathForFileInfo(fileInfo));
        }

        @Override
        public void willCreateDirectory(FileInfoDssDTO fileInfo) {
            System.out.println("mkdir " + this.getPathForFileInfo(fileInfo));
        }

        @Override
        public void didFinish() {
            System.out.println("Finished.");
        }

        private String getPathForFileInfo(FileInfoDssDTO fileInfo) {
            return String.valueOf(this.targetDir.getPath()) + "/" + fileInfo.getPathInListing();
        }
    }
}

