/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cina.client.util.cli;

import ch.systemsx.cisd.cina.client.util.cli.CommandExperimentLister;
import ch.systemsx.cisd.cina.client.util.cli.CommandGenerateSampleCode;
import ch.systemsx.cisd.cina.client.util.cli.CommandGetBundle;
import ch.systemsx.cisd.cina.client.util.cli.CommandGetReplica;
import ch.systemsx.cisd.cina.client.util.cli.CommandPreferencesLister;
import ch.systemsx.cisd.cina.client.util.cli.CommandSampleLister;
import ch.systemsx.cisd.openbis.dss.client.api.cli.AbstractCommandFactory;
import ch.systemsx.cisd.openbis.dss.client.api.cli.ICommand;
import java.util.Arrays;
import java.util.List;

public class CinaCommandFactory
extends AbstractCommandFactory {
    static final String PROGRAM_CALL_STRING = "cina_client.sh";

    @Override
    public List<String> getKnownCommands() {
        String[] commands = new String[]{"listsamps", "gencode", "listexps", "getreplica", "getbundle", "listprefs"};
        return Arrays.asList(commands);
    }

    @Override
    public ICommand getHelpCommand() {
        return this.getHelpCommand(PROGRAM_CALL_STRING);
    }

    @Override
    public ICommand tryCommandForName(String name) {
        ICommand result;
        Command command;
        ICommand helpCommandOrNull = this.tryHelpCommandForName(name);
        if (helpCommandOrNull != null) {
            return helpCommandOrNull;
        }
        try {
            command = Command.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        switch (command) {
            case LISTSAMPS: {
                result = new CommandSampleLister();
                break;
            }
            case GENCODE: {
                result = new CommandGenerateSampleCode();
                break;
            }
            case LISTEXPS: {
                result = new CommandExperimentLister();
                break;
            }
            case GETREPLICA: {
                result = new CommandGetReplica();
                break;
            }
            case GETBUNDLE: {
                result = new CommandGetBundle();
                break;
            }
            case LISTPREFS: {
                result = new CommandPreferencesLister();
                break;
            }
            case HELP: {
                result = this.getHelpCommand();
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    private static enum Command {
        LISTSAMPS,
        GENCODE,
        LISTEXPS,
        GETREPLICA,
        GETBUNDLE,
        LISTPREFS,
        HELP;

    }
}

