/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cina.client.util.cli;

import ch.systemsx.cisd.args4j.Option;
import ch.systemsx.cisd.cina.client.util.cli.AbstractCinaCommand;
import ch.systemsx.cisd.cina.client.util.cli.AbstractExecutor;
import ch.systemsx.cisd.cina.client.util.cli.ReplicaDownloader;
import ch.systemsx.cisd.cina.client.util.v1.ICinaUtilities;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.client.api.cli.GlobalArguments;
import ch.systemsx.cisd.openbis.dss.client.api.cli.ResultCode;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class CommandGetReplica
extends AbstractCinaCommand<CommandGetReplicaArguments> {
    public CommandGetReplica() {
        super(new CommandGetReplicaArguments());
    }

    @Override
    public ResultCode execute(String[] args) throws UserFailureException, EnvironmentFailureException {
        return new GetReplicaExecutor(this).execute(args);
    }

    @Override
    public String getName() {
        return "getreplica";
    }

    @Override
    protected String getRequiredArgumentsString() {
        return "<replica identifier> [<replica identifier> ...]";
    }

    static class CommandGetReplicaArguments
    extends GlobalArguments {
        @Option(name="o", longName="output", usage="Path for output")
        private String output = "";

        CommandGetReplicaArguments() {
        }

        public ArrayList<String> getReplicaIdentifiers() {
            ArrayList<String> replicaIds = new ArrayList<String>();
            List<String> args = this.getArguments();
            int size = args.size();
            int i = 0;
            while (i < size) {
                String replicaId = args.get(i);
                if (replicaId.length() > 0) {
                    replicaIds.add(replicaId.toUpperCase());
                }
                ++i;
            }
            return replicaIds;
        }

        public String getOutput() {
            return this.output;
        }

        @Override
        public boolean allAdditionalMandatoryArgumentsPresent() {
            if (this.getArguments().size() < 1) {
                return false;
            }
            return this.getReplicaIdentifiers().size() >= 1;
        }
    }

    private static class GetReplicaExecutor
    extends AbstractExecutor<CommandGetReplicaArguments> {
        GetReplicaExecutor(CommandGetReplica command) {
            super(command);
        }

        @Override
        protected ResultCode doExecute(ICinaUtilities component) {
            File outputDir = this.getOutputDir();
            outputDir.mkdirs();
            for (String sampleIdentifier : ((CommandGetReplicaArguments)this.arguments).getReplicaIdentifiers()) {
                ReplicaDownloader downloader = new ReplicaDownloader(component, sampleIdentifier, outputDir);
                downloader.download();
            }
            return ResultCode.OK;
        }

        private File getOutputDir() {
            File outputDir = ((CommandGetReplicaArguments)this.arguments).getOutput().length() > 0 ? new File(((CommandGetReplicaArguments)this.arguments).getOutput()) : new File(".");
            return outputDir;
        }
    }
}

