/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.utils;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.ITabularData;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeNormalizer;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class DatasetFileLines
implements ITabularData {
    private final String[] headerTokens;
    private final String[] headerCodes;
    private final List<String[]> dataLines;
    private final File file;

    public DatasetFileLines(File file, DatasetDescription dataset, List<String[]> lines) {
        this(file, dataset.getDataSetCode(), lines);
    }

    public DatasetFileLines(File file, String datasetCode, List<String[]> lines) {
        this(file, datasetCode, lines, false);
    }

    public DatasetFileLines(File file, String datasetCode, List<String[]> lines, boolean ignoreTrailingEmptyCells) {
        this.file = file;
        if (lines.size() < 2) {
            throw UserFailureException.fromTemplate("Data Set '%s' file should have at least 2 lines instead of %s.", datasetCode, lines.size());
        }
        this.headerTokens = lines.get(0);
        this.headerCodes = new String[this.headerTokens.length];
        int i = 0;
        while (i < this.headerCodes.length) {
            this.headerCodes[i] = CodeNormalizer.normalize(this.headerTokens[i]);
            ++i;
        }
        this.dataLines = new ArrayList<String[]>(lines.size());
        i = 1;
        while (i < lines.size()) {
            String[] dataTokens = this.getTokens(lines.get(i), ignoreTrailingEmptyCells);
            if (this.headerTokens.length != dataTokens.length) {
                throw UserFailureException.fromTemplate("Number of columns in header (%s) does not match number of columns in %d. data row (%s) in Data Set '%s' file.", this.headerTokens.length, i, dataTokens.length, datasetCode);
            }
            this.dataLines.add(dataTokens);
            ++i;
        }
    }

    private String[] getTokens(String[] dataTokens, boolean ignoreTrailingEmptyCells) {
        if (ignoreTrailingEmptyCells) {
            int indexOfLastNonEmptyCell = dataTokens.length - 1;
            while (indexOfLastNonEmptyCell >= this.headerTokens.length && StringUtils.isBlank((String)dataTokens[indexOfLastNonEmptyCell])) {
                --indexOfLastNonEmptyCell;
            }
            String[] newDataTopkens = new String[indexOfLastNonEmptyCell + 1];
            System.arraycopy(dataTokens, 0, newDataTopkens, 0, newDataTopkens.length);
            return newDataTopkens;
        }
        return dataTokens;
    }

    public final File getFile() {
        return this.file;
    }

    @Override
    public String[] getHeaderLabels() {
        return this.headerTokens;
    }

    @Override
    public String[] getHeaderCodes() {
        return this.headerCodes;
    }

    @Override
    public List<String[]> getDataLines() {
        return this.dataLines;
    }
}

