/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto.identifier;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.AbstractIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifierFactory;
import java.util.ArrayList;
import java.util.List;

public final class ExperimentIdentifierFactory
extends AbstractIdentifierFactory {
    public ExperimentIdentifierFactory(String textToParse) {
        super(textToParse);
    }

    public final ExperimentIdentifier createIdentifier() throws UserFailureException {
        return ExperimentIdentifierFactory.parse(this.getTextToParse(), null);
    }

    public final ExperimentIdentifier createIdentifier(String defaultSpace) throws UserFailureException {
        return ExperimentIdentifierFactory.parse(this.getTextToParse(), defaultSpace);
    }

    public static ExperimentIdentifier parse(String text) {
        return ExperimentIdentifierFactory.parse(text, null);
    }

    public static ExperimentIdentifier parse(String text, String defaultSpace) {
        AbstractIdentifierFactory.TokenLexer lexer = new AbstractIdentifierFactory.TokenLexer(text);
        ProjectIdentifier parentIdentifier = ProjectIdentifierFactory.parseIdentifier(lexer, defaultSpace);
        String code = ExperimentIdentifierFactory.assertValidCode(lexer.next());
        lexer.ensureNoTokensLeft();
        return ExperimentIdentifierFactory.create(parentIdentifier, code);
    }

    public static List<ExperimentIdentifier> parse(List<String> texts) {
        ArrayList<ExperimentIdentifier> identifiers = new ArrayList<ExperimentIdentifier>();
        for (String identifierString : texts) {
            identifiers.add(ExperimentIdentifierFactory.parse(identifierString, null));
        }
        return identifiers;
    }

    private static ExperimentIdentifier create(ProjectIdentifier parent, String code) {
        return new ExperimentIdentifier(parent, code);
    }

    public static String getSchema() {
        return String.valueOf(ProjectIdentifierFactory.getSchema()) + '/' + "<experiment-code>";
    }
}

