/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.client.api.v1;

import ch.systemsx.cisd.openbis.generic.shared.api.v1.IGeneralInformationService;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Role;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SpaceWithProjectsAndRoleAssignments;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.api.v1.IProteomicsDataApiFacade;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.api.v1.IProteomicsDataService;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.api.v1.dto.DataSet;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.api.v1.dto.DataStoreServerProcessingPluginInfo;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.api.v1.dto.Experiment;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.api.v1.dto.MsInjectionDataInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ProteomicsDataApiFacade
implements IProteomicsDataApiFacade {
    private static final String USER_ROLE_SET = "SPACE_USER";
    private final IProteomicsDataService service;
    private final IGeneralInformationService generalInfoService;
    private final String sessionToken;

    ProteomicsDataApiFacade(IProteomicsDataService service, IGeneralInformationService generalInfoService, String sessionToken) {
        this.service = service;
        this.generalInfoService = generalInfoService;
        this.sessionToken = sessionToken;
    }

    @Override
    public String getSessionToken() {
        return this.sessionToken;
    }

    @Override
    public List<DataStoreServerProcessingPluginInfo> listDataStoreServerProcessingPluginInfos() {
        return this.service.listDataStoreServerProcessingPluginInfos(this.sessionToken);
    }

    @Override
    public List<MsInjectionDataInfo> listRawDataSamples(String userID) {
        return this.service.listRawDataSamples(this.sessionToken, userID);
    }

    @Override
    public void processingRawData(String userID, String dataSetProcessingKey, long[] rawDataSampleIDs, String dataSetType) {
        this.service.processingRawData(this.sessionToken, userID, dataSetProcessingKey, rawDataSampleIDs, dataSetType);
    }

    @Override
    public void processDataSets(String userID, String dataSetProcessingKey, List<String> dataSetCodes) {
        this.service.processDataSets(this.sessionToken, userID, dataSetProcessingKey, dataSetCodes);
    }

    @Override
    public List<Project> listProjects(String userID) {
        Map<String, Set<Role>> namedRoleSets = this.generalInfoService.listNamedRoleSets(this.sessionToken);
        Set<Role> allowedRoles = namedRoleSets.get(USER_ROLE_SET);
        if (allowedRoles == null) {
            throw new IllegalStateException("Role set SPACE_USER not known.");
        }
        List<SpaceWithProjectsAndRoleAssignments> spaces = this.generalInfoService.listSpacesWithProjectsAndRoleAssignments(this.sessionToken, null);
        ArrayList<Project> projects = new ArrayList<Project>();
        for (SpaceWithProjectsAndRoleAssignments space : spaces) {
            Set<Role> roles = space.getRoles(userID);
            roles.retainAll(allowedRoles);
            if (roles.isEmpty()) continue;
            for (Project project : space.getProjects()) {
                projects.add(new Project(project.getId(), project.getPermId(), space.getCode(), project.getCode()));
            }
        }
        return projects;
    }

    @Override
    public List<Experiment> listSearchExperiments(String userID) {
        return this.service.listSearchExperiments(this.sessionToken, userID);
    }

    @Override
    public List<Experiment> listExperiments(String sessionToken, String userID, String experimentTypeCode) {
        return this.service.listExperiments(sessionToken, userID, experimentTypeCode);
    }

    @Override
    public List<DataSet> listDataSetsByExperiment(String userID, long experimentID) {
        return this.service.listDataSetsByExperiment(this.sessionToken, userID, experimentID);
    }

    @Override
    public void processSearchData(String userID, String dataSetProcessingKey, long[] searchExperimentIDs) {
        this.service.processSearchData(this.sessionToken, userID, dataSetProcessingKey, searchExperimentIDs);
    }

    @Override
    public void processProteinResultDataSets(String sessionToken, String userID, String dataSetProcessingKey, String experimentTypeCode, long[] experimentIDs) {
        this.service.processProteinResultDataSets(sessionToken, userID, dataSetProcessingKey, experimentTypeCode, experimentIDs);
    }

    @Override
    public void logout() {
        this.generalInfoService.logout(this.sessionToken);
    }
}

