/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.api.v1.dto;

import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.EntityTypeInitializer;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.InitializingChecks;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.PropertyTypeGroup;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.ValidationPluginInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class EntityType
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String code;
    private String description;
    private ValidationPluginInfo validationPluginInfo;
    private List<PropertyTypeGroup> propertyTypeGroups;

    EntityType(EntityTypeInitializer initializer) {
        InitializingChecks.checkValidString(initializer.getCode(), "Unspecified code.");
        this.code = initializer.getCode();
        this.description = initializer.getDescription();
        this.validationPluginInfo = initializer.getValidationPluginInfo();
        this.propertyTypeGroups = Collections.unmodifiableList(initializer.getPropertyTypeGroups());
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public ValidationPluginInfo getValidationPluginInfo() {
        return this.validationPluginInfo;
    }

    public List<PropertyTypeGroup> getPropertyTypeGroups() {
        return this.propertyTypeGroups;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EntityType)) {
            return false;
        }
        EqualsBuilder builder = new EqualsBuilder();
        EntityType other = (EntityType)obj;
        builder.append((Object)this.getCode(), (Object)other.getCode());
        return builder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getCode());
        return builder.toHashCode();
    }

    EntityType() {
    }

    private void setCode(String code) {
        this.code = code;
    }

    private void setDescription(String description) {
        this.description = description;
    }

    private void setValidationPluginInfo(ValidationPluginInfo validationPluginInfo) {
        this.validationPluginInfo = validationPluginInfo;
    }

    private void setPropertyTypeGroups(ArrayList<PropertyTypeGroup> propertyTypeGroups) {
        this.propertyTypeGroups = propertyTypeGroups;
    }
}

