/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import java.io.Serializable;
import java.util.Map;

public class CustomImport
implements Serializable {
    private static final long serialVersionUID = 35L;
    private String code;
    private Map<String, String> properties;

    public CustomImport() {
    }

    public CustomImport(String code, Map<String, String> properties) {
        this.code = code;
        this.properties = properties;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String name) {
        this.code = name;
    }

    public String getProperty(String propertyName) {
        if (this.properties == null) {
            return null;
        }
        String propertyValue = this.properties.get(propertyName);
        if (propertyValue == null || propertyValue.trim().length() == 0) {
            return null;
        }
        return propertyValue.trim();
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public static enum PropertyNames {
        CUSTOM_IMPORTS("custom-imports"),
        NAME("name"),
        DATASTORE_CODE("dss-code"),
        DROPBOX_NAME("dropbox-name"),
        DESCRIPTION("description"),
        TEMPLATE_ENTITY_KIND("template-entity-kind"),
        TEMPLATE_ENTITY_PERMID("template-entity-permid"),
        TEMPLATE_ATTACHMENT_NAME("template-attachment-name");

        private final String name;

        private PropertyNames(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

