/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDeletedDataSetLocation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class DeletedDataSetLocation
implements IDeletedDataSetLocation,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String SEPARATOR_BETWEEN_LOCATIONS = ", ";
    private static final String SEPARATOR_BETWEEN_PARTS = "/";
    private String datastoreCode;
    private String shareId;
    private String location;

    @Override
    public String getDatastoreCode() {
        return this.datastoreCode;
    }

    public void setDatastoreCode(String datastoreCode) {
        this.datastoreCode = datastoreCode;
    }

    @Override
    public String getShareId() {
        return this.shareId;
    }

    public void setShareId(String shareId) {
        this.shareId = shareId;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public boolean isEmpty() {
        return this.getDatastoreCode() == null && this.getShareId() == null && this.getLocation() == null;
    }

    public static String format(List<DeletedDataSetLocation> locationObjects) {
        if (locationObjects == null || locationObjects.isEmpty()) {
            return "";
        }
        StringBuilder locationString = new StringBuilder();
        Iterator<DeletedDataSetLocation> iter = locationObjects.iterator();
        while (iter.hasNext()) {
            locationString.append(DeletedDataSetLocation.format(iter.next()));
            if (!iter.hasNext()) continue;
            locationString.append(SEPARATOR_BETWEEN_LOCATIONS);
        }
        return locationString.toString();
    }

    private static String format(DeletedDataSetLocation locationObject) {
        if (locationObject.isEmpty()) {
            return "";
        }
        String datastoreCode = StringUtils.emptyIfNull(locationObject.getDatastoreCode());
        String shareId = StringUtils.emptyIfNull(locationObject.getShareId());
        String location = StringUtils.emptyIfNull(locationObject.getLocation());
        StringBuilder locationString = new StringBuilder();
        locationString.append(SEPARATOR_BETWEEN_PARTS + datastoreCode);
        locationString.append(SEPARATOR_BETWEEN_PARTS + shareId);
        locationString.append(SEPARATOR_BETWEEN_PARTS + location);
        return locationString.toString();
    }

    public static List<DeletedDataSetLocation> parse(String str) {
        String[] locationStrings;
        if (str == null) {
            return Collections.emptyList();
        }
        ArrayList<DeletedDataSetLocation> locationObjects = new ArrayList<DeletedDataSetLocation>();
        String[] stringArray = locationStrings = str.split(SEPARATOR_BETWEEN_LOCATIONS, -1);
        int n = locationStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String locationString = stringArray[n2];
            DeletedDataSetLocation locationObject = new DeletedDataSetLocation();
            if (locationString.startsWith(SEPARATOR_BETWEEN_PARTS)) {
                String[] locationParts = locationString.split(SEPARATOR_BETWEEN_PARTS);
                Iterator<String> locationPartsIter = Arrays.asList(locationParts).iterator();
                locationPartsIter.next();
                if (locationPartsIter.hasNext()) {
                    locationObject.setDatastoreCode(StringUtils.nullIfBlank(locationPartsIter.next()));
                }
                if (locationPartsIter.hasNext()) {
                    locationObject.setShareId(StringUtils.nullIfBlank(locationPartsIter.next()));
                }
                if (locationPartsIter.hasNext()) {
                    StringBuilder location = new StringBuilder();
                    while (locationPartsIter.hasNext()) {
                        location.append(locationPartsIter.next());
                        if (!locationPartsIter.hasNext()) continue;
                        location.append(SEPARATOR_BETWEEN_PARTS);
                    }
                    locationObject.setLocation(StringUtils.nullIfBlank(location.toString()));
                }
            } else {
                locationObject.setLocation(StringUtils.nullIfBlank(locationString));
            }
            locationObjects.add(locationObject);
            ++n2;
        }
        return locationObjects;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.getDatastoreCode());
        builder.append(this.getShareId());
        builder.append(this.getLocation());
        return builder.toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeletedDataSetLocation other = (DeletedDataSetLocation)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append(this.getDatastoreCode(), other.getDatastoreCode());
        builder.append(this.getShareId(), other.getShareId());
        builder.append(this.getLocation(), other.getLocation());
        return builder.isEquals();
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("datastoreCode", this.getDatastoreCode());
        builder.append("shareId", this.getShareId());
        builder.append("location", this.getLocation());
        return builder.toString();
    }
}

