/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.api.v1;

import ch.systemsx.cisd.openbis.plugin.screening.client.api.v1.IScreeningOpenbisServiceFacade;
import ch.systemsx.cisd.openbis.plugin.screening.client.api.v1.ScreeningOpenbisServiceFacadeFactory;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVectorDatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Plate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;

public class AnalysisProcedureTest {
    private final IScreeningOpenbisServiceFacade facade;
    private final String permIdOfPlateInterest;
    private final String analysisProcedure;

    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            System.err.println("Usage: <user> <password> <openbis-server-url>");
            System.err.println("Example parameters: test-user my-password http://localhost:8888");
            System.exit(1);
            return;
        }
        AnalysisProcedureTest.configureLogging();
        String userId = args[0];
        String userPassword = args[1];
        String serverUrl = args[2];
        AnalysisProcedureTest.print(String.format("Connecting to the server '%s' as a user '%s.", serverUrl, userId));
        IScreeningOpenbisServiceFacade facade = ScreeningOpenbisServiceFacadeFactory.tryCreate(userId, userPassword, serverUrl);
        if (facade == null) {
            System.err.println("Authentication failed: check the user name and password.");
            System.exit(1);
            return;
        }
        AnalysisProcedureTest newMe = new AnalysisProcedureTest(facade, "20110203094807621-79771", "proc1");
        newMe.runTest();
        newMe.logout();
    }

    private AnalysisProcedureTest(IScreeningOpenbisServiceFacade facade, String permIdOfInterest, String analysisProcedure) {
        this.facade = facade;
        this.permIdOfPlateInterest = permIdOfInterest;
        this.analysisProcedure = analysisProcedure;
    }

    public void runTest() throws IOException {
        AnalysisProcedureTest.print("Listing all analysis procedures...");
        List<String> allAnalysisProcedures = this.listAllAnalysisProcedures();
        AnalysisProcedureTest.print("\t" + allAnalysisProcedures);
        AnalysisProcedureTest.print("Done.");
        List<Plate> plates = this.findPlates();
        List<FeatureVectorDatasetReference> allFeatureVectorsForPlate = this.facade.listFeatureVectorDatasets(plates);
        List<FeatureVectorDatasetReference> featureVectorMatchingAnalysisProcedure = this.facade.listFeatureVectorDatasets(plates, this.analysisProcedure);
        AnalysisProcedureTest.print("Out of " + allFeatureVectorsForPlate.size() + " feature vector data sets found " + featureVectorMatchingAnalysisProcedure.size() + "  data set(s) matching the procedure \"" + this.analysisProcedure + "\"");
        for (FeatureVectorDatasetReference dataSet : featureVectorMatchingAnalysisProcedure) {
            AnalysisProcedureTest.print("\t" + dataSet.getDatasetCode());
        }
        AnalysisProcedureTest.print("Finished.");
    }

    private List<String> listAllAnalysisProcedures() {
        ArrayList<String> allAnalysisProcedures = new ArrayList<String>();
        for (ExperimentIdentifier experimentIdentifier : this.facade.listExperiments()) {
            allAnalysisProcedures.addAll(this.facade.listAnalysisProcedures(experimentIdentifier));
        }
        return allAnalysisProcedures;
    }

    private List<Plate> findPlates() {
        AnalysisProcedureTest.print("Looking for plates...");
        List<Plate> plates = this.facade.listPlates();
        ArrayList<Plate> platesOfInterest = new ArrayList<Plate>();
        for (Plate plate : plates) {
            if (!plate.getPermId().equals(this.permIdOfPlateInterest)) continue;
            platesOfInterest.add(plate);
            break;
        }
        AnalysisProcedureTest.print("...found " + platesOfInterest.size() + " plate(s).");
        return platesOfInterest;
    }

    public void logout() {
        this.facade.logout();
    }

    private static void print(String msg) {
        System.out.println(new Date() + "\t" + msg);
    }

    private static void configureLogging() {
        Properties props = new Properties();
        props.put("log4j.appender.STDOUT", "org.apache.log4j.ConsoleAppender");
        props.put("log4j.appender.STDOUT.layout", "org.apache.log4j.PatternLayout");
        props.put("log4j.appender.STDOUT.layout.ConversionPattern", "%d %-5p [%t] %c - %m%n");
        props.put("log4j.rootLogger", "INFO, STDOUT");
        PropertyConfigurator.configure(props);
    }
}

