/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.servlet;

import ch.systemsx.cisd.common.server.IRemoteHostProvider;
import ch.systemsx.cisd.common.servlet.IRequestContextProvider;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public final class RequestContextProviderAdapter
implements IRemoteHostProvider {
    private final IRequestContextProvider requestContextProvider;

    public RequestContextProviderAdapter(IRequestContextProvider requestContextProvider) {
        assert (requestContextProvider != null) : "Undefined IRequestContextProvider.";
        this.requestContextProvider = requestContextProvider;
    }

    @Override
    public final String getRemoteHost() {
        HttpServletRequest request = this.requestContextProvider.getHttpServletRequest();
        if (request == null) {
            return "UNKNOWN";
        }
        String remoteHost = request.getRemoteHost();
        if (StringUtils.isEmpty(remoteHost)) {
            return StringUtils.defaultIfEmpty(request.getRemoteAddr(), "UNKNOWN");
        }
        return remoteHost;
    }
}

