/*
 * Decompiled with CFR 0.152.
 */
package com.marathon.util.spring;

import com.marathon.util.spring.StreamSupportingRemoteInvocation;
import com.marathon.util.spring.StreamSupportingRemoteInvocationResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.remoting.httpinvoker.CommonsHttpInvokerRequestExecutor;
import org.springframework.remoting.httpinvoker.HttpInvokerClientConfiguration;
import org.springframework.remoting.rmi.CodebaseAwareObjectInputStream;
import org.springframework.remoting.support.RemoteInvocation;
import org.springframework.remoting.support.RemoteInvocationResult;

public class StreamSupportingHttpInvokerRequestExecutor
extends CommonsHttpInvokerRequestExecutor {
    private static final Log log = LogFactory.getLog(StreamSupportingHttpInvokerRequestExecutor.class);
    public static final String CONTENT_TYPE_SERIALIZED_OBJECT_WITH_STREAM = "application/x-java-serialized-object-with-stream";

    protected ByteArrayOutputStream getByteArrayOutputStream(RemoteInvocation invocation) throws IOException {
        WorkaroundByteArrayOutputStream baos = new WorkaroundByteArrayOutputStream(1024, invocation);
        this.writeRemoteInvocation(invocation, baos);
        return baos;
    }

    protected RemoteInvocationResult doExecuteRequest(HttpInvokerClientConfiguration config, ByteArrayOutputStream baos) throws IOException, ClassNotFoundException {
        WorkaroundByteArrayOutputStream wbaos = (WorkaroundByteArrayOutputStream)baos;
        if (wbaos.getRemoteInvocation() instanceof StreamSupportingRemoteInvocation) {
            return this.doExecuteRequest(config, wbaos, (StreamSupportingRemoteInvocation)wbaos.getRemoteInvocation());
        }
        return super.doExecuteRequest(config, baos);
    }

    protected RemoteInvocationResult readRemoteInvocationResult(InputStream is, String codebaseUrl) throws IOException, ClassNotFoundException {
        RemoteInvocationResult ret = super.readRemoteInvocationResult(is, codebaseUrl);
        if (!(ret instanceof StreamSupportingRemoteInvocationResult)) {
            is.close();
        }
        return ret;
    }

    protected ObjectInputStream createObjectInputStream(InputStream is, String codebaseUrl) throws IOException {
        return new SourceStreamPreservingObjectInputStream(is, codebaseUrl);
    }

    protected RemoteInvocationResult doReadRemoteInvocationResult(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        RemoteInvocationResult source = super.doReadRemoteInvocationResult(ois);
        if (source instanceof StreamSupportingRemoteInvocationResult) {
            ((StreamSupportingRemoteInvocationResult)source).setClientSideInputStream(((SourceStreamPreservingObjectInputStream)ois).getSourceInputStream());
        }
        return source;
    }

    protected RemoteInvocationResult doExecuteRequest(HttpInvokerClientConfiguration config, ByteArrayOutputStream baos, StreamSupportingRemoteInvocation invocation) throws IOException, ClassNotFoundException {
        PostMethod postMethod;
        InputStream body;
        ByteArrayInputStream serializedInvocation = new ByteArrayInputStream(baos.toByteArray());
        if (invocation.getClientSideInputStream() != null) {
            body = new CompositeInputStream(new InputStream[]{serializedInvocation, new CloseShieldedInputStream(invocation.getClientSideInputStream())});
            postMethod = this.createPostMethodForStreaming(config);
        } else {
            body = serializedInvocation;
            postMethod = this.createPostMethod(config);
        }
        boolean delayReleaseConnection = false;
        try {
            postMethod.setRequestEntity(new InputStreamRequestEntity(body));
            this.executePostMethod(config, this.getHttpClient(), postMethod);
            RemoteInvocationResult ret = this.readRemoteInvocationResult(postMethod.getResponseBodyAsStream(), config.getCodebaseUrl());
            if (ret instanceof StreamSupportingRemoteInvocationResult) {
                InputStream sourceRetIs;
                StreamSupportingRemoteInvocationResult ssrir = (StreamSupportingRemoteInvocationResult)ret;
                if (invocation.getClientSideInputStream() != null) {
                    if (ssrir.getMethodClosedParamInputStream() != null) {
                        if (Boolean.TRUE.equals(ssrir.getMethodClosedParamInputStream())) {
                            invocation.getClientSideInputStream().close();
                        }
                    } else {
                        this.warnInputStreamParameterStateNotSpecified(invocation);
                    }
                }
                if (ssrir.getHasReturnStream() && (sourceRetIs = ssrir.getClientSideInputStream()) != null) {
                    ssrir.setClientSideInputStream(new FilterInputStream(sourceRetIs){

                        public void close() throws IOException {
                            super.close();
                            postMethod.releaseConnection();
                        }
                    });
                    delayReleaseConnection = true;
                }
            } else if (invocation.getClientSideInputStream() != null) {
                this.warnInputStreamParameterStateNotSpecified(invocation);
            }
            RemoteInvocationResult remoteInvocationResult = ret;
            return remoteInvocationResult;
        }
        finally {
            if (!delayReleaseConnection) {
                postMethod.releaseConnection();
            }
        }
    }

    private void warnInputStreamParameterStateNotSpecified(StreamSupportingRemoteInvocation invocation) {
        log.warn("Remote method invocation with InputStream parameter did not indicate if remote method closed the InputStream parameter!  Will leave the stream open.  RemoteInvocation: " + invocation);
    }

    protected PostMethod createPostMethodForStreaming(HttpInvokerClientConfiguration config) throws IOException {
        PostMethod postMethod = new PostMethod(config.getServiceUrl());
        postMethod.setRequestHeader("Content-Type", CONTENT_TYPE_SERIALIZED_OBJECT_WITH_STREAM);
        postMethod.setContentChunked(true);
        return postMethod;
    }

    public static class CloseShieldedInputStream
    extends FilterInputStream {
        public CloseShieldedInputStream(InputStream in) {
            super(in);
        }

        public void close() throws IOException {
        }
    }

    public static class CompositeInputStream
    extends FilterInputStream {
        private InputStream[] inputStreams;
        private int currentInputStreamIdx;

        public CompositeInputStream(InputStream[] inputStreams) {
            super(inputStreams[0]);
            this.inputStreams = inputStreams;
            this.currentInputStreamIdx = 0;
        }

        public InputStream[] getInputStreams() {
            return this.inputStreams;
        }

        public int getCurrentInputStreamIdx() {
            return this.currentInputStreamIdx;
        }

        protected InputStream incCurrentInputStream() throws IOException {
            if (++this.currentInputStreamIdx >= this.getInputStreams().length) {
                return null;
            }
            this.in.close();
            this.in = this.getInputStreams()[this.currentInputStreamIdx];
            return this.in;
        }

        public int read() throws IOException {
            int read = super.read();
            if (read == -1) {
                if (this.incCurrentInputStream() == null) {
                    return -1;
                }
                return this.read();
            }
            return read;
        }

        public int read(byte[] b) throws IOException {
            int read = super.read(b);
            if (read == -1) {
                if (this.incCurrentInputStream() == null) {
                    return -1;
                }
                return this.read(b);
            }
            return read;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int read = super.read(b, off, len);
            if (read == -1) {
                if (this.incCurrentInputStream() == null) {
                    return -1;
                }
                return this.read(b, off, len);
            }
            return read;
        }

        public void close() throws IOException {
            InputStream[] myInputStreams = this.getInputStreams();
            int i = this.getCurrentInputStreamIdx();
            while (i < myInputStreams.length) {
                myInputStreams[i].close();
                ++i;
            }
        }
    }

    public static class SourceStreamPreservingObjectInputStream
    extends CodebaseAwareObjectInputStream {
        private InputStream sourceInputStream;

        public SourceStreamPreservingObjectInputStream(InputStream in, String codebaseUrl) throws IOException {
            super((InputStream)new CloseShieldedInputStream(in), codebaseUrl);
            this.sourceInputStream = in;
        }

        public InputStream getSourceInputStream() {
            return this.sourceInputStream;
        }
    }

    public static class WorkaroundByteArrayOutputStream
    extends ByteArrayOutputStream {
        private final RemoteInvocation remoteInvocation;

        public WorkaroundByteArrayOutputStream(int size, RemoteInvocation remoteInvocation) {
            super(size);
            this.remoteInvocation = remoteInvocation;
        }

        public RemoteInvocation getRemoteInvocation() {
            return this.remoteInvocation;
        }
    }
}

