/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.dbmigration;

import ch.systemsx.cisd.dbmigration.TableDefinition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class TableColumnDefinition
implements Iterable<TableColumnDefinition> {
    private final TableDefinition tableDefinition;
    private boolean primaryKey;
    private long largestPrimaryKey = -1L;
    private TableColumnDefinition foreignKeyReference;
    private String columnName;
    private String dataTypeName;
    private List<TableColumnDefinition> connections = new ArrayList<TableColumnDefinition>();

    public TableColumnDefinition(TableDefinition tableDefinition) {
        this.tableDefinition = tableDefinition;
    }

    public final TableDefinition getTableDefinition() {
        return this.tableDefinition;
    }

    public void addConnection(TableColumnDefinition foreignKeyColumn) {
        if (!this.isPrimaryKey()) {
            throw new IllegalStateException("Can not add connection '" + foreignKeyColumn.getColumnName() + "' to column '" + this.columnName + "'which is not a primary key.");
        }
        foreignKeyColumn.setForeignKeyReference(this);
        this.connections.add(foreignKeyColumn);
    }

    @Override
    public Iterator<TableColumnDefinition> iterator() {
        return this.connections.iterator();
    }

    public final long getLargestPrimaryKey() {
        return this.largestPrimaryKey;
    }

    public final void setLargestPrimaryKey(long nextFreePrimaryKey) {
        this.largestPrimaryKey = nextFreePrimaryKey;
    }

    public final TableColumnDefinition getForeignKeyReference() {
        return this.foreignKeyReference;
    }

    public final void setForeignKeyReference(TableColumnDefinition foreignKeyReference) {
        this.foreignKeyReference = foreignKeyReference;
    }

    public final boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public final void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    public final String getColumnName() {
        return this.columnName;
    }

    public final void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public final String getDataTypeName() {
        return this.dataTypeName;
    }

    public final void setDataTypeName(String dataType) {
        this.dataTypeName = dataType;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TableColumnDefinition)) {
            return false;
        }
        TableColumnDefinition columnDefinition = (TableColumnDefinition)obj;
        return columnDefinition.columnName.equals(this.columnName);
    }

    public int hashCode() {
        return this.columnName.hashCode();
    }

    public String toString() {
        return String.valueOf(this.primaryKey ? "*" : " ") + this.columnName + " " + this.dataTypeName + (this.foreignKeyReference != null ? " (fk) " : " ") + (this.largestPrimaryKey < 0L ? "" : String.valueOf(Long.toString(this.largestPrimaryKey)) + " ") + (this.connections.isEmpty() ? "" : this.connections.toString());
    }
}

