/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.api.v1.impl;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.etlserver.registrator.DataSetRegistrationDetails;
import ch.systemsx.cisd.etlserver.registrator.api.v1.IDataSet;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.AbstractDataSetImmutable;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.ExperimentImmutable;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.SampleImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v1.IDataSetImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v1.IExperimentImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v1.IExternalDataManagementSystemImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v1.ISampleImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.IObjectId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.dataset.DataSetCodeId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.FileFormatType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewProperty;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DataSet<T extends DataSetInformation>
extends AbstractDataSetImmutable
implements IDataSet {
    private final DataSetRegistrationDetails<? extends T> registrationDetails;
    private final File dataSetFolder;
    private IExperimentImmutable experiment;
    private ISampleImmutable sampleOrNull;
    private IExternalDataManagementSystemImmutable externalDataManagementSystemOrNull;

    public DataSet(DataSetRegistrationDetails<? extends T> registrationDetails, File dataSetFolder, IEncapsulatedOpenBISService service) {
        super(service);
        this.registrationDetails = registrationDetails;
        this.dataSetFolder = dataSetFolder;
    }

    public DataSetRegistrationDetails<? extends T> getRegistrationDetails() {
        return this.registrationDetails;
    }

    public File getDataSetStagingFolder() {
        return this.dataSetFolder;
    }

    public File tryDataSetContents() {
        Object[] contents = this.dataSetFolder.listFiles();
        if (this.isNoFileDataSet()) {
            if (contents.length > 0) {
                throw new IllegalArgumentException("A data set of no-file-content type cannot contain files. The data set specification is invalid: " + this.registrationDetails.getDataSetInformation());
            }
            return null;
        }
        if (contents.length > 1) {
            throw new IllegalArgumentException("Data set is ambiguous -- there are more than one potential candidates:" + Arrays.toString(contents));
        }
        if (contents.length < 1) {
            throw new IllegalArgumentException("Data set is empty: " + this.registrationDetails.getDataSetInformation());
        }
        return contents[0];
    }

    @Override
    public String getDataSetCode() {
        return ((DataSetInformation)this.registrationDetails.getDataSetInformation()).getDataSetCode();
    }

    @Override
    public IObjectId getEntityId() {
        return new DataSetCodeId(this.getDataSetCode());
    }

    @Override
    public IExperimentImmutable getExperiment() {
        if (this.experiment != null) {
            return this.experiment;
        }
        if (this.sampleOrNull != null) {
            return this.sampleOrNull.getExperiment();
        }
        return null;
    }

    @Override
    public void setExperiment(IExperimentImmutable experiment) {
        this.experiment = experiment;
        ExperimentImmutable exp = (ExperimentImmutable)experiment;
        Experiment experimentToSet = exp != null ? exp.getExperiment() : null;
        this.setExperiment(experimentToSet);
    }

    @Override
    public ISampleImmutable getSample() {
        return this.sampleOrNull;
    }

    @Override
    public void setSample(ISampleImmutable sampleOrNull) {
        this.sampleOrNull = sampleOrNull;
        T dataSetInformation = this.registrationDetails.getDataSetInformation();
        if (sampleOrNull == null) {
            ((DataSetInformation)dataSetInformation).setSample(null);
            ((DataSetInformation)dataSetInformation).setSampleCode(null);
        } else {
            SampleImmutable sample = (SampleImmutable)sampleOrNull;
            Sample sampleDTO = sample.getSample();
            ((DataSetInformation)dataSetInformation).setSample(sampleDTO);
            ((DataSetInformation)dataSetInformation).setSampleCode(sampleDTO.getCode());
            Space space = sampleDTO.getSpace();
            if (space != null) {
                ((DataSetInformation)dataSetInformation).setSpaceCode(space.getCode());
            }
            if (sampleDTO.getExperiment() != null) {
                this.setExperiment(sampleDTO.getExperiment());
            }
        }
    }

    @Override
    public String getFileFormatType() {
        return this.registrationDetails.getFileFormatType().getCode();
    }

    @Override
    public void setFileFormatType(String fileFormatTypeCode) {
        this.registrationDetails.setFileFormatType(new FileFormatType(fileFormatTypeCode));
    }

    @Override
    public boolean isMeasuredData() {
        return this.registrationDetails.isMeasuredData();
    }

    @Override
    public void setMeasuredData(boolean measuredData) {
        this.registrationDetails.setMeasuredData(measuredData);
    }

    @Override
    public int getSpeedHint() {
        return ((DataSetInformation)this.registrationDetails.getDataSetInformation()).getSpeedHint();
    }

    @Override
    public void setSpeedHint(int speedHint) {
        ((DataSetInformation)this.registrationDetails.getDataSetInformation()).setSpeedHint(speedHint);
    }

    @Override
    public String getDataSetType() {
        return this.registrationDetails.getDataSetType().getCode();
    }

    @Override
    public DataSetType getDataSetTypeWithPropertyTypes() {
        String dataSetTypeCode = this.getDataSetType();
        if (dataSetTypeCode == null) {
            throw new UserFailureException("Unkown data set type. Data set type code has to be set before invoking getDataSetTypeWithPropertyTypes().");
        }
        return this.getDataSetTypeWithPropertyTypes(dataSetTypeCode);
    }

    @Override
    public void setDataSetType(String dataSetTypeCode) {
        this.registrationDetails.setDataSetType(dataSetTypeCode);
    }

    protected void setExperiment(Experiment exp) {
        ((DataSetInformation)this.registrationDetails.getDataSetInformation()).setExperiment(exp);
        ExperimentIdentifier experimentId = exp != null && exp.getIdentifier() != null ? ExperimentIdentifierFactory.parse(exp.getIdentifier()) : null;
        ((DataSetInformation)this.registrationDetails.getDataSetInformation()).setExperimentIdentifier(experimentId);
    }

    @Override
    public String getPropertyValue(String propertyCode) {
        return this.registrationDetails.getPropertyValue(propertyCode);
    }

    @Override
    public List<String> getAllPropertyCodes() {
        List<NewProperty> properties = ((DataSetInformation)this.registrationDetails.getDataSetInformation()).getExtractableData().getDataSetProperties();
        ArrayList<String> codes = new ArrayList<String>();
        for (NewProperty property : properties) {
            codes.add(property.getPropertyCode());
        }
        return codes;
    }

    @Override
    public void setPropertyValue(String propertyCode, String propertyValue) {
        this.registrationDetails.setPropertyValue(propertyCode, propertyValue);
    }

    @Override
    public void setParentDatasets(List<String> parentDatasetCodes) {
        T dataSetInformation = this.registrationDetails.getDataSetInformation();
        ((DataSetInformation)dataSetInformation).setParentDataSetCodes(parentDatasetCodes);
    }

    @Override
    public List<String> getParentDatasets() {
        return ((DataSetInformation)this.registrationDetails.getDataSetInformation()).getParentDataSetCodes();
    }

    @Override
    public boolean isContainerDataSet() {
        return ((DataSetInformation)this.registrationDetails.getDataSetInformation()).isContainerDataSet();
    }

    @Override
    public List<String> getContainedDataSetCodes() {
        return Collections.unmodifiableList(((DataSetInformation)this.registrationDetails.getDataSetInformation()).getContainedDataSetCodes());
    }

    @Override
    public void setContainedDataSetCodes(List<String> containedDataSetCodes) {
        ArrayList<String> newContainedDataSetCodes = containedDataSetCodes == null ? new ArrayList<String>() : new ArrayList<String>(containedDataSetCodes);
        ((DataSetInformation)this.registrationDetails.getDataSetInformation()).setContainedDataSetCodes(newContainedDataSetCodes);
    }

    @Override
    public List<IDataSetImmutable> getChildrenDataSets() {
        throw new UnsupportedOperationException("The operation is not supported for data sets not existing prior the transaction start.");
    }

    @Override
    public boolean isContainedDataSet() {
        return false;
    }

    @Override
    public String getContainerDataSet() {
        return null;
    }

    @Override
    public void setExternalDataManagementSystem(IExternalDataManagementSystemImmutable externalDataManagementSystem) {
        this.externalDataManagementSystemOrNull = externalDataManagementSystem;
        String codeToSet = externalDataManagementSystem != null ? externalDataManagementSystem.getCode() : null;
        ((DataSetInformation)this.registrationDetails.getDataSetInformation()).setExternalDataManagementSystem(codeToSet);
    }

    @Override
    public boolean isLinkDataSet() {
        return ((DataSetInformation)this.registrationDetails.getDataSetInformation()).isLinkDataSet();
    }

    @Override
    public IExternalDataManagementSystemImmutable getExternalDataManagementSystem() {
        return this.externalDataManagementSystemOrNull;
    }

    @Override
    public void setExternalCode(String externalCode) {
        ((DataSetInformation)this.registrationDetails.getDataSetInformation()).setExternalCode(externalCode);
    }

    @Override
    public String getExternalCode() {
        return ((DataSetInformation)this.registrationDetails.getDataSetInformation()).getExternalCode();
    }

    @Override
    public boolean isNoFileDataSet() {
        return this.isContainerDataSet() || this.isLinkDataSet();
    }
}

