/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.v2;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.action.IDelegatedActionWithResult;
import ch.systemsx.cisd.common.concurrent.ConcurrencyUtilities;
import ch.systemsx.cisd.common.exceptions.NotImplementedException;
import ch.systemsx.cisd.etlserver.DssRegistrationLogger;
import ch.systemsx.cisd.etlserver.IStorageProcessorTransactional;
import ch.systemsx.cisd.etlserver.ITopLevelDataSetRegistratorDelegate;
import ch.systemsx.cisd.etlserver.TopLevelDataSetRegistratorGlobalState;
import ch.systemsx.cisd.etlserver.registrator.DataSetFile;
import ch.systemsx.cisd.etlserver.registrator.DataSetRegistrationContext;
import ch.systemsx.cisd.etlserver.registrator.DistinctExceptionsCollection;
import ch.systemsx.cisd.etlserver.registrator.MarkerFileUtility;
import ch.systemsx.cisd.etlserver.registrator.api.impl.RollbackStack;
import ch.systemsx.cisd.etlserver.registrator.api.v2.DataSetRegistrationTransactionV2Delegate;
import ch.systemsx.cisd.etlserver.registrator.api.v2.IDataSetRegistrationTransactionV2;
import ch.systemsx.cisd.etlserver.registrator.api.v2.IJavaDataSetRegistrationDropboxV2;
import ch.systemsx.cisd.etlserver.registrator.api.v2.JythonDataSetRegistrationServiceV2;
import ch.systemsx.cisd.etlserver.registrator.api.v2.JythonTopLevelDataSetHandlerV2;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.AbstractTransactionState;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.DataSetRegistrationTransaction;
import ch.systemsx.cisd.etlserver.registrator.monitor.DssRegistrationHealthMonitor;
import ch.systemsx.cisd.etlserver.registrator.recovery.AbstractRecoveryState;
import ch.systemsx.cisd.etlserver.registrator.recovery.DataSetStoragePrecommitRecoveryState;
import ch.systemsx.cisd.etlserver.registrator.recovery.DataSetStorageRecoveryInfo;
import ch.systemsx.cisd.etlserver.registrator.v2.AbstractOmniscientTopLevelDataSetRegistrator;
import ch.systemsx.cisd.etlserver.registrator.v2.DataSetRegistrationService;
import ch.systemsx.cisd.etlserver.registrator.v2.DataSetStorageAlgorithm;
import ch.systemsx.cisd.etlserver.registrator.v2.DataSetStorageAlgorithmRunner;
import ch.systemsx.cisd.etlserver.registrator.v2.DataSetStorageRollbacker;
import ch.systemsx.cisd.etlserver.registrator.v2.IDataSetOnErrorActionDecision;
import ch.systemsx.cisd.etlserver.registrator.v2.IDataSetRegistrationDetailsFactory;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.EntityOperationsState;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.python.core.PyException;

public abstract class AbstractProgrammableTopLevelDataSetHandler<T extends DataSetInformation>
extends AbstractOmniscientTopLevelDataSetRegistrator<T> {
    private final int processMaxRetryCount;
    private final int processRetryPauseInSec;

    protected AbstractProgrammableTopLevelDataSetHandler(TopLevelDataSetRegistratorGlobalState globalState) {
        super(globalState);
        this.processMaxRetryCount = globalState.getThreadParameters().getProcessMaxRetryCount();
        this.processRetryPauseInSec = globalState.getThreadParameters().getProcessRetryPauseInSec();
    }

    @Override
    public abstract boolean shouldNotAddToFaultyPathsOrNull(File var1);

    @Override
    protected abstract void handleDataSet(DataSetFile var1, DataSetRegistrationService<T> var2) throws Throwable;

    protected void executeProcessFunctionWithRetries(IJavaDataSetRegistrationDropboxV2 v2Programm, JythonDataSetRegistrationServiceV2<T> service, DataSetFile incomingDataSetFile) {
        DssRegistrationLogger logger = service.getDssRegistrationLog();
        DistinctExceptionsCollection errors = new DistinctExceptionsCollection();
        service.transaction();
        while (true) {
            this.waitUntilApplicationIsReady(service, incomingDataSetFile);
            try {
                logger.info(operationLog, "Start processing");
                v2Programm.process(this.wrapTransaction(service.getTransaction()));
                return;
            }
            catch (Exception ex) {
                Exception problem = ex;
                logger.info(operationLog, "Exception occured during jython script processing. Will check if can retry.", ex);
                int errorCount = errors.add(problem);
                if (errorCount > this.processMaxRetryCount) {
                    logger.error(operationLog, "The jython script processing has failed too many times. Rolling back.");
                    throw CheckedExceptionTunnel.wrapIfNecessary(problem);
                }
                logger.info(operationLog, "The same error happened for the " + errorCount + " time (max allowed is " + this.processMaxRetryCount + ")");
                DataSetRegistrationContext registrationContext = service.getTransaction().getRegistrationContext();
                boolean retryFunctionResult = false;
                try {
                    retryFunctionResult = v2Programm.shouldRetryProcessing(registrationContext, problem);
                }
                catch (Exception ex2) {
                    logger.error(operationLog, "The retry function has failed. Rolling back.", ex2);
                    throw CheckedExceptionTunnel.wrapIfNecessary(ex2);
                }
                if (!retryFunctionResult) {
                    logger.error(operationLog, "The should_retry_processing function returned false. Will not retry.");
                    throw CheckedExceptionTunnel.wrapIfNecessary(problem);
                }
                service.rollbackAndForgetTransaction();
                service.transaction().getRegistrationContext().getPersistentMap().putAll(registrationContext.getPersistentMap());
                this.waitTheRetryPeriod(this.processRetryPauseInSec);
                continue;
            }
            break;
        }
    }

    protected IDataSetRegistrationTransactionV2 wrapTransaction(DataSetRegistrationTransaction<T> transaction) {
        DataSetRegistrationTransactionV2Delegate v2transaction = new DataSetRegistrationTransactionV2Delegate(transaction);
        return v2transaction;
    }

    protected void waitUntilApplicationIsReady(DataSetRegistrationService<T> service, DataSetFile incomingDataSetFile) {
        DssRegistrationHealthMonitor.DssRegistrationHealthState healthState;
        while ((healthState = DssRegistrationHealthMonitor.getInstance().checkHealthState(incomingDataSetFile.getRealIncomingFile().getParentFile())).isUnavailable()) {
            service.getDssRegistrationLog().info(operationLog, "Cannot process unless filesystems and application server are available. Reason: " + (Object)((Object)healthState));
            this.waitTheRetryPeriod(10);
        }
    }

    protected void waitTheRetryPeriod(int retryPeriod) {
        ConcurrencyUtilities.sleep(retryPeriod * 1000);
    }

    @Override
    public void didRollbackTransaction(DataSetRegistrationService<T> service, DataSetRegistrationTransaction<T> transaction, DataSetStorageAlgorithmRunner<T> algorithmRunner, Throwable ex) {
        try {
            this.getV2DropboxProgram(service).rollbackPreRegistration(transaction.getRegistrationContext(), ex);
        }
        catch (NotImplementedException notImplementedException) {}
        super.didRollbackTransaction(service, transaction, algorithmRunner, ex);
    }

    @Override
    public void didCommitTransaction(DataSetRegistrationService<T> service, DataSetRegistrationTransaction<T> transaction) {
        super.didCommitTransaction(service, transaction);
        try {
            this.getV2DropboxProgram(service).postStorage(transaction.getRegistrationContext());
        }
        catch (NotImplementedException notImplementedException) {}
    }

    @Override
    public void didPreRegistration(DataSetRegistrationService<T> service, DataSetRegistrationContext.IHolder registrationContextHolder) {
        super.didPreRegistration(service, registrationContextHolder);
        try {
            this.getV2DropboxProgram(service).preMetadataRegistration(registrationContextHolder.getRegistrationContext());
        }
        catch (NotImplementedException notImplementedException) {}
    }

    @Override
    public void didPostRegistration(DataSetRegistrationService<T> service, DataSetRegistrationContext.IHolder registrationContextHolder) {
        super.didPostRegistration(service, registrationContextHolder);
        try {
            this.getV2DropboxProgram(service).postMetadataRegistration(registrationContextHolder.getRegistrationContext());
        }
        catch (NotImplementedException notImplementedException) {}
    }

    @Override
    protected void handleRecovery(File incomingFileOriginal) {
        final File recoveryMarkerFile = this.state.getGlobalState().getStorageRecoveryManager().getProcessingMarkerFile(incomingFileOriginal);
        final AbstractRecoveryState recoveryState = this.state.getGlobalState().getStorageRecoveryManager().extractRecoveryCheckpoint(recoveryMarkerFile);
        final DataSetStorageRecoveryInfo recoveryInfo = this.state.getGlobalState().getStorageRecoveryManager().getRecoveryFileFromMarker(recoveryMarkerFile);
        final File recoveryFile = recoveryInfo.getRecoveryStateFile();
        if (!recoveryFile.exists()) {
            operationLog.error("Recovery file does not exist. " + recoveryFile);
            throw new IllegalStateException("Recovery file " + recoveryFile + " doesn't exist");
        }
        if (!this.retryPeriodHasPassed(recoveryInfo)) {
            return;
        }
        operationLog.info("Will recover from broken registration. Found marker file " + recoveryMarkerFile + " and " + recoveryFile);
        final DssRegistrationLogger logger = recoveryState.getRegistrationLogger(this.state);
        logger.log("Starting recovery at checkpoint " + (Object)((Object)recoveryInfo.getRecoveryStage()));
        IRecoveryCleanupDelegate recoveryMarkerFileCleanupAction = new IRecoveryCleanupDelegate(){

            @Override
            public void execute(boolean shouldStopRecovery, boolean shouldIncreaseTryCount) {
                if (!shouldStopRecovery && recoveryInfo.getTryCount() >= AbstractProgrammableTopLevelDataSetHandler.this.state.getGlobalState().getStorageRecoveryManager().getMaximumRertyCount()) {
                    notificationLog.error("The dataset " + recoveryState.getIncomingDataSetFile().getRealIncomingFile() + " has failed to register. Giving up.");
                    this.deleteMarkerFile();
                    File errorRecoveryMarkerFile = new File(recoveryMarkerFile.getParent(), String.valueOf(recoveryMarkerFile.getName()) + ".ERROR");
                    AbstractProgrammableTopLevelDataSetHandler.this.state.getFileOperations().move(recoveryMarkerFile, errorRecoveryMarkerFile);
                    logger.info(operationLog, "Recovery failed. Giving up.");
                    logger.registerFailure();
                } else if (shouldStopRecovery) {
                    this.deleteMarkerFile();
                    recoveryMarkerFile.delete();
                    recoveryFile.delete();
                } else {
                    DataSetStorageRecoveryInfo rInfo = AbstractProgrammableTopLevelDataSetHandler.this.state.getGlobalState().getStorageRecoveryManager().getRecoveryFileFromMarker(recoveryMarkerFile);
                    if (shouldIncreaseTryCount) {
                        rInfo.increaseTryCount();
                    }
                    rInfo.setLastTry(new Date());
                    rInfo.writeToFile(recoveryMarkerFile);
                }
            }

            private void deleteMarkerFile() {
                File incomingMarkerFile = MarkerFileUtility.getMarkerFileFromIncoming(recoveryState.getIncomingDataSetFile().getRealIncomingFile());
                if (incomingMarkerFile.exists()) {
                    incomingMarkerFile.delete();
                }
            }
        };
        AbstractOmniscientTopLevelDataSetRegistrator.PostRegistrationCleanUpAction cleanupAction = new AbstractOmniscientTopLevelDataSetRegistrator.PostRegistrationCleanUpAction(recoveryState.getIncomingDataSetFile(), new AbstractOmniscientTopLevelDataSetRegistrator.DoNothingDelegatedAction());
        this.handleRecoveryState(recoveryInfo.getRecoveryStage(), recoveryState, cleanupAction, recoveryMarkerFileCleanupAction);
    }

    private boolean retryPeriodHasPassed(DataSetStorageRecoveryInfo recoveryInfo) {
        Calendar c = Calendar.getInstance();
        c.setTime(recoveryInfo.getLastTry());
        c.add(13, this.state.getGlobalState().getStorageRecoveryManager().getRetryPeriodInSeconds());
        return c.getTime().before(new Date());
    }

    private void handleRecoveryState(DataSetStorageRecoveryInfo.RecoveryStage recoveryStage, final AbstractRecoveryState<T> recoveryState, IDelegatedActionWithResult<Boolean> cleanAfterwardsAction, IRecoveryCleanupDelegate recoveryMarkerCleanup) {
        DssRegistrationLogger logger = recoveryState.getRegistrationLogger(this.state);
        boolean shouldStopRecovery = false;
        boolean shouldIncreaseTryCount = true;
        DataSetStorageAlgorithmRunner.IRollbackDelegate rollbackDelegate = new DataSetStorageAlgorithmRunner.IRollbackDelegate<T>(){

            @Override
            public void didRollbackStorageAlgorithmRunner(DataSetStorageAlgorithmRunner<T> algorithm, Throwable ex, IDataSetOnErrorActionDecision.ErrorType errorType) {
            }

            @Override
            public void markReadyForRecovery(DataSetStorageAlgorithmRunner<T> algorithm, Throwable ex) {
            }
        };
        RecoveryHookAdaptor hookAdaptor = this.getRecoveryHookAdaptor(recoveryState.getIncomingDataSetFile().getLogicalIncomingFile());
        DataSetRegistrationContext.IHolder registrationContextHolder = new DataSetRegistrationContext.IHolder(){

            @Override
            public DataSetRegistrationContext getRegistrationContext() {
                return new DataSetRegistrationContext(recoveryState.getPersistentMap(), AbstractProgrammableTopLevelDataSetHandler.this.state.getGlobalState());
            }
        };
        ArrayList<DataSetStorageAlgorithm<T>> dataSetStorageAlgorithms = recoveryState.getDataSetStorageAlgorithms(this.state);
        RollbackStack rollbackStack = recoveryState.getRollbackStack();
        DataSetStorageAlgorithmRunner<T> runner = new DataSetStorageAlgorithmRunner<T>(recoveryState.getIncomingDataSetFile(), dataSetStorageAlgorithms, rollbackDelegate, rollbackStack, logger, this.state.getGlobalState().getOpenBisService(), hookAdaptor, this.state.getGlobalState().getStorageRecoveryManager(), registrationContextHolder, this.state.getGlobalState());
        boolean registrationSuccessful = false;
        operationLog.info("Recovery succesfully deserialized the state of the registration");
        try {
            EntityOperationsState entityOperationsState;
            if (recoveryStage.beforeOrEqual(DataSetStorageRecoveryInfo.RecoveryStage.PRECOMMIT)) {
                TechId registrationId = ((DataSetStoragePrecommitRecoveryState)recoveryState).getRegistrationId();
                if (registrationId == null) {
                    throw new IllegalStateException("Recovery state cannot have null registrationId at the precommit phase");
                }
                entityOperationsState = this.state.getGlobalState().getOpenBisService().didEntityOperationsSucceed(registrationId);
            } else {
                entityOperationsState = EntityOperationsState.OPERATION_SUCCEEDED;
            }
            if (EntityOperationsState.IN_PROGRESS == entityOperationsState) {
                shouldIncreaseTryCount = false;
            } else if (EntityOperationsState.NO_OPERATION == entityOperationsState) {
                operationLog.info("Recovery hasn't found registration artifacts in the application server. Registration of metadata was not successful.");
                AbstractTransactionState.LiveTransactionRollbackDelegate rollbackStackDelegate = new AbstractTransactionState.LiveTransactionRollbackDelegate(this.state.getGlobalState().getStagingDir());
                rollbackStack.setLockedState(false);
                rollbackStack.rollbackAll(rollbackStackDelegate);
                IStorageProcessorTransactional.UnstoreDataAction action = this.state.getOnErrorActionDecision().computeUndoAction(IDataSetOnErrorActionDecision.ErrorType.OPENBIS_REGISTRATION_FAILURE, null);
                DataSetStorageRollbacker rollbacker = new DataSetStorageRollbacker(this.state, operationLog, action, recoveryState.getIncomingDataSetFile(), null, null, IDataSetOnErrorActionDecision.ErrorType.OPENBIS_REGISTRATION_FAILURE);
                operationLog.info(rollbacker.getErrorMessageForLog());
                rollbacker.doRollback(logger);
                logger.log("Operations haven't been registered in AS - recovery rollback");
                logger.registerFailure();
                shouldStopRecovery = true;
                hookAdaptor.executePreRegistrationRollback(registrationContextHolder, null);
                this.finishRegistration(dataSetStorageAlgorithms, rollbackStack);
            } else {
                operationLog.info("Recovery has found datasets in the AS. The registration of metadata was successful.");
                if (recoveryStage.before(DataSetStorageRecoveryInfo.RecoveryStage.POST_REGISTRATION_HOOK_EXECUTED)) {
                    runner.postRegistration();
                }
                boolean success = true;
                if (recoveryStage.before(DataSetStorageRecoveryInfo.RecoveryStage.STORAGE_COMPLETED)) {
                    success = runner.commitAndStore();
                }
                if (success) {
                    success = runner.cleanPrecommitAndConfirmStorage();
                }
                if (success) {
                    hookAdaptor.executePostStorage(registrationContextHolder);
                    registrationSuccessful = true;
                    shouldStopRecovery = true;
                    logger.registerSuccess();
                    this.finishRegistration(dataSetStorageAlgorithms, rollbackStack);
                }
            }
        }
        catch (Throwable error) {
            if ("org.jmock.api.ExpectationError".equals(error.getClass().getCanonicalName())) {
                throw (Error)error;
            }
            logger.error(operationLog, "Uncaught error during recovery", error);
        }
        cleanAfterwardsAction.execute(registrationSuccessful);
        recoveryMarkerCleanup.execute(shouldStopRecovery, shouldIncreaseTryCount);
    }

    private void finishRegistration(ArrayList<DataSetStorageAlgorithm<T>> dataSetStorageAlgorithms, RollbackStack rollbackStack) {
        for (DataSetStorageAlgorithm<T> algorithm : dataSetStorageAlgorithms) {
            algorithm.getStagingFile().delete();
        }
        rollbackStack.discard();
    }

    public IDataSetRegistrationDetailsFactory<T> createObjectFactory(DataSetInformation userProvidedDataSetInformationOrNull) {
        return new JythonTopLevelDataSetHandlerV2.ProgrammableDropboxObjectFactory<DataSetInformation>(this.getRegistratorState(), userProvidedDataSetInformationOrNull){

            @Override
            protected DataSetInformation createDataSetInformation() {
                return new DataSetInformation();
            }
        };
    }

    @Override
    protected DataSetRegistrationService<T> createDataSetRegistrationService(DataSetFile incomingDataSetFile, DataSetInformation callerDataSetInformationOrNull, IDelegatedActionWithResult<Boolean> cleanAfterwardsAction, ITopLevelDataSetRegistratorDelegate delegate) {
        return this.createJythonDataSetRegistrationService(incomingDataSetFile, callerDataSetInformationOrNull, cleanAfterwardsAction, delegate);
    }

    protected DataSetRegistrationService<T> createJythonDataSetRegistrationService(DataSetFile incomingDataSetFile, DataSetInformation userProvidedDataSetInformationOrNull, IDelegatedActionWithResult<Boolean> cleanAfterwardsAction, ITopLevelDataSetRegistratorDelegate delegate) {
        return new DataSetRegistrationService<T>(this, incomingDataSetFile, this.createObjectFactory(userProvidedDataSetInformationOrNull), cleanAfterwardsAction, delegate);
    }

    protected abstract RecoveryHookAdaptor getRecoveryHookAdaptor(File var1);

    protected abstract IJavaDataSetRegistrationDropboxV2 getV2DropboxProgram(DataSetRegistrationService<T> var1);

    @Override
    protected Throwable asSerializableException(Throwable throwable) {
        if (throwable instanceof PyException) {
            return new RuntimeException(throwable.toString());
        }
        return super.asSerializableException(throwable);
    }

    static interface IRecoveryCleanupDelegate {
        public void execute(boolean var1, boolean var2);
    }

    protected abstract class RecoveryHookAdaptor
    implements DataSetStorageAlgorithmRunner.IPrePostRegistrationHook<T> {
        protected final File incoming;

        protected abstract IJavaDataSetRegistrationDropboxV2 getV2DropboxProgramInternal();

        public RecoveryHookAdaptor(File incoming) {
            this.incoming = incoming;
        }

        @Override
        public void executePreRegistration(DataSetRegistrationContext.IHolder registrationContextHolder) {
            throw new NotImplementedException("Recovery cannot execute pre-registration hook.");
        }

        @Override
        public void executePostRegistration(DataSetRegistrationContext.IHolder registrationContextHolder) {
            try {
                this.getV2DropboxProgramInternal().postMetadataRegistration(registrationContextHolder.getRegistrationContext());
            }
            catch (NotImplementedException notImplementedException) {}
        }

        public void executePostStorage(DataSetRegistrationContext.IHolder registrationContextHolder) {
            try {
                this.getV2DropboxProgramInternal().postStorage(registrationContextHolder.getRegistrationContext());
            }
            catch (NotImplementedException notImplementedException) {}
        }

        public void executePreRegistrationRollback(DataSetRegistrationContext.IHolder registrationContextHolder, Throwable throwable) {
            try {
                this.getV2DropboxProgramInternal().rollbackPreRegistration(registrationContextHolder.getRegistrationContext(), throwable);
            }
            catch (NotImplementedException notImplementedException) {}
        }
    }
}

