/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.mail.EMailAddress;
import ch.systemsx.cisd.common.mail.From;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.mail.MailClient;
import ch.systemsx.cisd.common.mail.MailClientParameters;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.dss.generic.server.AbstractDataSetDescriptionBasedCommand;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.IProcessingPluginTask;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ProcessingStatus;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatastoreServiceDescription;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import org.apache.log4j.Logger;

public class ProcessDatasetsCommand
extends AbstractDataSetDescriptionBasedCommand {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, ProcessDatasetsCommand.class);
    private static final long serialVersionUID = 1L;
    private final IProcessingPluginTask task;
    private final Map<String, String> parameterBindings;
    private final String userEmailOrNull;
    private final String sessionTokenOrNull;
    private final DatastoreServiceDescription serviceDescription;
    private MailClientParameters mailClientParameters;
    private transient IMailClient mailClient;
    private String userId;

    public ProcessDatasetsCommand(IProcessingPluginTask task, List<DatasetDescription> datasets, Map<String, String> parameterBindings, String userId, String userEmailOrNull, String sessionTokenOrNull, DatastoreServiceDescription serviceDescription, MailClientParameters mailClientParameters) {
        this(task, datasets, parameterBindings, userId, userEmailOrNull, sessionTokenOrNull, serviceDescription, new MailClient(mailClientParameters));
        this.mailClientParameters = mailClientParameters;
    }

    ProcessDatasetsCommand(IProcessingPluginTask task, List<DatasetDescription> datasets, Map<String, String> parameterBindings, String userId, String userEmailOrNull, String sessionTokenOrNull, DatastoreServiceDescription serviceDescription, IMailClient mailClient) {
        super(datasets);
        this.task = task;
        this.parameterBindings = parameterBindings;
        this.userId = userId;
        this.userEmailOrNull = userEmailOrNull;
        this.sessionTokenOrNull = sessionTokenOrNull;
        this.serviceDescription = serviceDescription;
        this.mailClient = mailClient;
    }

    @Override
    public void execute(IHierarchicalContentProvider contentProvider, IDataSetDirectoryProvider dataSetDirectoryProvider) {
        String errorMessageOrNull = null;
        ProcessingStatus processingStatusOrNull = null;
        ProxyMailClient proxyMailClient = new ProxyMailClient(this.getMailClient());
        try {
            try {
                DataSetProcessingContext context = this.createDataSetProcessingContext(contentProvider, dataSetDirectoryProvider, proxyMailClient);
                processingStatusOrNull = this.task.process(this.dataSets, context);
            }
            catch (RuntimeException e) {
                errorMessageOrNull = e.getMessage() == null ? "" : e.getMessage();
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (StringUtils.isBlank(this.userEmailOrNull)) {
                if (errorMessageOrNull != null) {
                    String warning = String.format("Dataset processing '%s' has failed with a message '%s' but the person who triggered processing has no email address specified. No notification has been sent.", this.serviceDescription.getKey(), errorMessageOrNull);
                    operationLog.warn(warning);
                }
                return;
            }
            if (!proxyMailClient.hasMailSent() || errorMessageOrNull != null) {
                this.createContentAndSendMessage(errorMessageOrNull, processingStatusOrNull);
            }
            throw throwable;
        }
        if (StringUtils.isBlank(this.userEmailOrNull)) {
            if (errorMessageOrNull != null) {
                String warning = String.format("Dataset processing '%s' has failed with a message '%s' but the person who triggered processing has no email address specified. No notification has been sent.", this.serviceDescription.getKey(), errorMessageOrNull);
                operationLog.warn(warning);
            }
            return;
        }
        if (!proxyMailClient.hasMailSent() || errorMessageOrNull != null) {
            this.createContentAndSendMessage(errorMessageOrNull, processingStatusOrNull);
        }
    }

    DataSetProcessingContext createDataSetProcessingContext(IHierarchicalContentProvider contentProvider, IDataSetDirectoryProvider dataSetDirectoryProvider, ProxyMailClient proxyMailClient) {
        return new DataSetProcessingContext(contentProvider, dataSetDirectoryProvider, this.parameterBindings, proxyMailClient, this.userId, this.userEmailOrNull, this.sessionTokenOrNull);
    }

    private void createContentAndSendMessage(String errorMessageOrNull, ProcessingStatus processingStatusOrNull) {
        String subject;
        StringBuilder contentBuilder = new StringBuilder();
        if (errorMessageOrNull != null) {
            subject = this.getShortDescription(" processing failed");
            contentBuilder.append(this.getDescription(subject));
            contentBuilder.append("\n\nError message:\n");
            contentBuilder.append(errorMessageOrNull);
        } else {
            subject = this.getShortDescription(" processing finished");
            if (processingStatusOrNull != null) {
                contentBuilder.append(ProcessDatasetsCommand.generateDescription(processingStatusOrNull));
            } else {
                contentBuilder.append(this.getDescription(subject));
            }
        }
        this.sendMessage(subject, contentBuilder.toString(), this.userEmailOrNull);
    }

    private void sendMessage(String subject, String content, String recipient) {
        this.getMailClient().sendMessage(subject, content, null, null, recipient);
    }

    private String getShortDescription(String suffix) {
        return String.format("'%s'%s", this.serviceDescription.getLabel(), suffix);
    }

    private String getDescription(String prefix) {
        return String.format("%s on %d data set(s): \n%s", prefix, this.dataSets.size(), ProcessDatasetsCommand.getDataSetCodes(this.getDataSetCodes()));
    }

    @Override
    public String getDescription() {
        return this.getDescription(this.getShortDescription(""));
    }

    private static String getDataSetCodes(List<String> datasets) {
        if (datasets.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String dataset : datasets) {
            sb.append(dataset);
            sb.append(',');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private static String generateDescription(ProcessingStatus processingStatus) {
        StringBuilder sb = new StringBuilder();
        sb.append("This is an automatically generated report from the completed processing of data sets in openBIS.\n");
        List<String> successfullyProcessed = processingStatus.getDatasetsByStatus(Status.OK);
        if (successfullyProcessed != null && !successfullyProcessed.isEmpty()) {
            sb.append("- number of successfully processed data sets: ");
            sb.append(successfullyProcessed.size());
            sb.append(". Datasets: ");
            sb.append(ProcessDatasetsCommand.getDataSetCodes(successfullyProcessed));
            sb.append("\n");
        }
        List<Status> errorStatuses = processingStatus.getErrorStatuses();
        for (Status errorStatus : errorStatuses) {
            List<String> unsuccessfullyProcessed = processingStatus.getDatasetsByStatus(errorStatus);
            sb.append("- processing of ");
            sb.append(unsuccessfullyProcessed.size());
            sb.append(" data set(s) failed because: ");
            sb.append(" " + errorStatus + ". Datasets: ");
            sb.append(ProcessDatasetsCommand.getDataSetCodes(unsuccessfullyProcessed));
            sb.append("\n");
        }
        return sb.toString();
    }

    private IMailClient getMailClient() {
        if (this.mailClient == null) {
            this.mailClient = new MailClient(this.mailClientParameters);
        }
        return this.mailClient;
    }

    String getUserId() {
        return this.userId;
    }

    String tryGetUserEmail() {
        return this.userEmailOrNull;
    }

    @Private
    static final class ProxyMailClient
    implements IMailClient {
        private final IMailClient mailClient;
        private boolean mailSent;

        ProxyMailClient(IMailClient mailClient) {
            this.mailClient = mailClient;
        }

        boolean hasMailSent() {
            return this.mailSent;
        }

        @Override
        public void sendMessage(String subject, String content, String replyToOrNull, From fromOrNull, String ... recipients) throws EnvironmentFailureException {
            this.mailClient.sendMessage(subject, content, replyToOrNull, fromOrNull, recipients);
            this.mailSent = true;
        }

        @Override
        public void sendEmailMessage(String subject, String content, EMailAddress replyToOrNull, EMailAddress fromOrNull, EMailAddress ... recipients) throws EnvironmentFailureException {
            this.mailClient.sendEmailMessage(subject, content, replyToOrNull, fromOrNull, recipients);
            this.mailSent = true;
        }

        @Override
        public void sendMessageWithAttachment(String subject, String content, String filename, DataHandler attachmentContent, String replyToOrNull, From fromOrNull, String ... recipients) throws EnvironmentFailureException {
            this.mailClient.sendMessageWithAttachment(subject, content, filename, attachmentContent, replyToOrNull, fromOrNull, recipients);
            this.mailSent = true;
        }

        @Override
        public void sendEmailMessageWithAttachment(String subject, String content, String filename, DataHandler attachmentContent, EMailAddress replyToOrNull, EMailAddress fromOrNull, EMailAddress ... recipients) throws EnvironmentFailureException {
            this.mailClient.sendEmailMessageWithAttachment(subject, content, filename, attachmentContent, replyToOrNull, fromOrNull, recipients);
            this.mailSent = true;
        }

        @Override
        public void sendTestEmail() {
            this.mailClient.sendTestEmail();
        }
    }
}

