/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.amc;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.SampleTypeDisplayID;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.DataSetTypeModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.DataTypeModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.ExperimentTypeModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.MaterialTypeModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.SampleTypeModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.SimplifiedBaseModelData;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.DataSetTypeSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.experiment.ExperimentTypeSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.CheckBoxField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.CodeField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.DescriptionField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.MultilineVarcharField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.PropertyFieldFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.ScriptChooserField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.VarcharField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.XmlField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.material.MaterialTypeSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property_type.DataTypeSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property_type.EntityTypePropertyTypeSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property_type.PropertyTypeAssignmentGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property_type.PropertyTypeSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property_type.SectionSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.sample.SampleTypeSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.vocabulary.VocabularySelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractRegistrationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.DropDownList;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewETPTAssignment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ScriptType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Label;
import com.extjs.gxt.ui.client.widget.form.CheckBox;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.Radio;
import com.extjs.gxt.ui.client.widget.form.RadioGroup;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;

public class AddPropertyTypeDialog
extends AbstractRegistrationDialog {
    private static final int FORM_WIDTH = 600;
    private static final int LABEL_WIDTH = 150;
    private static final int FIELD_WIDTH = 400;
    private Label loading;
    private RadioGroup selectAssignGroup;
    private boolean isSelect = true;
    public static final String ID = "openbis_property-type-registration_form";
    private final IViewContext<ICommonClientServiceAsync> viewContext;
    private CodeField propertyTypeCodeField;
    private VarcharField propertyTypeLabelField;
    private MultilineVarcharField propertyTypeDescriptionField;
    private DataTypeSelectionWidget dataTypeSelectionWidget;
    private VocabularySelectionWidget vocabularySelectionWidget;
    private MaterialTypeSelectionWidget materialTypeSelectionWidget;
    private XmlField xmlSchemaField;
    private XmlField xslTransformationsField;
    private EntityType entity;
    private EntityKind entityKind;
    private boolean isExitingEntity;
    private static final String PREFIX = "property-type-assignment_";
    public static final String ID_PREFIX = "openbis_property-type-assignment_";
    public static final String PROPERTY_TYPE_ID_SUFFIX = "property_type";
    public static final String SAMPLE_TYPE_ID_SUFFIX = "openbis_property-type-assignment_sample_type";
    public static final String EXPERIMENT_TYPE_ID_SUFFIX = "openbis_property-type-assignment_experiment_type";
    public static final String MATERIAL_TYPE_ID_SUFFIX = "openbis_property-type-assignment_material_type";
    public static final String DATA_SET_TYPE_ID_SUFFIX = "openbis_property-type-assignment_data_set_type";
    public static final String MANDATORY_CHECKBOX_ID_SUFFIX = "mandatory_checkbox";
    private static final String UNSUPPORTED_ENTITY_KIND = "Unsupported entity kind";
    protected static final String DEFAULT_VALUE_ID_PART = "default_value";
    private DropDownList<? extends SimplifiedBaseModelData, ? extends EntityType> entityTypeSelectionWidget;
    private PropertyTypeSelectionWidget propertyTypeSelectionWidget;
    private DatabaseModificationAwareField<?> defaultValueField;
    private CheckBox mandatoryCheckbox;
    private CheckBox scriptableCheckbox;
    private CheckBox shownInEditViewCheckBox;
    private CheckBox showRawValueCheckBox;
    private SectionSelectionWidget sectionSelectionWidget;
    private EntityTypePropertyTypeSelectionWidget etptSelectionWidget;
    private ScriptChooserField scriptChooser;
    private Radio scriptTypeManaged;
    private Radio scriptTypeDynamic;
    private RadioGroup scriptTypeRadioGroup;
    private boolean userDidChangeShownInEditViewCheckBox = false;
    private boolean userDidChangeShowRawValueCheckBox = false;
    private boolean synchronizingGuiFields = false;
    PropertyTypeAssignmentGrid.InMemoryGridAddCallback inMemoryGridCallback;

    public boolean isSelect() {
        return this.isSelect;
    }

    public void setSelect(boolean isSelect) {
        this.isSelect = isSelect;
    }

    public AddPropertyTypeDialog(IViewContext<ICommonClientServiceAsync> viewContext, IDelegatedAction postRegistrationCallback, EntityKind entityKind, String entityCode, PropertyTypeAssignmentGrid.InMemoryGridAddCallback inMemoryGridCallback, EntityType inMemoryEntityType, boolean isExitingEntity) {
        super(viewContext, viewContext.getMessage("property_type_registration", new Object[0]), postRegistrationCallback);
        this.viewContext = viewContext;
        this.inMemoryGridCallback = inMemoryGridCallback;
        this.entityKind = entityKind;
        this.isExitingEntity = isExitingEntity;
        this.setWidth(600);
        this.getFormPanel().setFieldWidth(400);
        this.getFormPanel().setLabelWidth(150);
        this.loading = new Label(viewContext.getMessage("load_in_progress", new Object[0]));
        this.addField((Widget)this.loading);
        this.entity = inMemoryEntityType;
        this.loadEntityDialog(entityKind, entityCode);
    }

    private void loadEntityDialog(EntityKind kind, String code) {
        switch (kind) {
            case MATERIAL: {
                this.viewContext.getService().listMaterialTypes(new AsyncCallbackEntityTypeForDialog<List<MaterialType>>(code));
                break;
            }
            case EXPERIMENT: {
                this.viewContext.getService().listExperimentTypes(new AsyncCallbackEntityTypeForDialog<List<ExperimentType>>(code));
                break;
            }
            case SAMPLE: {
                this.viewContext.getService().listSampleTypes(new AsyncCallbackEntityTypeForDialog<List<SampleType>>(code));
                break;
            }
            case DATA_SET: {
                this.viewContext.getService().listDataSetTypes(new AsyncCallbackEntityTypeForDialog<List<DataSetType>>(code));
            }
        }
    }

    private void entityLoaded(EntityType entity) {
        if (this.inMemoryGridCallback == null) {
            this.entity = entity;
        }
        this.removeField((Widget)this.loading);
        this.getFormPanel().setLayoutOnChange(true);
        this.setLayoutOnChange(true);
        this.addField((Widget)this.getSelector());
        this.initSelectPropertyForm();
        this.fixLayout();
    }

    private final void fixLayout() {
        this.getFormPanel().layout();
        this.layout();
        this.setSize(600, 650);
        this.center();
    }

    public RadioGroup getSelector() {
        if (this.selectAssignGroup == null) {
            Radio selectProperty = new Radio();
            selectProperty.setBoxLabel(this.viewContext.getMessage("assign_group_existing", new Object[0]));
            selectProperty.setValue(Boolean.valueOf(true));
            Radio newPropertie = new Radio();
            newPropertie.setBoxLabel(this.viewContext.getMessage("assign_group_new", new Object[0]));
            newPropertie.setValue(Boolean.valueOf(false));
            this.selectAssignGroup = new RadioGroup();
            this.selectAssignGroup.setFieldLabel(this.viewContext.getMessage("assign_group_property", new Object[0]));
            this.selectAssignGroup.add(selectProperty);
            this.selectAssignGroup.add(newPropertie);
            this.selectAssignGroup.addListener(Events.Change, (Listener)new Listener<BaseEvent>(){

                public void handleEvent(BaseEvent be) {
                    AddPropertyTypeDialog.this.setSelect(!AddPropertyTypeDialog.this.isSelect());
                    AddPropertyTypeDialog.this.hidePropertyTypeRelatedFields();
                    AddPropertyTypeDialog.this.hideEntityTypePropertyTypeRelatedFields();
                    AddPropertyTypeDialog.this.getFormPanel().removeAll();
                    if (AddPropertyTypeDialog.this.isSelect()) {
                        AddPropertyTypeDialog.this.initSelectPropertyForm();
                    } else {
                        AddPropertyTypeDialog.this.initNewPropertyForm();
                    }
                    AddPropertyTypeDialog.this.fixLayout();
                }
            });
        }
        return this.selectAssignGroup;
    }

    private final void initSelectPropertyForm() {
        this.addField((Widget)this.getSelector());
        this.addField((Widget)this.getPropertyTypeSelectionWidget());
        this.getPropertyTypeSelectionWidget().clear();
        this.getPropertyTypeSelectionWidget().enable();
        this.getPropertyTypeSelectionWidget().setVisible(true);
        if (this.inMemoryGridCallback == null) {
            this.addField((Widget)this.getEntityTypeSelectionWidget());
            this.getEntityTypeSelectionWidget().disable();
            this.getEntityTypeSelectionWidget().setVisible(false);
        }
        this.addField((Widget)this.getScriptableCheckbox());
        this.getScriptableCheckbox().clear();
        this.getScriptTypeRadioGroup().setVisible(false);
        this.addField((Widget)this.getScriptTypeRadioGroup());
        this.addField((Widget)this.getScriptChooserField());
        this.getScriptChooserField().clear();
        this.getScriptChooserField().setVisible(false);
        this.addField((Widget)this.getMandatoryCheckbox());
        this.getMandatoryCheckbox().clear();
        this.addField((Widget)this.getShownInEditViewCheckbox());
        this.getShownInEditViewCheckbox().clear();
        this.getShownInEditViewCheckbox().setVisible(false);
        this.addField((Widget)this.getShowRawValueCheckBox());
        this.getShowRawValueCheckBox().clear();
        this.getShowRawValueCheckBox().setVisible(false);
    }

    private final void initNewPropertyForm() {
        this.addField((Widget)this.getSelector());
        this.addField((Widget)this.getPropertyTypeCodeField());
        this.getPropertyTypeCodeField().clear();
        this.addField((Widget)this.getPropertyTypeLabelField());
        this.getPropertyTypeLabelField().clear();
        this.addField((Widget)this.getPropertyTypeDescriptionField());
        this.getPropertyTypeDescriptionField().clear();
        this.addField((Widget)this.getDataTypeSelectionWidget());
        this.getDataTypeSelectionWidget().clear();
        this.addField((Widget)this.getVocabularySelectionWidget());
        this.getVocabularySelectionWidget().clear();
        this.getVocabularySelectionWidget().setVisible(false);
        this.addField((Widget)this.getMaterialTypeSelectionWidget());
        this.getMaterialTypeSelectionWidget().clear();
        this.getMaterialTypeSelectionWidget().setVisible(false);
        this.addField((Widget)this.getXmlSchemaField());
        this.getXmlSchemaField().clear();
        this.getXmlSchemaField().setVisible(false);
        this.addField((Widget)this.getXslTransformationsField());
        this.getXslTransformationsField().clear();
        this.getXslTransformationsField().setVisible(false);
        this.getPropertyTypeSelectionWidget().clear();
        this.addField((Widget)this.getPropertyTypeSelectionWidget());
        this.getPropertyTypeSelectionWidget().disable();
        this.getPropertyTypeSelectionWidget().setVisible(false);
        if (this.inMemoryGridCallback == null) {
            this.addField((Widget)this.getEntityTypeSelectionWidget());
            this.getEntityTypeSelectionWidget().disable();
            this.getEntityTypeSelectionWidget().setVisible(false);
        }
        this.addField((Widget)this.getScriptableCheckbox());
        this.getScriptableCheckbox().clear();
        this.getScriptTypeRadioGroup().setVisible(false);
        this.addField((Widget)this.getScriptTypeRadioGroup());
        this.addField((Widget)this.getScriptChooserField());
        this.getScriptChooserField().clear();
        this.getScriptChooserField().setVisible(false);
        this.addField((Widget)this.getMandatoryCheckbox());
        this.getMandatoryCheckbox().clear();
        this.addField((Widget)this.getShownInEditViewCheckbox());
        this.getShownInEditViewCheckbox().clear();
        this.getShownInEditViewCheckbox().setVisible(false);
        this.addField((Widget)this.getShowRawValueCheckBox());
        this.getShowRawValueCheckBox().clear();
        this.getShowRawValueCheckBox().setVisible(false);
    }

    @Override
    protected void register(AsyncCallback<Void> registrationCallback) {
        if (this.inMemoryGridCallback == null) {
            if (!this.isSelect()) {
                PropertyType propertyType = this.createPropertyType();
                NewETPTAssignment assignment = this.createAssignment();
                this.viewContext.getService().registerAndAssignPropertyType(propertyType, assignment, new AssignPropertyTypeCallback(this.viewContext, registrationCallback));
            } else {
                NewETPTAssignment assignment = this.createAssignment();
                this.viewContext.getService().assignPropertyType(assignment, new AssignPropertyTypeCallback(this.viewContext, registrationCallback));
            }
        } else {
            boolean isExixtingPropertyType = this.isSelect();
            PropertyType propertyType = null;
            NewETPTAssignment assignment = this.createAssignment();
            propertyType = !this.isSelect() ? this.createPropertyType() : this.propertyTypeSelectionWidget.tryGetSelectedPropertyType();
            this.inMemoryGridCallback.callback(isExixtingPropertyType, propertyType, assignment, this);
        }
    }

    private final PropertyType createPropertyType() {
        PropertyType propertyType = new PropertyType();
        if (this.getPropertyTypeCodeField().getValue() != null) {
            propertyType.setCode(((String)this.getPropertyTypeCodeField().getValue()).toUpperCase());
        }
        propertyType.setLabel((String)this.getPropertyTypeLabelField().getValue());
        propertyType.setDescription((String)this.getPropertyTypeDescriptionField().getValue());
        propertyType.setDataType(this.getDataTypeSelectionWidget().tryGetSelectedDataType());
        if (propertyType.getDataType() != null) {
            switch (propertyType.getDataType().getCode()) {
                case MATERIAL: {
                    propertyType.setMaterialType((MaterialType)this.getMaterialTypeSelectionWidget().tryGetSelected());
                    break;
                }
                case CONTROLLEDVOCABULARY: {
                    propertyType.setVocabulary((Vocabulary)GWTUtils.tryGetSingleSelected(this.getVocabularySelectionWidget()));
                    break;
                }
                case XML: {
                    propertyType.setSchema((String)this.getXmlSchemaField().getValue());
                    propertyType.setTransformation((String)this.getXslTransformationsField().getValue());
                    break;
                }
            }
        }
        return propertyType;
    }

    private final NewETPTAssignment createAssignment() {
        String entityTypeCode = null;
        if (this.inMemoryGridCallback == null) {
            entityTypeCode = ((EntityType)this.getEntityTypeSelectionWidget().tryGetSelected()).getCode();
        }
        String propertyTypeCode = null;
        propertyTypeCode = this.isSelect() ? this.propertyTypeSelectionWidget.tryGetSelectedPropertyTypeCode() : ((String)this.getPropertyTypeCodeField().getValue()).toUpperCase();
        NewETPTAssignment newAssignment = new NewETPTAssignment(this.entityKind, propertyTypeCode, entityTypeCode, this.getMandatoryCheckbox().getValue(), this.getDefaultValue(), this.getSectionValue(), this.getPreviousETPTOrdinal(), this.isDynamic(), this.isManaged(), this.tryGetScriptNameValue(), this.isShownInEditView(), this.getShowRawValue());
        return newAssignment;
    }

    private final RadioGroup getScriptTypeRadioGroup() {
        if (this.scriptTypeRadioGroup == null) {
            this.scriptTypeRadioGroup = new RadioGroup();
            this.scriptTypeRadioGroup.setSelectionRequired(true);
            this.scriptTypeRadioGroup.setVisible(false);
            this.scriptTypeRadioGroup.setOrientation(Style.Orientation.HORIZONTAL);
            this.scriptTypeManaged = new Radio();
            this.scriptTypeManaged.setBoxLabel(ScriptType.MANAGED_PROPERTY.getDescription());
            this.scriptTypeManaged.setId("openbis_property-type-assignment_managed_radio");
            this.scriptTypeRadioGroup.add(this.scriptTypeManaged);
            this.scriptTypeDynamic = new Radio();
            this.scriptTypeDynamic.setBoxLabel(ScriptType.DYNAMIC_PROPERTY.getDescription());
            this.scriptTypeDynamic.setId("openbis_property-type-assignment_dynamic_radio");
            this.scriptTypeRadioGroup.add(this.scriptTypeDynamic);
            this.scriptTypeRadioGroup.setLabelSeparator("");
            this.scriptTypeRadioGroup.addListener(Events.Change, (Listener)new Listener<BaseEvent>(){

                public void handleEvent(BaseEvent be) {
                    AddPropertyTypeDialog.this.scriptChooser.setRawValue("");
                    AddPropertyTypeDialog.this.updateVisibilityOfShownInEditViewField();
                    AddPropertyTypeDialog.this.updateVisibilityOfShowRawValueField();
                }
            });
        }
        FieldUtil.setValueWithoutEvents(this.scriptTypeRadioGroup, this.scriptTypeManaged);
        return this.scriptTypeRadioGroup;
    }

    private ScriptChooserField getScriptChooserField() {
        if (this.scriptChooser == null) {
            ScriptChooserField.IScriptTypeProvider scriptTypeProvider = new ScriptChooserField.IScriptTypeProvider(){

                @Override
                public ScriptType tryGetScriptType() {
                    return AddPropertyTypeDialog.this.isManaged() ? ScriptType.MANAGED_PROPERTY : ScriptType.DYNAMIC_PROPERTY;
                }
            };
            this.scriptChooser = ScriptChooserField.create(this.viewContext.getMessage("plugin", new Object[0]), true, null, this.viewContext, scriptTypeProvider, this.entityKind);
            this.scriptChooser.setId("openbis_property-type-assignment_script_chooser");
            FieldUtil.setVisibility(false, new Field[]{this.scriptChooser});
        }
        return this.scriptChooser;
    }

    public PropertyTypeSelectionWidget getPropertyTypeSelectionWidget() {
        if (this.propertyTypeSelectionWidget == null) {
            this.propertyTypeSelectionWidget = new PropertyTypeSelectionWidget(this.viewContext, this.createChildId(PROPERTY_TYPE_ID_SUFFIX));
            FieldUtil.markAsMandatory(this.propertyTypeSelectionWidget);
            this.propertyTypeSelectionWidget.addListener(Events.SelectionChange, (Listener)new Listener<BaseEvent>(){

                public void handleEvent(BaseEvent be) {
                    AddPropertyTypeDialog.this.updatePropertyTypeRelatedFields();
                }
            });
        }
        return this.propertyTypeSelectionWidget;
    }

    private DropDownList<?, ?> getEntityTypeSelectionWidget() {
        if (this.entityTypeSelectionWidget == null) {
            switch (this.entityKind) {
                case EXPERIMENT: {
                    ExperimentTypeSelectionWidget ew = new ExperimentTypeSelectionWidget(this.viewContext, EXPERIMENT_TYPE_ID_SUFFIX, null);
                    ew.setValue((ModelData)new ExperimentTypeModel((ExperimentType)this.entity));
                    this.entityTypeSelectionWidget = ew;
                    break;
                }
                case SAMPLE: {
                    SampleTypeSelectionWidget sw = new SampleTypeSelectionWidget(this.viewContext, SAMPLE_TYPE_ID_SUFFIX, false, SampleTypeDisplayID.PROPERTY_ASSIGNMENT, null);
                    sw.setValue((ModelData)new SampleTypeModel((SampleType)this.entity));
                    this.entityTypeSelectionWidget = sw;
                    break;
                }
                case MATERIAL: {
                    MaterialTypeSelectionWidget mw = new MaterialTypeSelectionWidget(this.viewContext, null, MATERIAL_TYPE_ID_SUFFIX, false);
                    mw.setValue((ModelData)new MaterialTypeModel((MaterialType)this.entity));
                    this.entityTypeSelectionWidget = mw;
                    break;
                }
                case DATA_SET: {
                    DataSetTypeSelectionWidget dw = new DataSetTypeSelectionWidget(this.viewContext, DATA_SET_TYPE_ID_SUFFIX);
                    dw.setValue((ModelData)new DataSetTypeModel((DataSetType)this.entity));
                    this.entityTypeSelectionWidget = dw;
                }
            }
            if (this.entityTypeSelectionWidget == null) {
                throw new IllegalArgumentException(UNSUPPORTED_ENTITY_KIND);
            }
            FieldUtil.markAsMandatory(this.entityTypeSelectionWidget);
            this.entityTypeSelectionWidget.addListener(Events.SelectionChange, (Listener)new Listener<BaseEvent>(){

                public void handleEvent(BaseEvent be) {
                    AddPropertyTypeDialog.this.updateEntityTypePropertyTypeRelatedFields();
                }
            });
            this.updateEntityTypePropertyTypeRelatedFields();
        }
        return this.entityTypeSelectionWidget;
    }

    private CheckBox getScriptableCheckbox() {
        if (this.scriptableCheckbox == null) {
            this.scriptableCheckbox = new CheckBoxField(this.viewContext.getMessage("scriptable", new Object[0]), false);
            this.scriptableCheckbox.setValue(Boolean.valueOf(false));
            this.scriptableCheckbox.addListener(Events.Change, (Listener)new Listener<BaseEvent>(){

                public void handleEvent(BaseEvent be) {
                    AddPropertyTypeDialog.this.updateShownInEditView();
                    AddPropertyTypeDialog.this.updateShowRawValue();
                    AddPropertyTypeDialog.this.updateVisibilityOfScriptRelatedFields();
                    AddPropertyTypeDialog.this.fixLayout();
                }
            });
            this.scriptableCheckbox.setId("openbis_property-type-assignment_scriptable_checkbox");
        }
        return this.scriptableCheckbox;
    }

    private CheckBox getMandatoryCheckbox() {
        if (this.mandatoryCheckbox == null) {
            this.mandatoryCheckbox = new CheckBoxField(this.viewContext.getMessage("mandatory", new Object[0]), false);
            this.mandatoryCheckbox.setId(this.createChildId(MANDATORY_CHECKBOX_ID_SUFFIX));
            this.mandatoryCheckbox.setValue(Boolean.valueOf(false));
            this.mandatoryCheckbox.addListener(Events.Change, (Listener)new Listener<BaseEvent>(){

                public void handleEvent(BaseEvent be) {
                    AddPropertyTypeDialog.this.updatePropertyTypeRelatedFields();
                }
            });
            FieldUtil.setVisibility(!this.isScriptable(), new Field[]{this.mandatoryCheckbox});
        }
        return this.mandatoryCheckbox;
    }

    private CheckBox getShownInEditViewCheckbox() {
        if (this.shownInEditViewCheckBox == null) {
            this.shownInEditViewCheckBox = new CheckBoxField(this.viewContext.getMessage("is_shown_in_edit_view", new Object[0]), false);
            this.shownInEditViewCheckBox.setValue(Boolean.valueOf(true));
            this.shownInEditViewCheckBox.setVisible(false);
            this.shownInEditViewCheckBox.addListener(Events.Change, (Listener)new Listener<BaseEvent>(){

                public void handleEvent(BaseEvent be) {
                    if (!AddPropertyTypeDialog.this.synchronizingGuiFields) {
                        AddPropertyTypeDialog.this.userDidChangeShownInEditViewCheckBox = true;
                    }
                    AddPropertyTypeDialog.this.updateVisibilityOfShowRawValueField();
                    AddPropertyTypeDialog.this.fixLayout();
                }
            });
        }
        return this.shownInEditViewCheckBox;
    }

    private CheckBox getShowRawValueCheckBox() {
        if (this.showRawValueCheckBox == null) {
            this.showRawValueCheckBox = new CheckBoxField(this.viewContext.getMessage("show_raw_value_in_forms", new Object[0]), false);
            this.showRawValueCheckBox.setValue(Boolean.valueOf(true));
            this.showRawValueCheckBox.setVisible(false);
            this.showRawValueCheckBox.addListener(Events.Change, (Listener)new Listener<BaseEvent>(){

                public void handleEvent(BaseEvent be) {
                    if (!AddPropertyTypeDialog.this.synchronizingGuiFields) {
                        AddPropertyTypeDialog.this.userDidChangeShowRawValueCheckBox = true;
                    }
                }
            });
        }
        return this.showRawValueCheckBox;
    }

    private void updatePropertyTypeRelatedFields() {
        this.hidePropertyTypeRelatedFields();
        PropertyType propertyType = null;
        propertyType = this.isSelect() ? this.getPropertyTypeSelectionWidget().tryGetSelectedPropertyType() : this.createPropertyType();
        if ((propertyType != null && propertyType.getDataType() != null && propertyType.getDataType().getCode() != DataTypeCode.CONTROLLEDVOCABULARY || propertyType != null && propertyType.getDataType() != null && propertyType.getDataType().getCode() == DataTypeCode.CONTROLLEDVOCABULARY && propertyType.getVocabulary() != null) && this.isExitingEntity && this.getMandatoryCheckbox().getValue().booleanValue()) {
            String fieldId = this.createChildId(DEFAULT_VALUE_ID_PART);
            DatabaseModificationAwareField<?> fieldHolder = PropertyFieldFactory.createField(propertyType, false, this.viewContext.getMessage(DEFAULT_VALUE_ID_PART, new Object[0]), fieldId, null, this.viewContext);
            GWTUtils.setToolTip((Component)fieldHolder.get(), this.viewContext.getMessage("default_value_tooltip", new Object[0]));
            this.defaultValueField = fieldHolder;
            ((Field)this.defaultValueField.get()).show();
            FieldUtil.setVisibility(!this.isScriptable(), (Field)this.defaultValueField.get());
            this.addField((Widget)this.defaultValueField.get());
        }
        this.updateEntityTypePropertyTypeRelatedFields();
    }

    private String createChildId(String childSuffix) {
        return String.valueOf(this.getId()) + childSuffix;
    }

    private void updateEntityTypePropertyTypeRelatedFields() {
        this.hideEntityTypePropertyTypeRelatedFields();
        PropertyType propertyType = null;
        propertyType = this.isSelect() ? this.getPropertyTypeSelectionWidget().tryGetSelectedPropertyType() : this.createPropertyType();
        EntityType entityType = null;
        entityType = this.inMemoryGridCallback == null ? (EntityType)this.getEntityTypeSelectionWidget().tryGetSelected() : this.entity;
        if (propertyType != null && entityType != null && propertyType.getDataType() != null) {
            ArrayList etpts = new ArrayList(entityType.getAssignedPropertyTypes());
            this.addField((Widget)this.getSectionSelectionWidget(etpts));
            this.addField((Widget)this.getETPTSelectionWidget(etpts));
        }
        this.fixLayout();
    }

    private EntityTypePropertyTypeSelectionWidget getETPTSelectionWidget(List<EntityTypePropertyType<?>> etpts) {
        if (this.etptSelectionWidget == null) {
            this.etptSelectionWidget = this.createETPTSelectionWidget(etpts);
        }
        return this.etptSelectionWidget;
    }

    private SectionSelectionWidget getSectionSelectionWidget(List<EntityTypePropertyType<?>> etpts) {
        if (this.sectionSelectionWidget == null) {
            this.sectionSelectionWidget = SectionSelectionWidget.create(this.viewContext, etpts);
        }
        return this.sectionSelectionWidget;
    }

    private void hideEntityTypePropertyTypeRelatedFields() {
        if (this.sectionSelectionWidget != null && this.getFormPanel().getFields().contains((Object)this.sectionSelectionWidget)) {
            this.removeField((Widget)this.sectionSelectionWidget);
        }
        if (this.etptSelectionWidget != null && this.getFormPanel().getFields().contains(this.etptSelectionWidget)) {
            this.removeField((Widget)this.etptSelectionWidget);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateShownInEditView() {
        if (this.userDidChangeShownInEditViewCheckBox) {
            return;
        }
        this.synchronizingGuiFields = true;
        try {
            if (!this.isScriptable()) {
                this.shownInEditViewCheckBox.setValue(Boolean.valueOf(true));
                return;
            }
            if (this.isDynamic()) {
                this.shownInEditViewCheckBox.setValue(Boolean.valueOf(false));
                return;
            }
            if (!this.isManaged()) return;
            this.shownInEditViewCheckBox.setValue(Boolean.valueOf(false));
            return;
        }
        finally {
            this.synchronizingGuiFields = false;
        }
    }

    private void updateShowRawValue() {
        if (this.userDidChangeShowRawValueCheckBox) {
            return;
        }
        this.synchronizingGuiFields = true;
        try {
            this.showRawValueCheckBox.setValue(Boolean.valueOf(true));
            return;
        }
        finally {
            this.synchronizingGuiFields = false;
        }
    }

    private void updateVisibilityOfScriptRelatedFields() {
        boolean scriptable = this.isScriptable();
        FieldUtil.setVisibility(scriptable, new Field[]{this.scriptTypeRadioGroup, this.scriptChooser});
        if (this.defaultValueField != null) {
            FieldUtil.setVisibility(!scriptable, (Field)this.defaultValueField.get());
        }
        if (this.mandatoryCheckbox != null) {
            FieldUtil.setVisibility(!scriptable, new Field[]{this.mandatoryCheckbox});
        }
        this.updateVisibilityOfShownInEditViewField();
        this.updateVisibilityOfShowRawValueField();
    }

    private void hidePropertyTypeRelatedFields() {
        if (this.defaultValueField != null) {
            Field field = (Field)this.defaultValueField.get();
            field.hide();
            if (this.getFormPanel().getFields().contains(field)) {
                this.removeField((Widget)field);
            }
            this.defaultValueField = null;
        }
    }

    private EntityTypePropertyTypeSelectionWidget createETPTSelectionWidget(List<EntityTypePropertyType<?>> etpts) {
        etpts.add(0, null);
        String lastCode = etpts.size() > 1 ? etpts.get(etpts.size() - 1).getPropertyType().getCode() : "(top)";
        EntityTypePropertyTypeSelectionWidget result = new EntityTypePropertyTypeSelectionWidget(this.viewContext, this.getId(), etpts, lastCode);
        FieldUtil.setMandatoryFlag(result, true);
        return result;
    }

    private String getDefaultValue() {
        if (this.defaultValueField != null) {
            return PropertyFieldFactory.valueToString(((Field)this.defaultValueField.get()).getValue());
        }
        return null;
    }

    private boolean getShowRawValue() {
        if (!this.isManaged() || !this.isShownInEditView()) {
            return false;
        }
        return this.showRawValueCheckBox.getValue();
    }

    String tryGetScriptNameValue() {
        if (this.scriptChooser == null) {
            return null;
        }
        return (String)this.scriptChooser.getValue();
    }

    private Long getPreviousETPTOrdinal() {
        Long value = 0L;
        if (this.etptSelectionWidget != null) {
            value = this.etptSelectionWidget.getSelectedEntityTypePropertyTypeOrdinal();
        }
        return value;
    }

    private String getSectionValue() {
        if (this.sectionSelectionWidget != null) {
            return this.sectionSelectionWidget.getSimpleValue();
        }
        return null;
    }

    private void updateVisibilityOfShownInEditViewField() {
        if (this.shownInEditViewCheckBox != null) {
            FieldUtil.setVisibility(this.isManaged(), new Field[]{this.shownInEditViewCheckBox});
        }
    }

    private void updateVisibilityOfShowRawValueField() {
        if (this.showRawValueCheckBox != null) {
            FieldUtil.setVisibility(this.isManaged() && this.isShownInEditView(), new Field[]{this.showRawValueCheckBox});
        }
    }

    private boolean isManaged() {
        return this.isScriptable() && this.scriptTypeManaged.getValue() != false;
    }

    private boolean isDynamic() {
        return this.isScriptable() && this.scriptTypeDynamic.getValue() != false;
    }

    private boolean isScriptable() {
        return this.scriptableCheckbox.getValue();
    }

    private boolean isShownInEditView() {
        if (!this.isScriptable()) {
            return true;
        }
        if (this.isDynamic()) {
            return false;
        }
        return this.shownInEditViewCheckBox.getValue();
    }

    private final CodeField getPropertyTypeCodeField() {
        if (this.propertyTypeCodeField == null) {
            this.propertyTypeCodeField = new CodeField(this.viewContext, this.viewContext.getMessage("code", new Object[0]));
            this.propertyTypeCodeField.setId(String.valueOf(this.getId()) + "_code");
        }
        return this.propertyTypeCodeField;
    }

    private final VarcharField getPropertyTypeLabelField() {
        if (this.propertyTypeLabelField == null) {
            this.propertyTypeLabelField = new VarcharField(this.viewContext.getMessage("label", new Object[0]), true);
            this.propertyTypeLabelField.setId(String.valueOf(this.getId()) + "_label");
            this.propertyTypeLabelField.setMaxLength(128);
        }
        return this.propertyTypeLabelField;
    }

    private final MultilineVarcharField getPropertyTypeDescriptionField() {
        if (this.propertyTypeDescriptionField == null) {
            this.propertyTypeDescriptionField = new DescriptionField(this.viewContext, true, this.getId());
        }
        return this.propertyTypeDescriptionField;
    }

    private final DataTypeSelectionWidget getDataTypeSelectionWidget() {
        if (this.dataTypeSelectionWidget == null) {
            this.dataTypeSelectionWidget = new DataTypeSelectionWidget(this.viewContext, true);
            SelectionChangedListener<DataTypeModel> dataTypeSelectionChangedListener = new SelectionChangedListener<DataTypeModel>(){

                public final void selectionChanged(SelectionChangedEvent<DataTypeModel> se) {
                    this.hideDataTypeRelatedFields();
                    DataTypeModel selectedItem = (DataTypeModel)se.getSelectedItem();
                    if (selectedItem != null) {
                        DataTypeCode dataTypeCode = selectedItem.getDataType().getCode();
                        switch (dataTypeCode) {
                            case CONTROLLEDVOCABULARY: {
                                this.showFields(new Field[]{AddPropertyTypeDialog.this.vocabularySelectionWidget});
                                break;
                            }
                            case MATERIAL: {
                                this.showFields(new Field[]{AddPropertyTypeDialog.this.materialTypeSelectionWidget});
                                break;
                            }
                            case XML: {
                                this.showFields(new Field[]{AddPropertyTypeDialog.this.xmlSchemaField, AddPropertyTypeDialog.this.xslTransformationsField});
                                break;
                            }
                        }
                        AddPropertyTypeDialog.this.updatePropertyTypeRelatedFields();
                    }
                }

                private void showFields(Field<?> ... fields) {
                    FieldUtil.setVisibility(true, fields);
                }

                private void hideDataTypeRelatedFields() {
                    FieldUtil.setVisibility(false, new Field[]{AddPropertyTypeDialog.this.vocabularySelectionWidget, AddPropertyTypeDialog.this.materialTypeSelectionWidget, AddPropertyTypeDialog.this.xmlSchemaField, AddPropertyTypeDialog.this.xslTransformationsField});
                }
            };
            this.dataTypeSelectionWidget.addSelectionChangedListener((SelectionChangedListener)dataTypeSelectionChangedListener);
        }
        return this.dataTypeSelectionWidget;
    }

    private final VocabularySelectionWidget getVocabularySelectionWidget() {
        if (this.vocabularySelectionWidget == null) {
            this.vocabularySelectionWidget = new VocabularySelectionWidget(this.viewContext);
            Listener<BaseEvent> vocabularyListener = new Listener<BaseEvent>(){

                public void handleEvent(BaseEvent be) {
                    AddPropertyTypeDialog.this.updatePropertyTypeRelatedFields();
                }
            };
            this.vocabularySelectionWidget.addListener(Events.SelectionChange, (Listener)vocabularyListener);
            FieldUtil.markAsMandatory(this.vocabularySelectionWidget);
        }
        return this.vocabularySelectionWidget;
    }

    private MaterialTypeSelectionWidget getMaterialTypeSelectionWidget() {
        if (this.materialTypeSelectionWidget == null) {
            this.materialTypeSelectionWidget = MaterialTypeSelectionWidget.createWithAdditionalOption(this.viewContext, this.viewContext.getMessage("allow_any_type", new Object[0]), null, ID);
            Listener<BaseEvent> materialListener = new Listener<BaseEvent>(){

                public void handleEvent(BaseEvent be) {
                    AddPropertyTypeDialog.this.updatePropertyTypeRelatedFields();
                }
            };
            this.materialTypeSelectionWidget.addListener(Events.SelectionChange, (Listener)materialListener);
            FieldUtil.markAsMandatory(this.materialTypeSelectionWidget);
        }
        return this.materialTypeSelectionWidget;
    }

    private final XmlField getXmlSchemaField() {
        if (this.xmlSchemaField == null) {
            String label = this.viewContext.getMessage("xml_schema", new Object[0]);
            String description = this.viewContext.getMessage("xml_schema_info", new Object[0]);
            AbstractImagePrototype infoIcon = AbstractImagePrototype.create((ImageResource)this.viewContext.getImageBundle().getInfoIcon());
            this.xmlSchemaField = new XmlField(label, false);
            FieldUtil.addInfoIcon(this.xmlSchemaField, description, infoIcon.createImage());
        }
        return this.xmlSchemaField;
    }

    private final XmlField getXslTransformationsField() {
        if (this.xslTransformationsField == null) {
            String label = this.viewContext.getMessage("xslt", new Object[0]);
            String description = this.viewContext.getMessage("xslt_info", new Object[0]);
            AbstractImagePrototype infoIcon = AbstractImagePrototype.create((ImageResource)this.viewContext.getImageBundle().getInfoIcon());
            this.xslTransformationsField = new XmlField(label, false);
            FieldUtil.addInfoIcon(this.xslTransformationsField, description, infoIcon.createImage());
        }
        return this.xslTransformationsField;
    }

    private final class AssignPropertyTypeCallback
    extends AbstractAsyncCallback<String> {
        final AsyncCallback<Void> registrationCallback;

        AssignPropertyTypeCallback(IViewContext<?> viewContext, AsyncCallback<Void> registrationCallback) {
            super(viewContext, null);
            this.registrationCallback = registrationCallback;
        }

        @Override
        protected final void process(String result) {
            this.registrationCallback.onSuccess(null);
        }

        @Override
        public void finishOnFailure(Throwable caught) {
        }
    }

    private class AsyncCallbackEntityTypeForDialog<T extends List<? extends EntityType>>
    implements AsyncCallback<T> {
        private String code;

        AsyncCallbackEntityTypeForDialog(String code) {
            this.code = code;
        }

        public void onFailure(Throwable caught) {
        }

        public void onSuccess(T result) {
            EntityType finalType = null;
            for (EntityType type : result) {
                if (!type.getCode().equals(this.code)) continue;
                finalType = type;
            }
            AddPropertyTypeDialog.this.entityLoaded(finalType);
        }
    }
}

