/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.VocabularyTermModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.columns.framework.IColumnDefinitionUI;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.DateFormField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.HyperlinkField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.IChosenEntitiesListener;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.IntegerField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.MaterialChooserField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.MultilineVarcharField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.RealField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.VarcharField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.VocabularyTermSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.lang.StringEscapeUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.FieldEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.SimpleComboBox;
import com.extjs.gxt.ui.client.widget.grid.CellEditor;
import java.util.List;

public class ColumnUtils {
    public static <T> CellEditor createCellEditor(IColumnDefinitionUI<T> column, IViewContext<?> viewContext) {
        CellEditor editor;
        DataTypeCode dataType = column.tryToGetDataType();
        assert (dataType != null);
        switch (dataType) {
            case INTEGER: {
                editor = new StringBasedCellEditor((Field<? extends Object>)new IntegerField("", false));
                break;
            }
            case REAL: {
                editor = new StringBasedCellEditor((Field<? extends Object>)new RealField("", false));
                break;
            }
            case TIMESTAMP: {
                editor = new StringBasedCellEditor((Field<? extends Object>)new DateFormField("", false));
                break;
            }
            case VARCHAR: {
                editor = new StringEscapingCellEditor((Field<? extends Object>)new VarcharField("", false));
                break;
            }
            case HYPERLINK: {
                editor = new StringEscapingCellEditor((Field<? extends Object>)new HyperlinkField("", false));
                break;
            }
            case MULTILINE_VARCHAR: 
            case XML: {
                editor = new StringEscapingCellEditor((Field)new MultilineVarcharField("", false)){

                    protected void onSpecialKey(FieldEvent fe) {
                        if (fe.getKeyCode() != 13) {
                            super.onSpecialKey(fe);
                        }
                    }
                };
                break;
            }
            case BOOLEAN: {
                final SimpleComboBox combo = new SimpleComboBox();
                combo.setForceSelection(true);
                combo.setTriggerAction(ComboBox.TriggerAction.ALL);
                combo.add((Object)"true");
                combo.add((Object)"false");
                editor = new CellEditor((Field)combo){

                    public Object preProcessValue(Object value) {
                        if (value == null) {
                            return value;
                        }
                        return combo.findModel((Object)value.toString());
                    }

                    public Object postProcessValue(Object value) {
                        if (value == null) {
                            return value;
                        }
                        return ((ModelData)value).get("value");
                    }
                };
                break;
            }
            case CONTROLLEDVOCABULARY: {
                final VocabularyTermSelectionWidget vocabularyTermSelectionWidget = (VocabularyTermSelectionWidget)VocabularyTermSelectionWidget.create("_table_edit", "", column.tryGetVocabulary(), false, viewContext, null, false).get();
                editor = new CellEditor((Field)vocabularyTermSelectionWidget){

                    public Object preProcessValue(Object value) {
                        if (value == null) {
                            return value;
                        }
                        return vocabularyTermSelectionWidget.findModel(value.toString());
                    }

                    public Object postProcessValue(Object value) {
                        if (value == null) {
                            return value;
                        }
                        return ((VocabularyTermModel)value).getTerm();
                    }
                };
                break;
            }
            case MATERIAL: {
                MaterialChooserField materialChooser = MaterialChooserField.create("", false, null, null, viewContext.getCommonViewContext());
                editor = new StringBasedCellEditor((Field<? extends Object>)materialChooser);
                materialChooser.addListener(Events.TriggerClick, (Listener)new Listener<BaseEvent>(){

                    public void handleEvent(BaseEvent be) {
                        editor.setAllowBlur(true);
                    }
                });
                materialChooser.addChosenEntityListener(new IChosenEntitiesListener<TableModelRowWithObject<Material>>(){

                    @Override
                    public void entitiesChosen(List<TableModelRowWithObject<Material>> entities) {
                        editor.completeEdit();
                    }
                });
                break;
            }
            default: {
                throw new UserFailureException("Edition of properties of type '" + dataType + "' is not supported.");
            }
        }
        return editor;
    }

    private static class StringBasedCellEditor
    extends CellEditor {
        public StringBasedCellEditor(Field<? extends Object> field) {
            super(field);
        }

        public Object preProcessValue(Object value) {
            if (StringUtils.isBlank(value)) {
                return null;
            }
            return this.getField().getPropertyEditor().convertStringValue(value.toString());
        }

        public Object postProcessValue(Object value) {
            if (StringUtils.isBlank(value)) {
                return null;
            }
            return this.getField().getPropertyEditor().getStringValue(value);
        }
    }

    private static class StringEscapingCellEditor
    extends CellEditor {
        public StringEscapingCellEditor(Field<? extends Object> field) {
            super(field);
        }

        public Object preProcessValue(Object value) {
            if (value == null) {
                return value;
            }
            return StringEscapeUtils.unescapeHtml(value.toString());
        }

        public Object postProcessValue(Object value) {
            if (value == null) {
                return null;
            }
            return StringEscapeUtils.escapeHtml(value.toString());
        }
    }
}

