/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ICriteriaProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.SetUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class GridUtils {
    public static DatabaseModificationKind[] getRelevantModifications(DatabaseModificationKind.ObjectKind entityKind, ICriteriaProvider<?> criteriaProvider) {
        ArrayList<DatabaseModificationKind> relevantModifications = new ArrayList<DatabaseModificationKind>();
        SetUtils.addAll(relevantModifications, criteriaProvider.getRelevantModifications());
        relevantModifications.addAll(GridUtils.getGridRelevantModifications(entityKind, true));
        return relevantModifications.toArray(DatabaseModificationKind.EMPTY_ARRAY);
    }

    public static final Set<DatabaseModificationKind> getGridRelevantModifications(DatabaseModificationKind.ObjectKind entity, boolean withProjectAndSpace) {
        HashSet<DatabaseModificationKind> result = new HashSet<DatabaseModificationKind>();
        result.add(DatabaseModificationKind.createOrDelete(entity));
        result.add(DatabaseModificationKind.edit(entity));
        result.add(DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT));
        result.add(DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT));
        result.add(DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.VOCABULARY_TERM));
        result.add(DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.METAPROJECT));
        if (withProjectAndSpace) {
            DatabaseModificationKind.addAny(result, DatabaseModificationKind.ObjectKind.PROJECT);
            DatabaseModificationKind.addAny(result, DatabaseModificationKind.ObjectKind.SPACE);
        }
        return result;
    }
}

