/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property_type;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.SimplifiedBaseModelData;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.PropertyTypeRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.DropDownList;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ResultSet;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.store.ListStore;
import java.util.ArrayList;
import java.util.List;

public final class PropertyTypeSelectionWidget
extends DropDownList<PropertyTypeComboModel, PropertyType> {
    private static final String EMPTY_RESULT_SUFFIX = "property types";
    private static final String CHOOSE_SUFFIX = "property type";
    static final String SUFFIX = "property-type";
    private final IViewContext<ICommonClientServiceAsync> viewContext;

    public PropertyTypeSelectionWidget(IViewContext<ICommonClientServiceAsync> viewContext, String idSuffix) {
        super(viewContext, SUFFIX + idSuffix, "property_type", "code", CHOOSE_SUFFIX, EMPTY_RESULT_SUFFIX);
        this.viewContext = viewContext;
        this.setTemplate(GWTUtils.getTooltipTemplate("code", "tooltip"));
    }

    public final String tryGetSelectedPropertyTypeCode() {
        PropertyType propertyType = this.tryGetSelectedPropertyType();
        return propertyType == null ? null : propertyType.getCode();
    }

    public final PropertyType tryGetSelectedPropertyType() {
        return (PropertyType)super.tryGetSelected();
    }

    @Override
    protected List<PropertyTypeComboModel> convertItems(List<PropertyType> types) {
        ArrayList<PropertyTypeComboModel> result = new ArrayList<PropertyTypeComboModel>();
        for (PropertyType st : types) {
            result.add(new PropertyTypeComboModel(st, types));
        }
        return result;
    }

    @Override
    protected void loadData(AbstractAsyncCallback<List<PropertyType>> callback) {
        DefaultResultSetConfig<String, TableModelRowWithObject<PropertyType>> config = DefaultResultSetConfig.createFetchAll();
        this.viewContext.getService().listPropertyTypes(config, new ListPropertyTypesCallback(this.viewContext));
        callback.ignore();
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return DatabaseModificationKind.any(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE);
    }

    private final class ListPropertyTypesCallback
    extends AbstractAsyncCallback<TypedTableResultSet<PropertyType>> {
        ListPropertyTypesCallback(IViewContext<ICommonClientServiceAsync> viewContext) {
            super(viewContext);
        }

        @Override
        protected void process(TypedTableResultSet<PropertyType> result) {
            ResultSet<TableModelRowWithObject<PropertyType>> resultSet = result.getResultSet();
            PropertyTypeSelectionWidget.this.resultSetKey = resultSet.getResultSetKey();
            ListStore propertyTypeStore = PropertyTypeSelectionWidget.this.getStore();
            propertyTypeStore.removeAll();
            List<TableModelRowWithObject<PropertyType>> rows = resultSet.getList().extractOriginalObjects();
            ArrayList<PropertyType> types = new ArrayList<PropertyType>();
            for (TableModelRowWithObject<PropertyType> row : rows) {
                types.add(row.getObjectOrNull());
            }
            propertyTypeStore.add(PropertyTypeSelectionWidget.this.convertItems((List<PropertyType>)types));
            if (propertyTypeStore.getCount() > 0) {
                PropertyTypeSelectionWidget.this.setEmptyText(this.viewContext.getMessage("combobox_choose", PropertyTypeSelectionWidget.CHOOSE_SUFFIX));
                PropertyTypeSelectionWidget.this.setReadOnly(false);
            } else {
                PropertyTypeSelectionWidget.this.setEmptyText(this.viewContext.getMessage("combobox_empty", PropertyTypeSelectionWidget.EMPTY_RESULT_SUFFIX));
                PropertyTypeSelectionWidget.this.setReadOnly(true);
            }
            PropertyTypeSelectionWidget.this.applyEmptyText();
            PropertyTypeSelectionWidget.this.removeResultSetFromCache();
        }
    }

    static class PropertyTypeComboModel
    extends SimplifiedBaseModelData {
        private static final long serialVersionUID = 1L;

        public PropertyTypeComboModel(PropertyType entity, List<PropertyType> types) {
            this.set("code", PropertyTypeRenderer.getDisplayName(entity, types));
            this.set("tooltip", PropertyTypeRenderer.renderAsTooltip(entity));
            this.set("object", entity);
        }
    }
}

