/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.search;

import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.IDatasetLister;
import ch.systemsx.cisd.openbis.generic.server.business.search.AbstractSearchManager;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IHibernateSearchDAO;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetAttributeSearchFieldKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchAssociationCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriterion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchField;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchSubCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.translator.DtoConverters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.dao.DataAccessException;

public class DataSetSearchManager
extends AbstractSearchManager<IDatasetLister> {
    private final AbstractSearchManager.IRelationshipHandler CHILDREN_RELATIONSHIP_HANDLER = new AbstractSearchManager.IRelationshipHandler(){

        @Override
        public Collection<Long> findRelatedIdsByCriteria(String userId, DetailedSearchCriteria criteria, List<DetailedSearchSubCriteria> otherSubCriterias) {
            return DataSetSearchManager.this.findDataSetIds(userId, criteria, otherSubCriterias);
        }

        @Override
        public Map<Long, Set<Long>> listIdsToRelatedIds(Collection<Long> dataSetIds) {
            return ((IDatasetLister)DataSetSearchManager.this.lister).listChildrenIds(dataSetIds);
        }

        @Override
        public Map<Long, Set<Long>> listRelatedIdsToIds(Collection<Long> childrenDataSetIds) {
            return ((IDatasetLister)DataSetSearchManager.this.lister).listParentIds(childrenDataSetIds);
        }
    };
    private final AbstractSearchManager.IRelationshipHandler PARENT_RELATIONSHIP_HANDLER = new AbstractSearchManager.IRelationshipHandler(){

        @Override
        public Collection<Long> findRelatedIdsByCriteria(String userId, DetailedSearchCriteria criteria, List<DetailedSearchSubCriteria> otherSubCriterias) {
            return DataSetSearchManager.this.findDataSetIds(userId, criteria, otherSubCriterias);
        }

        @Override
        public Map<Long, Set<Long>> listIdsToRelatedIds(Collection<Long> dataSetIds) {
            return ((IDatasetLister)DataSetSearchManager.this.lister).listParentIds(dataSetIds);
        }

        @Override
        public Map<Long, Set<Long>> listRelatedIdsToIds(Collection<Long> parentDataSetIds) {
            return ((IDatasetLister)DataSetSearchManager.this.lister).listChildrenIds(parentDataSetIds);
        }
    };

    public DataSetSearchManager(IHibernateSearchDAO searchDAO, IDatasetLister lister) {
        super(searchDAO, lister);
    }

    public List<AbstractExternalData> searchForDataSets(String userId, DetailedSearchCriteria criteria) throws DataAccessException {
        List<Long> dataSetIds;
        DetailedSearchCriteria parentCriteria = new DetailedSearchCriteria();
        DetailedSearchCriteria childCriteria = new DetailedSearchCriteria();
        ArrayList<DetailedSearchSubCriteria> otherSubCriterias = new ArrayList<DetailedSearchSubCriteria>();
        this.groupDataSetSubCriteria(criteria.getSubCriterias(), parentCriteria, childCriteria, otherSubCriterias);
        Collection<Long> filteredDataSetIds = dataSetIds = this.findDataSetIds(userId, criteria, otherSubCriterias);
        if (!parentCriteria.isEmpty()) {
            filteredDataSetIds = this.filterSearchResultsBySubcriteria(userId, dataSetIds, parentCriteria, this.PARENT_RELATIONSHIP_HANDLER);
        }
        if (!childCriteria.isEmpty()) {
            filteredDataSetIds = this.filterSearchResultsBySubcriteria(userId, dataSetIds, childCriteria, this.CHILDREN_RELATIONSHIP_HANDLER);
        }
        return ((IDatasetLister)this.lister).listByDatasetIds(this.restrictResultSetIfNecessary(filteredDataSetIds));
    }

    private List<Long> findDataSetIds(String userId, DetailedSearchCriteria criteria, List<DetailedSearchSubCriteria> otherSubCriterias) {
        ArrayList<DetailedSearchAssociationCriteria> associations = new ArrayList<DetailedSearchAssociationCriteria>();
        for (DetailedSearchSubCriteria subCriteria : otherSubCriterias) {
            associations.add(this.findAssociatedEntities(userId, subCriteria));
        }
        if (criteria.getCriteria().isEmpty() && otherSubCriterias.isEmpty()) {
            criteria.getCriteria().add(new DetailedSearchCriterion(DetailedSearchField.createAttributeField(DataSetAttributeSearchFieldKind.CODE), "*"));
        }
        List<Long> dataSetIds = this.searchDAO.searchForEntityIds(userId, criteria, DtoConverters.convertEntityKind(EntityKind.DATA_SET), associations);
        return dataSetIds;
    }

    private void groupDataSetSubCriteria(List<DetailedSearchSubCriteria> allSubCriterias, DetailedSearchCriteria parentCriteria, DetailedSearchCriteria childCriteria, List<DetailedSearchSubCriteria> otherSubCriterias) {
        parentCriteria.setCriteria(new ArrayList<DetailedSearchCriterion>());
        childCriteria.setCriteria(new ArrayList<DetailedSearchCriterion>());
        for (DetailedSearchSubCriteria subCriteria : allSubCriterias) {
            switch (subCriteria.getTargetEntityKind()) {
                case DATA_SET_PARENT: {
                    this.mergeSubCriteria(parentCriteria, subCriteria);
                    break;
                }
                case DATA_SET_CHILD: {
                    this.mergeSubCriteria(childCriteria, subCriteria);
                    break;
                }
                default: {
                    otherSubCriterias.add(subCriteria);
                }
            }
        }
    }
}

