/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.sybit.imageviewer.gui;

import ch.systemsx.sybit.imageviewer.data.SettingsUtil;
import ch.systemsx.sybit.imageviewer.gui.FileTypeFilter;
import ch.systemsx.sybit.imageviewer.gui.ImagePreview;
import ch.systemsx.sybit.imageviewer.gui.ImageViewer;
import ch.systemsx.sybit.imageviewer.processors.ImageUtil;
import ch.systemsx.sybit.imageviewer.utils.ImageViewerUtils;
import ij.ImagePlus;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;

public class ImageViewerMenu
extends JMenuBar
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JMenu fileMenu;
    private JMenu viewMenu;
    private JMenu helpMenu;
    private ButtonGroup viewType;
    private ImageViewer imageViewer;
    private JFileChooser imageSelector;

    public ImageViewerMenu(ImageViewer imageViewer, int mode, String defaultSize) {
        JMenuItem menuItem;
        this.imageViewer = imageViewer;
        this.fileMenu = new JMenu("File");
        this.fileMenu.setMnemonic(70);
        this.fileMenu.getAccessibleContext().setAccessibleDescription("");
        if (mode == SettingsUtil.LocalSystem) {
            menuItem = new JMenuItem("Add", 65);
            menuItem.setActionCommand("open");
            menuItem.addActionListener(this);
            this.fileMenu.add(menuItem);
        }
        if (mode != SettingsUtil.LMCWorkflow) {
            menuItem = new JMenuItem("Exit", 69);
            menuItem.setActionCommand("exit");
            menuItem.addActionListener(this);
            this.fileMenu.add(menuItem);
            this.add(this.fileMenu);
        }
        this.viewMenu = new JMenu("View");
        this.viewMenu.setMnemonic(86);
        this.viewMenu.getAccessibleContext().setAccessibleDescription("");
        this.add(this.viewMenu);
        this.viewType = new ButtonGroup();
        JRadioButtonMenuItem sizeMenuItem = new JRadioButtonMenuItem("Thumbnail");
        sizeMenuItem.setActionCommand("thumbnail");
        if (defaultSize.equals("thumbnail")) {
            sizeMenuItem.setSelected(true);
        }
        sizeMenuItem.addActionListener(this);
        this.viewType.add(sizeMenuItem);
        this.viewMenu.add(sizeMenuItem);
        for (int i = 1; i < 5; ++i) {
            sizeMenuItem = new JRadioButtonMenuItem(i * 25 + "%");
            sizeMenuItem.setActionCommand(String.valueOf(i * 25));
            if (defaultSize.equals(String.valueOf(i * 25))) {
                sizeMenuItem.setSelected(true);
            }
            sizeMenuItem.addActionListener(this);
            this.viewType.add(sizeMenuItem);
            this.viewMenu.add(sizeMenuItem);
        }
        this.helpMenu = new JMenu("Help");
        this.helpMenu.setMnemonic(72);
        this.helpMenu.getAccessibleContext().setAccessibleDescription("");
        this.add(this.helpMenu);
        JMenuItem menuItem2 = new JMenuItem("About", 65);
        menuItem2.setActionCommand("about");
        menuItem2.addActionListener(this);
        this.helpMenu.add(menuItem2);
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getActionCommand().equals("exit")) {
                this.imageViewer.checkBeforeExit();
                this.imageViewer.finish();
                this.imageViewer.dispose();
            } else if (e.getActionCommand().equals("open")) {
                File file;
                int returnVal;
                if (this.imageSelector == null) {
                    this.imageSelector = new JFileChooser();
                    this.imageSelector.addChoosableFileFilter(new FileTypeFilter());
                    this.imageSelector.setAcceptAllFileFilterUsed(false);
                    this.imageSelector.setAccessory(new ImagePreview(this.imageSelector));
                    this.imageSelector.setFileSelectionMode(2);
                }
                if ((returnVal = this.imageSelector.showDialog(this.imageViewer, "Select")) == 0 && (file = this.imageSelector.getSelectedFile()) != null) {
                    List<File> filesToAdd = new ArrayList<File>();
                    if (file.isDirectory()) {
                        filesToAdd = ImageViewerUtils.listImagesInDirectory(file, null);
                    } else {
                        filesToAdd.add(file);
                    }
                    final List<File> filesToLoad = filesToAdd;
                    new Thread(new Runnable(){

                        public void run() {
                            for (final File fileToAdd : filesToLoad) {
                                final ImagePlus imagePlus = ImageUtil.createScaledImagePlus(fileToAdd.getAbsolutePath());
                                EventQueue.invokeLater(new Runnable(){

                                    public void run() {
                                        ImageViewerMenu.this.imageViewer.getImagesList().addImageToList(imagePlus, fileToAdd.getAbsolutePath());
                                    }
                                });
                            }
                        }
                    }).start();
                }
                this.imageSelector.setSelectedFile(null);
            } else if (e.getActionCommand().equals("about")) {
                JOptionPane.showMessageDialog(this.imageViewer, "ImageViewer (v" + SettingsUtil.version + ") - application for processing images", "ImageViewer", 1);
            } else if (e.getActionCommand().equals("thumbnail")) {
                this.imageViewer.setImageScale("thumbnail");
                this.imageViewer.refreshGuiAfterImageSelection();
                this.imageViewer.updateImage();
            } else if (e.getSource() instanceof JRadioButtonMenuItem) {
                this.imageViewer.getImagePanelScrollWraper().update(this.imageViewer.getImagePanelScrollWraper().getGraphics());
                this.imageViewer.setImageScale(e.getActionCommand());
                this.imageViewer.showLoading();
                if (this.imageViewer.getImageHandler() != null) {
                    this.imageViewer.refreshGuiAfterImageSelection();
                    this.imageViewer.updateImage();
                } else {
                    this.imageViewer.cleanImage();
                }
            }
        }
        catch (Throwable t) {
            this.imageViewer.showErrorDialog("Error during processing image", t, true);
        }
    }

    public void selectSizeItem(String selectedSize) {
        Enumeration<AbstractButton> buttons = this.viewType.getElements();
        while (buttons.hasMoreElements()) {
            JRadioButtonMenuItem button = (JRadioButtonMenuItem)buttons.nextElement();
            if (button.getActionCommand().equals(selectedSize)) {
                button.setSelected(true);
                continue;
            }
            button.setSelected(false);
        }
    }
}

