/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.sybit.imageviewer.utils;

import ch.systemsx.sybit.imageviewer.data.ImageViewerParameters;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageViewerUtils {
    public static List<File> listImagesInDirectory(File directory, final String filter) {
        ArrayList<File> listedImages = null;
        if (directory != null && directory.isDirectory()) {
            listedImages = new ArrayList<File>();
            File[] directoryContent = null;
            directoryContent = filter != null ? directory.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.toLowerCase().contains(filter.toLowerCase());
                }
            }) : directory.listFiles();
            if (directoryContent != null) {
                for (File fileInDirectory : directoryContent) {
                    String extension = null;
                    String fileName = fileInDirectory.getName();
                    int i = fileName.lastIndexOf(46);
                    if (i > 0 && i < fileName.length() - 1) {
                        extension = fileName.substring(i + 1).toLowerCase();
                    }
                    if (extension == null || !extension.equals("tiff") && !extension.equals("tif") && !extension.equals("gif") && !extension.equals("jpeg") && !extension.equals("jpg") && !extension.equals("png")) continue;
                    listedImages.add(fileInDirectory);
                }
            }
        }
        return listedImages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageViewerParameters generateParametersCopy(ImageViewerParameters imageViewerParameters) throws Throwable {
        ImageViewerParameters copyOfParameters = new ImageViewerParameters();
        ObjectOutputStream outputStream = null;
        ObjectInputStream inputStream = null;
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream byteInputStream = null;
        try {
            outputStream = new ObjectOutputStream(byteOutputStream);
            outputStream.writeObject(imageViewerParameters);
            outputStream.flush();
            byteInputStream = new ByteArrayInputStream(byteOutputStream.toByteArray());
            inputStream = new ObjectInputStream(byteInputStream);
            copyOfParameters = (ImageViewerParameters)inputStream.readObject();
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return copyOfParameters;
    }
}

