/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.api.v1.impl;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.etlserver.DssRegistrationLogger;
import ch.systemsx.cisd.etlserver.TopLevelDataSetRegistratorGlobalState;
import ch.systemsx.cisd.etlserver.registrator.DataSetFile;
import ch.systemsx.cisd.etlserver.registrator.DataSetRegistrationContext;
import ch.systemsx.cisd.etlserver.registrator.DataSetRegistrationDetails;
import ch.systemsx.cisd.etlserver.registrator.DataSetRegistrationPersistentMap;
import ch.systemsx.cisd.etlserver.registrator.IEntityOperationService;
import ch.systemsx.cisd.etlserver.registrator.IncomingFileDeletedBeforeRegistrationException;
import ch.systemsx.cisd.etlserver.registrator.api.impl.RollbackStack;
import ch.systemsx.cisd.etlserver.registrator.api.impl.SecondaryTransactionFailure;
import ch.systemsx.cisd.etlserver.registrator.api.v1.IDataSet;
import ch.systemsx.cisd.etlserver.registrator.api.v1.IDataSetRegistrationTransaction;
import ch.systemsx.cisd.etlserver.registrator.api.v1.IDataSetUpdatable;
import ch.systemsx.cisd.etlserver.registrator.api.v1.IExperiment;
import ch.systemsx.cisd.etlserver.registrator.api.v1.IExperimentUpdatable;
import ch.systemsx.cisd.etlserver.registrator.api.v1.IMaterial;
import ch.systemsx.cisd.etlserver.registrator.api.v1.IMetaproject;
import ch.systemsx.cisd.etlserver.registrator.api.v1.IProject;
import ch.systemsx.cisd.etlserver.registrator.api.v1.ISample;
import ch.systemsx.cisd.etlserver.registrator.api.v1.ISpace;
import ch.systemsx.cisd.etlserver.registrator.api.v1.IVocabulary;
import ch.systemsx.cisd.etlserver.registrator.api.v1.IVocabularyTerm;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.AbstractTransactionState;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.AuthorizationService;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.ExperimentImmutable;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.ExternalDataManagementSystemImmutable;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.MaterialImmutable;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.ProjectImmutable;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.SampleImmutable;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.SearchService;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.SpaceImmutable;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.VocabularyTerm;
import ch.systemsx.cisd.etlserver.registrator.v1.AbstractOmniscientTopLevelDataSetRegistrator;
import ch.systemsx.cisd.etlserver.registrator.v1.DataSetRegistrationService;
import ch.systemsx.cisd.etlserver.registrator.v1.DataSetStorageAlgorithmRunner;
import ch.systemsx.cisd.etlserver.registrator.v1.IDataSetOnErrorActionDecision;
import ch.systemsx.cisd.etlserver.registrator.v1.IDataSetRegistrationDetailsFactory;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v1.IDataSetImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v1.IExperimentImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v1.IExternalDataManagementSystemImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v1.IMaterialImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v1.IProjectImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v1.ISampleImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v1.ISearchService;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v1.ISpaceImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v1.IVocabularyImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v1.authorization.IAuthorizationService;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.AtomicEntityOperationDetails;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetRegistrationInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.EntityOperationsState;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExternalDataManagementSystem;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Date;
import java.util.List;
import java.util.Random;
import net.lemnik.eodsql.DynamicTransactionQuery;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.log4j.Logger;

public class DataSetRegistrationTransaction<T extends DataSetInformation>
implements IDataSetRegistrationTransaction,
DataSetStorageAlgorithmRunner.IRollbackDelegate<T>,
DataSetStorageAlgorithmRunner.IDataSetInApplicationServerRegistrator<T>,
DataSetRegistrationContext.IHolder {
    public static final String SUCCESS_MESSAGE = "Successfully committed transaction";
    private static final String ROLLBACK_QUEUE1_FILE_NAME_SUFFIX = "rollBackQueue1";
    private static final String ROLLBACK_QUEUE2_FILE_NAME_SUFFIX = "rollBackQueue2";
    private static final String ROLLBACK_STACK_FILE_NAME_DATE_FORMAT_PATTERN = "yyyyMMddHHmmssSSS";
    static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DataSetRegistrationTransaction.class);
    private AbstractTransactionState<T> state;
    private DataSetRegistrationContext registrationContext;
    private final DataSetRegistrationService<T> registrationService;
    private final IEncapsulatedOpenBISService openBisService;

    public static synchronized RollbackStack[] findRollbackStacks(File rollBackStackParentFolder) {
        File[] rollbackQueue1Files = rollBackStackParentFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(DataSetRegistrationTransaction.ROLLBACK_QUEUE1_FILE_NAME_SUFFIX);
            }
        });
        RollbackStack[] rollbackStacks = new RollbackStack[rollbackQueue1Files.length];
        int i = 0;
        while (i < rollbackQueue1Files.length) {
            RollbackStack stack;
            File rollbackStackQueue1 = rollbackQueue1Files[i];
            rollbackStacks[i] = stack = DataSetRegistrationTransaction.createExistingRollbackStack(rollbackStackQueue1);
            ++i;
        }
        return rollbackStacks;
    }

    public static synchronized void rollbackDeadTransactions(File rollBackStackParentFolder) {
        RollbackStack[] stacks;
        RollbackStack[] rollbackStackArray = stacks = DataSetRegistrationTransaction.findRollbackStacks(rollBackStackParentFolder);
        int n = stacks.length;
        int n2 = 0;
        while (n2 < n) {
            RollbackStack stack = rollbackStackArray[n2];
            if (stack.isLockedState()) {
                operationLog.info((Object)("Found rollback stack in locked state: " + stack.getBackingFiles()[0] + ". Not Rolling back."));
            } else {
                operationLog.info((Object)("Found dead rollback stack: " + stack.getBackingFiles()[0] + ". Rolling back."));
                try {
                    stack.rollbackAll();
                }
                catch (Throwable ex) {
                    operationLog.error((Object)"Encountered error rolling back transaction:", ex);
                }
                stack.discard();
            }
            ++n2;
        }
    }

    private static RollbackStack createNewRollbackStack(File rollBackStackParentFolder) {
        String fileNamePrefix = String.valueOf(DateFormatUtils.format((Date)new Date(), (String)ROLLBACK_STACK_FILE_NAME_DATE_FORMAT_PATTERN)) + "-" + new Random().nextInt(10000) + "-";
        return new RollbackStack(new File(rollBackStackParentFolder, String.valueOf(fileNamePrefix) + ROLLBACK_QUEUE1_FILE_NAME_SUFFIX), new File(rollBackStackParentFolder, String.valueOf(fileNamePrefix) + ROLLBACK_QUEUE2_FILE_NAME_SUFFIX), operationLog);
    }

    private static RollbackStack createExistingRollbackStack(File rollbackStackQueue1) {
        String rollbackStack1FileName = rollbackStackQueue1.getName();
        String rollbackStack2FileName = String.valueOf(rollbackStack1FileName.substring(0, rollbackStack1FileName.length() - ROLLBACK_QUEUE1_FILE_NAME_SUFFIX.length())) + ROLLBACK_QUEUE2_FILE_NAME_SUFFIX;
        return new RollbackStack(rollbackStackQueue1, new File(rollbackStackQueue1.getParentFile(), rollbackStack2FileName), operationLog);
    }

    public DataSetRegistrationTransaction(File rollBackStackParentFolder, File workingDirectory, File stagingDirectory, DataSetRegistrationService<T> registrationService, IDataSetRegistrationDetailsFactory<T> registrationDetailsFactory) {
        this(DataSetRegistrationTransaction.createNewRollbackStack(rollBackStackParentFolder), workingDirectory, stagingDirectory, registrationService, registrationDetailsFactory);
    }

    DataSetRegistrationTransaction(RollbackStack rollbackStack, File workingDirectory, File stagingDirectory, DataSetRegistrationService<T> registrationService, IDataSetRegistrationDetailsFactory<T> registrationDetailsFactory) {
        this.state = new AbstractTransactionState.LiveTransactionState<T>(this, rollbackStack, workingDirectory, stagingDirectory, registrationService, registrationDetailsFactory);
        this.registrationService = registrationService;
        this.openBisService = this.registrationService.getRegistratorContext().getGlobalState().getOpenBisService();
        this.registrationContext = new DataSetRegistrationContext(new DataSetRegistrationPersistentMap(), this.registrationService.getRegistratorContext().getGlobalState(), null);
    }

    @Override
    public String getUserId() {
        return this.getStateAsLiveState().getUserId();
    }

    @Override
    public void setUserId(String userIdOrNull) {
        this.getStateAsLiveState().setUserId(userIdOrNull);
    }

    @Override
    public IDataSet createNewDataSet() {
        return this.getStateAsLiveState().createNewDataSet();
    }

    @Override
    public IDataSet createNewDataSet(String dataSetType) {
        return this.getStateAsLiveState().createNewDataSet(dataSetType);
    }

    @Override
    public IDataSet createNewDataSet(String dataSetType, String dataSetCode) {
        return this.getStateAsLiveState().createNewDataSet(dataSetType, dataSetCode);
    }

    public IDataSet createNewDataSet(DataSetRegistrationDetails<T> registrationDetails) {
        return this.getStateAsLiveState().createNewDataSet(registrationDetails);
    }

    public IDataSet createNewDataSet(IDataSetRegistrationDetailsFactory<T> factory, String dataSetType) {
        return this.getStateAsLiveState().createNewDataSet(factory, dataSetType, null);
    }

    @Override
    public IDataSetImmutable getDataSet(String dataSetCode) {
        return this.getStateAsLiveState().getDataSet(dataSetCode);
    }

    @Override
    public IDataSetUpdatable getDataSetForUpdate(String dataSetCode) {
        return this.getStateAsLiveState().getDataSetForUpdate(dataSetCode);
    }

    @Override
    public IDataSetUpdatable makeDataSetMutable(IDataSetImmutable dataSet) {
        return this.getStateAsLiveState().makeDataSetMutable(dataSet);
    }

    @Override
    public ISampleImmutable getSample(String sampleIdentifierString) {
        SampleIdentifier sampleIdentifier = new SampleIdentifierFactory(sampleIdentifierString).createIdentifier();
        Sample sampleOrNull = this.openBisService.tryGetSampleWithExperiment(sampleIdentifier);
        return sampleOrNull == null ? null : new SampleImmutable(sampleOrNull);
    }

    @Override
    public ISample getSampleForUpdate(String sampleIdentifierString) {
        return this.getStateAsLiveState().getSampleForUpdate(sampleIdentifierString);
    }

    @Override
    public ISample makeSampleMutable(ISampleImmutable sample) {
        return this.getStateAsLiveState().makeSampleMutable(sample);
    }

    @Override
    public IExperimentUpdatable getExperimentForUpdate(String experimentIdentifierString) {
        return this.getStateAsLiveState().getExperimentForUpdate(experimentIdentifierString);
    }

    @Override
    public IExperimentUpdatable makeExperimentMutable(IExperimentImmutable experiment) {
        return this.getStateAsLiveState().makeExperimentMutable(experiment);
    }

    @Override
    public ISample createNewSample(String sampleIdentifierString, String sampleTypeCode) {
        return this.getStateAsLiveState().createNewSample(sampleIdentifierString, sampleTypeCode);
    }

    @Override
    public ISample createNewSampleWithGeneratedCode(String spaceCode, String sampleTypeCode) {
        return this.getStateAsLiveState().createNewSampleWithGeneratedCode(spaceCode, sampleTypeCode);
    }

    @Override
    public IExperimentImmutable getExperiment(String experimentIdentifierString) {
        ExperimentIdentifier experimentIdentifier = new ExperimentIdentifierFactory(experimentIdentifierString).createIdentifier();
        Experiment experimentOrNull = this.openBisService.tryGetExperiment(experimentIdentifier);
        return experimentOrNull == null ? null : new ExperimentImmutable(experimentOrNull);
    }

    @Override
    public IExperiment createNewExperiment(String experimentIdentifierString, String experimentTypeCode) {
        return this.getStateAsLiveState().createNewExperiment(experimentIdentifierString, experimentTypeCode);
    }

    @Override
    public IProject createNewProject(String projectIdentifier) {
        return this.getStateAsLiveState().createNewProject(projectIdentifier);
    }

    @Override
    public IProjectImmutable getProject(String projectIdentifierString) {
        ProjectIdentifier projectIdentifier = new ProjectIdentifierFactory(projectIdentifierString).createIdentifier();
        Project projectOrNull = this.openBisService.tryGetProject(projectIdentifier);
        return projectOrNull == null ? null : new ProjectImmutable(projectOrNull);
    }

    @Override
    public IProject getProjectForUpdate(String projectIdentifier) {
        return this.getStateAsLiveState().getProjectForUpdate(projectIdentifier);
    }

    @Override
    public IProject makeProjectMutable(IProjectImmutable project) {
        return this.getStateAsLiveState().makeProjectMutable(project);
    }

    @Override
    public ISpace createNewSpace(String spaceCode, String spaceAdminUserIdOrNull) {
        return this.getStateAsLiveState().createNewSpace(spaceCode, spaceAdminUserIdOrNull);
    }

    @Override
    public ISpaceImmutable getSpace(String spaceCode) {
        SpaceIdentifier spaceIdentifier = new SpaceIdentifier(spaceCode);
        Space spaceOrNull = this.openBisService.tryGetSpace(spaceIdentifier);
        return spaceOrNull == null ? null : new SpaceImmutable(spaceOrNull);
    }

    @Override
    public IMaterialImmutable getMaterial(String materialCode, String materialType) {
        MaterialIdentifier materialIdentifier = new MaterialIdentifier(materialCode, materialType);
        Material materialOrNull = this.openBisService.tryGetMaterial(materialIdentifier);
        return materialOrNull == null ? null : new MaterialImmutable(materialOrNull);
    }

    @Override
    public IMaterialImmutable getMaterial(String identifier) {
        MaterialIdentifier materialId = MaterialIdentifier.tryParseIdentifier(identifier);
        if (materialId == null) {
            throw new IllegalArgumentException("Incorrect material identifier format " + identifier + ". Expected code (type)");
        }
        return this.getMaterial(materialId.getCode(), materialId.getTypeCode());
    }

    @Override
    public IMaterial getMaterialForUpdate(String materialCode, String materialType) {
        return this.getStateAsLiveState().getMaterialForUpdate(materialCode, materialType);
    }

    @Override
    public IMaterial getMaterialForUpdate(String identifier) {
        MaterialIdentifier materialId = MaterialIdentifier.tryParseIdentifier(identifier);
        if (materialId == null) {
            throw new IllegalArgumentException("Incorrect material identifier format " + identifier + ". Expected code (type)");
        }
        return this.getMaterialForUpdate(materialId.getCode(), materialId.getTypeCode());
    }

    @Override
    public IMaterial makeMaterialMutable(IMaterialImmutable material) {
        return this.getStateAsLiveState().makeMaterialMutable(material);
    }

    @Override
    public IMaterial createNewMaterial(String materialCode, String materialType) {
        return this.getStateAsLiveState().createNewMaterial(materialCode, materialType);
    }

    @Override
    public IExternalDataManagementSystemImmutable getExternalDataManagementSystem(String externalDataManagementSystemCode) {
        ExternalDataManagementSystem result = this.openBisService.tryGetExternalDataManagementSystem(externalDataManagementSystemCode);
        return result == null ? null : new ExternalDataManagementSystemImmutable(result);
    }

    @Override
    public IMetaproject createNewMetaproject(String name, String description) {
        if (this.getUserId() == null) {
            throw new IllegalArgumentException("Cannot create a new metaproject when user is not available nor specified. ");
        }
        return this.getStateAsLiveState().createNewMetaproject(name, description, this.getUserId());
    }

    @Override
    public IMetaproject createNewMetaproject(String name, String description, String ownerId) {
        if (this.getUserId() != null && !this.getUserId().equals(ownerId)) {
            throw new IllegalArgumentException("Cannot create metaproject for different user then the current one.");
        }
        return this.getStateAsLiveState().createNewMetaproject(name, description, ownerId);
    }

    @Override
    public IMetaproject getMetaproject(String name) {
        if (this.getUserId() == null) {
            throw new IllegalArgumentException("Cannot get a metaproject when user is not available nor specified. ");
        }
        return this.getStateAsLiveState().getMetaproject(name, this.getUserId());
    }

    @Override
    public IMetaproject getMetaproject(String name, String ownerId) {
        if (this.getUserId() != null && !this.getUserId().equals(ownerId)) {
            throw new IllegalArgumentException("Cannot get metaproject for different user then the current one.");
        }
        return this.getStateAsLiveState().getMetaproject(name, ownerId);
    }

    @Override
    public IVocabularyImmutable getVocabulary(String code) {
        return this.getSearchService().getVocabulary(code);
    }

    @Override
    public IVocabulary getVocabularyForUpdate(String code) {
        return this.getStateAsLiveState().getVocabularyForUpdate(code);
    }

    @Override
    public IVocabularyTerm createNewVocabularyTerm() {
        return new VocabularyTerm();
    }

    @Override
    public String moveFile(String src, IDataSet dst) {
        return this.getStateAsLiveState().moveFile(src, dst);
    }

    @Override
    public String moveFile(String src, IDataSet dst, String dstInDataset) {
        return this.getStateAsLiveState().moveFile(src, dst, dstInDataset);
    }

    @Override
    public String createNewDirectory(IDataSet dst, String dirName) {
        return this.getStateAsLiveState().createNewDirectory(dst, dirName);
    }

    @Override
    public String createNewFile(IDataSet dst, String fileName) {
        return this.getStateAsLiveState().createNewFile(dst, fileName);
    }

    @Override
    public String createNewFile(IDataSet dst, String dstInDataset, String fileName) {
        return this.getStateAsLiveState().createNewFile(dst, dstInDataset, fileName);
    }

    public void deleteFile(String src) {
        this.getStateAsLiveState().deleteFile(src);
    }

    @Override
    public DataSetRegistrationContext getRegistrationContext() {
        return this.registrationContext;
    }

    public boolean commit() {
        if (this.state.isCommitted()) {
            return false;
        }
        AbstractTransactionState.LiveTransactionState<T> liveState = this.getStateAsLiveState();
        boolean commitSucceeded = liveState.commit();
        if (this.state.isRolledback()) {
            return false;
        }
        this.state = new AbstractTransactionState.CommitedTransactionState<T>(liveState);
        this.invokeDidCommitTransaction();
        if (commitSucceeded) {
            operationLog.info((Object)SUCCESS_MESSAGE);
        }
        return commitSucceeded;
    }

    private void invokeDidCommitTransaction() {
        try {
            this.registrationService.executePostCommit(this);
        }
        catch (Throwable t) {
            DssRegistrationLogger dssRegistrationLog = this.registrationService.getDssRegistrationLog();
            dssRegistrationLog.warn(operationLog, "Failed to invoke post transaction hook:" + t.getMessage(), t);
        }
    }

    public void rollback() {
        if (this.state.isRolledback()) {
            return;
        }
        AbstractTransactionState.LiveTransactionState<T> liveState = this.getStateAsLiveState();
        liveState.rollback();
        this.state = new AbstractTransactionState.RolledbackTransactionState<T>(liveState);
    }

    @Override
    public void didRollbackStorageAlgorithmRunner(DataSetStorageAlgorithmRunner<T> algorithm, Throwable ex, IDataSetOnErrorActionDecision.ErrorType errorType) {
        if (!(ex instanceof IncomingFileDeletedBeforeRegistrationException)) {
            operationLog.error((Object)"The error ", ex);
        }
        this.rollback();
        this.registrationService.didRollbackTransaction(this, algorithm, ex, errorType);
    }

    @Override
    public void registerDataSetsInApplicationServer(TechId registrationId, List<DataSetRegistrationInformation<T>> dataSetRegistrations) throws Throwable {
        AtomicEntityOperationDetails<T> registrationDetails = this.getStateAsLiveState().createEntityOperationDetails(registrationId, dataSetRegistrations);
        IEntityOperationService<T> entityRegistrationService = this.registrationService.getEntityRegistrationService();
        this.verifyOriginalFileIsStillAvailable();
        entityRegistrationService.performOperationsInApplicationServer(registrationDetails);
    }

    private void verifyOriginalFileIsStillAvailable() {
        if (!this.registrationService.shouldUsePrestaging()) {
            return;
        }
        File realIncomingFile = this.getIncomingDataSetFile().getRealIncomingFile();
        if (realIncomingFile.exists()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Incoming file [");
        sb.append(realIncomingFile.getAbsolutePath());
        sb.append("] ");
        sb.append(" was deleted before registration.");
        throw new IncomingFileDeletedBeforeRegistrationException(sb.toString());
    }

    @Override
    public EntityOperationsState didEntityOperationsSucceeded(TechId registrationId) {
        return this.openBisService.didEntityOperationsSucceed(registrationId);
    }

    public boolean isCommittedOrRolledback() {
        return this.isCommitted() || this.isRolledback();
    }

    public boolean isCommitted() {
        return this.state.isCommitted();
    }

    public boolean isRolledback() {
        return this.state.isRolledback();
    }

    public void logInfo(Object message) {
        operationLog.info(message);
    }

    private AbstractTransactionState.LiveTransactionState<T> getStateAsLiveState() {
        try {
            AbstractTransactionState.LiveTransactionState liveState = (AbstractTransactionState.LiveTransactionState)this.state;
            return liveState;
        }
        catch (ClassCastException ex) {
            String message = this.state instanceof AbstractTransactionState.CommitedTransactionState ? "The transaction has already been committed" : "The transaction has already been rolledback";
            throw new EnvironmentFailureException(message, ex);
        }
    }

    @Override
    public ISearchService getSearchService() {
        if (this.getUserId() == null) {
            return this.getSearchServiceUnfiltered();
        }
        return new SearchService(this.openBisService.getBasicFilteredOpenBISService(this.getStateAsLiveState().getUserId()));
    }

    @Override
    public ISearchService getSearchServiceUnfiltered() {
        return new SearchService(this.openBisService);
    }

    @Override
    public ISearchService getSearchServiceFilteredForUser(String userId) {
        return new SearchService(this.openBisService.getBasicFilteredOpenBISService(userId));
    }

    @Override
    public IAuthorizationService getAuthorizationService() {
        return new AuthorizationService(this.openBisService);
    }

    @Override
    public DynamicTransactionQuery getDatabaseQuery(String dataSourceName) throws IllegalArgumentException {
        return this.getStateAsLiveState().getDatabaseQuery(dataSourceName);
    }

    void invokeDidEncounterSecondaryTransactionErrors(List<SecondaryTransactionFailure> encounteredErrors) {
        try {
            this.registrationService.didEncounterSecondaryTransactionErrors(this, encounteredErrors);
        }
        catch (Throwable t) {
            operationLog.warn((Object)("Failed to invoke secondary transaction error hook:" + t.getMessage()), t);
        }
    }

    @Override
    public AbstractOmniscientTopLevelDataSetRegistrator.OmniscientTopLevelDataSetRegistratorState getRegistratorContext() {
        return this.registrationService.getRegistratorContext();
    }

    public DataSetFile getIncomingDataSetFile() {
        return this.registrationService.getIncomingDataSetFile();
    }

    @Override
    public File getIncoming() {
        return this.getIncomingDataSetFile().getLogicalIncomingFile();
    }

    @Override
    public TopLevelDataSetRegistratorGlobalState getGlobalState() {
        return this.getRegistratorContext().getGlobalState();
    }
}

