/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.recovery;

import ch.systemsx.cisd.common.filesystem.FileUtilities;
import java.io.File;
import java.io.Serializable;
import java.util.Date;

public class DataSetStorageRecoveryInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final File recoveryStateFile;
    private Date lastTry;
    private int tryCount;
    private RecoveryStage recoveryStage;

    public DataSetStorageRecoveryInfo(File recoveryStateFile, Date lastTry, int tryCount, RecoveryStage recoveryStage) {
        this.recoveryStateFile = recoveryStateFile;
        this.lastTry = lastTry;
        this.tryCount = tryCount;
        this.recoveryStage = recoveryStage;
    }

    public void increaseTryCount() {
        ++this.tryCount;
    }

    public void setLastTry(Date lastTry) {
        this.lastTry = lastTry;
    }

    public File getRecoveryStateFile() {
        return this.recoveryStateFile;
    }

    public Date getLastTry() {
        return this.lastTry;
    }

    public int getTryCount() {
        return this.tryCount;
    }

    public RecoveryStage getRecoveryStage() {
        return this.recoveryStage;
    }

    public void writeToFile(File informationFile) {
        FileUtilities.writeToFile(informationFile, this);
    }

    public static DataSetStorageRecoveryInfo loadFromFile(File informationFile) {
        return FileUtilities.loadToObject(informationFile, DataSetStorageRecoveryInfo.class);
    }

    public static enum RecoveryStage {
        PRECOMMIT("Precommit"),
        POST_REGISTRATION_HOOK_EXECUTED("After post-registration"),
        STORAGE_COMPLETED("Storage completed");

        private String description;

        private RecoveryStage(String description) {
            this.description = description;
        }

        public boolean beforeOrEqual(RecoveryStage other) {
            return this.ordinal() <= other.ordinal();
        }

        public boolean before(RecoveryStage other) {
            return this.ordinal() < other.ordinal();
        }

        public String toString() {
            return this.description;
        }
    }
}

