/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared;

import ch.systemsx.cisd.openbis.dss.generic.shared.AbstractShareFinder;
import ch.systemsx.cisd.openbis.dss.generic.shared.ISpeedChecker;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.Share;
import ch.systemsx.cisd.openbis.generic.shared.dto.SimpleDataSetInformationDTO;
import java.util.List;
import java.util.Properties;

public class SimpleShareFinder
extends AbstractShareFinder {
    public SimpleShareFinder(Properties properties) {
    }

    @Override
    protected Share tryToFindShare(SimpleDataSetInformationDTO dataSet, List<Share> shares, ISpeedChecker speedChecker) {
        long dataSetSize = dataSet.getDataSetSize();
        String dataSetShareId = dataSet.getDataSetShareId();
        long dataSetShareFreeSpace = 0L;
        boolean dataSetShareIncoming = false;
        Share incomingShareWithMostFree = null;
        long incomingMaxFreeSpace = dataSetSize += Math.max(1024L, Math.min(0x100000L, dataSet.getDataSetSize() / 10L));
        Share extensionShareWithMostFree = null;
        long extensionsMaxFreeSpace = dataSetSize;
        for (Share share : shares) {
            if (!speedChecker.check(dataSet, share)) continue;
            long freeSpace = share.calculateFreeSpace();
            String shareId = share.getShareId();
            if (dataSetShareId != null && dataSetShareId.equals(shareId)) {
                dataSetShareFreeSpace = freeSpace;
                dataSetShareIncoming = share.isIncoming();
                continue;
            }
            if (share.isIncoming()) {
                if (freeSpace <= incomingMaxFreeSpace) continue;
                incomingMaxFreeSpace = freeSpace;
                incomingShareWithMostFree = share;
                continue;
            }
            if (freeSpace <= extensionsMaxFreeSpace) continue;
            extensionsMaxFreeSpace = freeSpace;
            extensionShareWithMostFree = share;
        }
        if (extensionShareWithMostFree != null) {
            if (dataSetShareIncoming || extensionsMaxFreeSpace - dataSetSize > dataSetShareFreeSpace) {
                return extensionShareWithMostFree;
            }
        } else if (!(incomingShareWithMostFree == null || dataSetShareIncoming && incomingMaxFreeSpace - dataSetSize <= dataSetShareFreeSpace)) {
            return incomingShareWithMostFree;
        }
        return null;
    }
}

