/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.model;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.ModelDataPropertyNames;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.SimplifiedBaseModelData;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.columns.framework.IColumnDefinitionUI;
import ch.systemsx.cisd.openbis.generic.shared.basic.GridRowModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.IColumnDefinition;
import ch.systemsx.cisd.openbis.generic.shared.basic.PrimitiveValue;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BaseEntityModel<T>
extends SimplifiedBaseModelData {
    private static final long serialVersionUID = 1L;
    private boolean outdated = false;
    private final Set<String> outdatable = new HashSet<String>();

    public BaseEntityModel(GridRowModel<T> entity, List<? extends IColumnDefinition<T>> columnDefinitions) {
        this.set("object", entity.getOriginalObject());
        for (IColumnDefinition<T> column : columnDefinitions) {
            String value = column.getValue(entity);
            this.set(column.getIdentifier(), value);
            if (!(column instanceof IColumnDefinitionUI)) continue;
            this.set(ModelDataPropertyNames.link(column.getIdentifier()), ((IColumnDefinitionUI)column).tryGetLink(entity.getOriginalObject()));
            if (!((IColumnDefinitionUI)column).isDynamicProperty()) continue;
            this.outdatable.add(column.getIdentifier());
        }
        this.addCustomColumns(entity);
    }

    private void addCustomColumns(GridRowModel<T> model) {
        for (Map.Entry<String, PrimitiveValue> entry : model.getCalculatedColumnValues().entrySet()) {
            this.set(entry.getKey(), entry.getValue());
            this.outdatable.add(entry.getKey());
        }
    }

    public final T getBaseObject() {
        return (T)this.get("object");
    }

    public final String tryGetLink(String columnId) {
        return (String)this.get(ModelDataPropertyNames.link(columnId));
    }

    public boolean isOutdated() {
        return this.outdated;
    }

    public void setOutdated(boolean outdated) {
        this.outdated = outdated;
    }

    public boolean isOutdatable(String columnName) {
        return this.outdatable.contains(columnName);
    }
}

