/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo.materiallister;

import ch.rinn.restrictions.Friend;
import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.AbstractDAO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.GenericEntityPropertyRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.IEntityPropertySetListingQuery;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.MaterialEntityPropertyRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.VocabularyTermRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.materiallister.IMaterialListingQuery;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.lemnik.eodsql.QueryTool;

@Friend(toClasses={IMaterialListingQuery.class})
public final class MaterialListerDAO
extends AbstractDAO {
    private final IMaterialListingQuery query;
    private final IEntityPropertySetListingQuery propertySetQuery;

    public static MaterialListerDAO create(IDAOFactory daoFactory) {
        IMaterialListingQuery query = (IMaterialListingQuery)QueryTool.getManagedQuery(IMaterialListingQuery.class);
        return MaterialListerDAO.create(daoFactory, query);
    }

    @Private
    static MaterialListerDAO create(IDAOFactory daoFactory, IMaterialListingQuery query) {
        DatabaseInstancePE homeDatabaseInstance = daoFactory.getHomeDatabaseInstance();
        return new MaterialListerDAO(query, homeDatabaseInstance);
    }

    MaterialListerDAO(IMaterialListingQuery query, DatabaseInstancePE databaseInstance) {
        super(databaseInstance);
        this.query = query;
        this.propertySetQuery = MaterialListerDAO.asEntityPropertySetListingQuery(query);
    }

    IMaterialListingQuery getQuery() {
        return this.query;
    }

    IEntityPropertySetListingQuery getPropertySetQuery() {
        return this.propertySetQuery;
    }

    private static IEntityPropertySetListingQuery asEntityPropertySetListingQuery(final IMaterialListingQuery query) {
        return new IEntityPropertySetListingQuery(){

            @Override
            public Iterable<GenericEntityPropertyRecord> getEntityPropertyGenericValues(LongSet entityIDs) {
                return query.getEntityPropertyGenericValues(entityIDs);
            }

            @Override
            public Iterable<MaterialEntityPropertyRecord> getEntityPropertyMaterialValues(LongSet entityIDs) {
                return query.getEntityPropertyMaterialValues(entityIDs);
            }

            @Override
            public Iterable<VocabularyTermRecord> getEntityPropertyVocabularyTermValues(LongSet entityIDs) {
                return query.getEntityPropertyVocabularyTermValues(entityIDs);
            }
        };
    }
}

