/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.MethodUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IPersonDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractGenericEntityDAO;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.LockMode;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.criterion.Restrictions;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.orm.hibernate3.HibernateTemplate;

public final class PersonDAO
extends AbstractGenericEntityDAO<PersonPE>
implements IPersonDAO {
    private static final Class<PersonPE> ENTITY_CLASS = PersonPE.class;
    private static final String TABLE_NAME = ENTITY_CLASS.getSimpleName();
    public static final String ACTIVE_PERSONS_QUERY = "select count(*) from (                                                           select distinct p.user_id from persons p                           where p.is_active = true                                         union                                                                select distinct p.user_id from persons p                             left join role_assignments ra on ra.pers_id_grantee=p.id         where ra.role_code != 'ETL_SERVER'                               union                                                                select distinct p.user_id from persons p                             left join authorization_group_persons agp on agp.pers_id=p.id      left join authorization_groups ag on ag.id=agp.ag_id               left join role_assignments ra on ra.ag_id_grantee=ag.id          where ra.role_code != 'ETL_SERVER'                             ) as active_users                                                  ";
    public static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, PersonDAO.class);

    PersonDAO(SessionFactory sessionFactory, DatabaseInstancePE databaseInstance) {
        super(sessionFactory, databaseInstance, ENTITY_CLASS);
    }

    @Override
    public final void createPerson(PersonPE person) throws DataAccessException {
        assert (person != null) : "Given person can not be null.";
        if (person.getDatabaseInstance() == null) {
            person.setDatabaseInstance(this.getDatabaseInstance());
        }
        person.setEmail(StringUtils.trim((String)person.getEmail()));
        person.setActive(true);
        PersonDAO.validatePE(person);
        HibernateTemplate template = this.getHibernateTemplate();
        template.save((Object)person);
        template.flush();
        if (person.getPersonDisplaySettings() != null) {
            person.getPersonDisplaySettings().setId(person.getId());
            template.update((Object)person.getPersonDisplaySettings());
            template.flush();
        }
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("ADD: person '%s'.", person));
        }
    }

    @Override
    public final void updatePerson(PersonPE person) throws DataAccessException {
        assert (person != null) : "Given person can not be null.";
        PersonDAO.validatePE(person);
        HibernateTemplate template = this.getHibernateTemplate();
        if (person.getPersonDisplaySettings() != null) {
            if (person.getPersonDisplaySettings().getId() == null) {
                person.getPersonDisplaySettings().setId(person.getId());
            }
            template.merge((Object)person.getPersonDisplaySettings());
        }
        template.merge((Object)person);
        template.flush();
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("UPDATE: person '%s'.", person));
        }
    }

    @Override
    public final PersonPE getPerson(long id) throws DataAccessException {
        PersonPE person = (PersonPE)this.getHibernateTemplate().load(ENTITY_CLASS, (Serializable)Long.valueOf(id));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)("getPerson(" + id + "): '" + person + "'."));
        }
        return person;
    }

    @Override
    public final PersonPE tryFindPersonByUserId(String userId) throws DataAccessException {
        assert (userId != null) : "Unspecified user id";
        List<PersonPE> persons = PersonDAO.cast(this.getHibernateTemplate().find(String.format("from %s p where lower(p.userId) = ? and p.databaseInstance = ?", TABLE_NAME), PersonDAO.toArray(userId.toLowerCase(), this.getDatabaseInstance())));
        PersonPE person = PersonDAO.tryFindPerson(persons, userId);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(%s): '%s'.", MethodUtils.getCurrentMethod().getName(), userId, person));
        }
        return person;
    }

    private static final PersonPE tryFindPerson(List<PersonPE> persons, String userId) throws IncorrectResultSizeDataAccessException {
        int size = persons.size();
        switch (size) {
            case 0: {
                return null;
            }
            case 1: {
                return persons.get(0);
            }
        }
        for (PersonPE p : persons) {
            if (!p.getUserId().equals(userId)) continue;
            return p;
        }
        throw new IncorrectResultSizeDataAccessException(String.format("%d persons found for user id '%s'. Expected: 1 or 0.", size, userId), 1, size);
    }

    @Override
    public final PersonPE tryFindPersonByEmail(String emailAddress) throws DataAccessException {
        assert (emailAddress != null) : "Unspecified email address";
        List persons = PersonDAO.cast(this.getHibernateTemplate().find(String.format("from %s p where p.email = ? and p.databaseInstance = ?", TABLE_NAME), PersonDAO.toArray(emailAddress, this.getDatabaseInstance())));
        int numberOfResults = persons.size();
        PersonPE person = numberOfResults > 0 ? (PersonPE)persons.get(0) : null;
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(%s): %d found, taking '%s'.", MethodUtils.getCurrentMethod().getName(), emailAddress, numberOfResults, person));
        }
        return person;
    }

    @Override
    public final List<PersonPE> listPersons() throws DataAccessException {
        List<PersonPE> list = PersonDAO.cast(this.getHibernateTemplate().find(String.format("from %s p where p.databaseInstance = ?", TABLE_NAME), PersonDAO.toArray(this.getDatabaseInstance())));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(): %d person(s) have been found.", MethodUtils.getCurrentMethod().getName(), list.size()));
        }
        return list;
    }

    @Override
    public final List<PersonPE> listActivePersons() throws DataAccessException {
        List<PersonPE> list = PersonDAO.cast(this.getHibernateTemplate().find(String.format("from %s p where p.databaseInstance = ? and p.active = true", TABLE_NAME), PersonDAO.toArray(this.getDatabaseInstance())));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(): %d person(s) have been found.", MethodUtils.getCurrentMethod().getName(), list.size()));
        }
        return list;
    }

    @Override
    public final int countActivePersons() throws DataAccessException {
        return ((BigInteger)this.executeStatelessAction(new AbstractDAO.StatelessHibernateCallback(){

            @Override
            public Object doInStatelessSession(StatelessSession session) {
                return session.createSQLQuery(PersonDAO.ACTIVE_PERSONS_QUERY).uniqueResult();
            }
        })).intValue();
    }

    @Override
    public final List<PersonPE> listByCodes(Collection<String> userIds) throws DataAccessException {
        if (userIds.size() == 0) {
            return new ArrayList<PersonPE>();
        }
        Criteria criteria = this.getSession().createCriteria(PersonPE.class);
        criteria.add(Restrictions.in((String)"userId", userIds));
        return PersonDAO.cast(criteria.list());
    }

    @Override
    public void lock(PersonPE person) {
        PersonPE mergedPerson = (PersonPE)this.getHibernateTemplate().merge((Object)person);
        this.getHibernateTemplate().lock((Object)mergedPerson, LockMode.PESSIMISTIC_WRITE);
    }
}

