/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic;

public final class CodeConverter {
    private CodeConverter() {
    }

    public static String tryToBusinessLayer(String codeFromDatabaseOrNull, boolean internalNamespace) {
        if (internalNamespace && codeFromDatabaseOrNull != null) {
            return "$" + codeFromDatabaseOrNull;
        }
        return codeFromDatabaseOrNull;
    }

    public static String tryToDatabase(String codeFromBusinessLayerOrNull) {
        if (codeFromBusinessLayerOrNull == null) {
            return null;
        }
        String upperCaseCode = codeFromBusinessLayerOrNull.toUpperCase();
        if (upperCaseCode.startsWith("$")) {
            return upperCaseCode.substring("$".length());
        }
        return upperCaseCode;
    }

    public static boolean isInternalNamespace(String codeFromBusinessLayerOrNull) {
        if (codeFromBusinessLayerOrNull == null) {
            return false;
        }
        return codeFromBusinessLayerOrNull.toUpperCase().startsWith("$");
    }

    public static String getPropertyTypeCode(String propertyColumnName) {
        if (propertyColumnName.startsWith("USER-")) {
            return CodeConverter.tryToBusinessLayer(propertyColumnName.substring("USER-".length()), false);
        }
        if (propertyColumnName.startsWith("INTERN-")) {
            return CodeConverter.tryToBusinessLayer(propertyColumnName.substring("INTERN-".length()), true);
        }
        return propertyColumnName;
    }
}

