/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.server;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.servlet.IRequestContextProvider;
import ch.systemsx.cisd.openbis.common.spring.IUncheckedMultipartFile;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DataSetUpdates;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.SampleUpdates;
import ch.systemsx.cisd.openbis.generic.client.web.server.AbstractClientService;
import ch.systemsx.cisd.openbis.generic.client.web.server.AttachmentRegistrationHelper;
import ch.systemsx.cisd.openbis.generic.client.web.server.UploadedFilesBean;
import ch.systemsx.cisd.openbis.generic.client.web.server.translator.UserFailureExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.exception.SampleUniqueCodeViolationExceptionAbstract;
import ch.systemsx.cisd.openbis.generic.shared.IServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AsyncBatchRegistrationResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BatchOperationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BatchRegistrationResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetUpdateResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentUpdateResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialBatchUpdateResultMessage;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewAttachment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewDataSetsWithTypes;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewEntitiesWithTypes;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewExperiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewExperimentsWithType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewMaterialsWithTypes;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleParentWithDerived;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleUpdateResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.UpdatedExperimentsWithType;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.parser.NamedInputStream;
import ch.systemsx.cisd.openbis.generic.shared.parser.SampleUploadSectionsParser;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.IGenericClientService;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.server.DataSetLoader;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.server.ExperimentLoader;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.server.UpdatedExperimentLoader;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.server.parser.MaterialUploadSectionsParser;
import ch.systemsx.cisd.openbis.plugin.generic.shared.IGenericServer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

@Component(value="generic-plugin-service")
public class GenericClientService
extends AbstractClientService
implements IGenericClientService {
    @Resource(name="generic-plugin-server")
    private IGenericServer genericServer;

    public GenericClientService() {
    }

    @Private
    protected GenericClientService(IGenericServer genericServer, IRequestContextProvider requestContextProvider) {
        super(requestContextProvider);
        this.genericServer = genericServer;
    }

    @Override
    protected final IServer getServer() {
        return this.genericServer;
    }

    @Override
    public final SampleParentWithDerived getSampleGenerationInfo(TechId sampleId) {
        try {
            String sessionToken = this.getSessionToken();
            SampleParentWithDerived sampleParentWithDerived = this.genericServer.getSampleInfo(sessionToken, sampleId);
            this.transformXML(sampleParentWithDerived.getParent());
            return sampleParentWithDerived;
        }
        catch (UserFailureException e) {
            throw UserFailureExceptionTranslator.translate(e);
        }
    }

    @Override
    public final Sample getSampleInfo(TechId sampleId) {
        return this.getSampleGenerationInfo(sampleId).getParent();
    }

    @Override
    public final void registerSample(String sessionKey, final NewSample newSample) {
        final String sessionToken = this.getSessionToken();
        new AttachmentRegistrationHelper(){

            @Override
            public void register(Collection<NewAttachment> attachments) {
                GenericClientService.this.genericServer.registerSample(sessionToken, newSample, attachments);
            }
        }.process(sessionKey, this.getHttpSession(), newSample.getAttachments());
    }

    @Override
    public final List<BatchRegistrationResult> registerSamples(SampleType sampleType, String sessionKey, String defaultGroupIdentifier, boolean updateExisting) {
        boolean isAutogenerateCodes = defaultGroupIdentifier != null;
        BatchOperationKind operationKind = updateExisting ? BatchOperationKind.UPDATE : BatchOperationKind.REGISTRATION;
        SampleUploadSectionsParser.BatchSamplesOperation info = this.parseSamples(sampleType, sessionKey, defaultGroupIdentifier, isAutogenerateCodes, true, null, operationKind);
        try {
            String sessionToken = this.getSessionToken();
            this.genericServer.registerOrUpdateSamples(sessionToken, info.getSamples());
            return info.getResultList();
        }
        catch (UserFailureException e) {
            if (e.getCause() instanceof SampleUniqueCodeViolationExceptionAbstract) {
                SampleUniqueCodeViolationExceptionAbstract codeException = (SampleUniqueCodeViolationExceptionAbstract)((Object)e.getCause());
                if (isAutogenerateCodes) {
                    throw new ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException(String.format("Import failed because the autogenerated codes are no longer unique. Somebody has created a sample (code: %s) that matched one of the autogenerated codes. Please run the import once again.", codeException.getSampleCode()));
                }
                throw new ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException(String.format("Import failed because sample (code: %s) already exists.", codeException.getSampleCode()));
            }
            throw UserFailureExceptionTranslator.translate(e);
        }
    }

    @Override
    public final List<BatchRegistrationResult> registerOrUpdateSamplesAndMaterials(String sessionKey, String defaultGroupIdentifier, boolean updateExisting, boolean async, String userEmail) throws ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException {
        BatchOperationKind operationKind = updateExisting ? BatchOperationKind.UPDATE : BatchOperationKind.REGISTRATION;
        SampleType sampleType = new SampleType();
        sampleType.setCode("(multiple)");
        HttpSession session = this.getHttpSession();
        UploadedFilesBean uploadedFiles = null;
        try {
            uploadedFiles = GenericClientService.getUploadedFiles(sessionKey, session);
            SampleUploadSectionsParser.BatchSamplesOperation samplesInfo = this.parseSamples(sampleType, session, uploadedFiles, defaultGroupIdentifier, defaultGroupIdentifier != null, true, "SAMPLES", operationKind);
            MaterialType materialType = new MaterialType();
            materialType.setCode("(multiple)");
            MaterialUploadSectionsParser.BatchMaterialsOperation materialsInfo = this.parseMaterials(session, uploadedFiles, materialType, "MATERIALS", updateExisting);
            String sessionToken = this.getSessionToken();
            if (async) {
                if (materialsInfo.getMaterials().isEmpty()) {
                    this.genericServer.registerOrUpdateSamplesAsync(sessionToken, samplesInfo.getSamples(), userEmail);
                } else {
                    this.genericServer.registerOrUpdateSamplesAndMaterialsAsync(sessionToken, samplesInfo.getSamples(), materialsInfo.getMaterials(), userEmail);
                }
                String fileName = uploadedFiles.iterable().iterator().next().getOriginalFilename();
                List<BatchRegistrationResult> list = AsyncBatchRegistrationResult.singletonList(fileName);
                return list;
            }
            if (materialsInfo.getMaterials().isEmpty()) {
                this.genericServer.registerOrUpdateSamples(sessionToken, samplesInfo.getSamples());
            } else {
                this.genericServer.registerOrUpdateSamplesAndMaterials(sessionToken, samplesInfo.getSamples(), materialsInfo.getMaterials());
            }
            ArrayList<BatchRegistrationResult> results = new ArrayList<BatchRegistrationResult>();
            results.addAll(materialsInfo.getResultList());
            results.addAll(samplesInfo.getResultList());
            ArrayList<BatchRegistrationResult> arrayList = results;
            return arrayList;
        }
        catch (UserFailureException e) {
            throw UserFailureExceptionTranslator.translate(e);
        }
        finally {
            GenericClientService.cleanUploadedFiles(sessionKey, session, uploadedFiles);
        }
    }

    @Override
    public final List<BatchRegistrationResult> updateSamples(SampleType sampleType, String sessionKey, String defaultGroupIdentifier) {
        SampleUploadSectionsParser.BatchSamplesOperation info = this.parseSamples(sampleType, sessionKey, defaultGroupIdentifier, false, true, null, BatchOperationKind.UPDATE);
        try {
            String sessionToken = this.getSessionToken();
            this.genericServer.updateSamples(sessionToken, info.getSamples());
            return info.getResultList();
        }
        catch (UserFailureException e) {
            throw UserFailureExceptionTranslator.translate(e);
        }
    }

    @Override
    public final AbstractExternalData getDataSetInfo(TechId datasetId) {
        try {
            String sessionToken = this.getSessionToken();
            AbstractExternalData dataset = this.genericServer.getDataSetInfo(sessionToken, datasetId);
            this.transformXML(dataset);
            return dataset;
        }
        catch (UserFailureException e) {
            throw UserFailureExceptionTranslator.translate(e);
        }
    }

    @Override
    public void registerExperiment(String attachmentsSessionKey, String samplesSessionKey, final NewExperiment experiment) {
        final String sessionToken = this.getSessionToken();
        if (experiment.isRegisterSamples()) {
            ExperimentIdentifier identifier = new ExperimentIdentifierFactory(experiment.getIdentifier()).createIdentifier();
            SampleUploadSectionsParser.BatchSamplesOperation result = this.parseSamples(experiment.getSampleType(), samplesSessionKey, new SpaceIdentifier(identifier.getDatabaseInstanceCode(), identifier.getSpaceCode()).toString(), experiment.isGenerateCodes(), false, null, BatchOperationKind.REGISTRATION);
            experiment.setNewSamples(result.getSamples());
            experiment.setSamples(result.getCodes());
        }
        new AttachmentRegistrationHelper(){

            @Override
            public void register(Collection<NewAttachment> attachments) {
                GenericClientService.this.genericServer.registerExperiment(sessionToken, experiment, attachments);
            }
        }.process(attachmentsSessionKey, this.getHttpSession(), experiment.getAttachments());
    }

    private SampleUploadSectionsParser.BatchSamplesOperation parseSamples(SampleType sampleType, HttpSession httpSession, UploadedFilesBean uploadedFiles, String defaultGroupIdentifier, boolean isAutoGenerateCodes, boolean allowExperiments, String excelSheetName, BatchOperationKind operationKind) {
        boolean updateExisting = operationKind == BatchOperationKind.UPDATE;
        SampleUploadSectionsParser.SampleCodeGenerator sampleCodeGeneratorOrNull = this.tryGetSampleCodeGenerator(isAutoGenerateCodes, sampleType.getGeneratedCodePrefix());
        ArrayList<NamedInputStream> files = new ArrayList<NamedInputStream>(uploadedFiles.size());
        for (IUncheckedMultipartFile f : uploadedFiles.iterable()) {
            files.add(new NamedInputStream(f.getInputStream(), f.getOriginalFilename()));
        }
        SampleUploadSectionsParser.BatchSamplesOperation batchSamplesOperation = SampleUploadSectionsParser.prepareSamples(sampleType, files, defaultGroupIdentifier, sampleCodeGeneratorOrNull, allowExperiments, excelSheetName, operationKind);
        GenericClientService.setUpdatePossibility(batchSamplesOperation.getSamples(), updateExisting);
        return batchSamplesOperation;
    }

    private SampleUploadSectionsParser.BatchSamplesOperation parseSamples(SampleType sampleType, String sessionKey, String defaultGroupIdentifier, boolean isAutoGenerateCodes, boolean allowExperiments, String excelSheetName, BatchOperationKind operationKind) {
        HttpSession httpSession = this.getHttpSession();
        UploadedFilesBean uploadedFiles = null;
        try {
            uploadedFiles = GenericClientService.getUploadedFiles(sessionKey, httpSession);
            SampleUploadSectionsParser.BatchSamplesOperation batchSamplesOperation = this.parseSamples(sampleType, httpSession, uploadedFiles, defaultGroupIdentifier, isAutoGenerateCodes, allowExperiments, excelSheetName, operationKind);
            return batchSamplesOperation;
        }
        finally {
            GenericClientService.cleanUploadedFiles(sessionKey, httpSession, uploadedFiles);
        }
    }

    private static void setUpdatePossibility(List<? extends NewEntitiesWithTypes<?, ?>> batchOperation, boolean updateExisting) {
        for (NewEntitiesWithTypes<?, ?> entitiesWithTypes : batchOperation) {
            entitiesWithTypes.setAllowUpdateIfExist(updateExisting);
        }
    }

    private SampleUploadSectionsParser.SampleCodeGenerator tryGetSampleCodeGenerator(boolean isAutoGenerateCodes, final String codePrefix) {
        if (isAutoGenerateCodes) {
            return new SampleUploadSectionsParser.SampleCodeGenerator(){

                @Override
                public List<String> generateCodes(int size) {
                    return GenericClientService.this.genericServer.generateCodes(GenericClientService.this.getSessionToken(), codePrefix, EntityKind.SAMPLE, size);
                }
            };
        }
        return null;
    }

    @Override
    public final List<BatchRegistrationResult> registerMaterials(MaterialType materialType, boolean updateExisting, String sessionKey, boolean async, String userEmail) {
        String sessionToken = this.getSessionToken();
        MaterialUploadSectionsParser.BatchMaterialsOperation results = this.parseMaterials(sessionKey, materialType, null, updateExisting);
        String fileName = results.getResultList().get(0).getFileName();
        List<NewMaterialsWithTypes> materials = results.getMaterials();
        if (async) {
            this.genericServer.registerOrUpdateMaterialsAsync(sessionToken, materials, userEmail);
            return AsyncBatchRegistrationResult.singletonList(fileName);
        }
        this.genericServer.registerOrUpdateMaterials(sessionToken, materials);
        return results.getResultList();
    }

    @Override
    public final List<BatchRegistrationResult> registerExperiments(ExperimentType experimentType, String sessionKey) {
        String sessionToken = this.getSessionToken();
        ExperimentLoader loader = this.parseExperiments(sessionKey);
        this.genericServer.registerExperiments(sessionToken, new NewExperimentsWithType(experimentType.getCode(), loader.getNewBasicExperiments()));
        return loader.getResults();
    }

    @Override
    public List<BatchRegistrationResult> updateMaterials(MaterialType materialType, String sessionKey, boolean ignoreUnregisteredMaterials, boolean async, String userEmail) {
        String sessionToken = this.getSessionToken();
        MaterialUploadSectionsParser.BatchMaterialsOperation results = this.parseMaterials(sessionKey, materialType, null, true);
        String fileName = results.getResultList().get(0).getFileName();
        if (async) {
            this.genericServer.updateMaterialsAsync(sessionToken, results.getMaterials(), ignoreUnregisteredMaterials, userEmail);
            return AsyncBatchRegistrationResult.singletonList(fileName);
        }
        int updateCount = this.genericServer.updateMaterials(sessionToken, results.getMaterials(), ignoreUnregisteredMaterials);
        MaterialBatchUpdateResultMessage message = new MaterialBatchUpdateResultMessage(results.getMaterials(), updateCount, ignoreUnregisteredMaterials);
        return Arrays.asList(new BatchRegistrationResult(fileName, message.toString()));
    }

    private ExperimentLoader parseExperiments(String sessionKey) {
        HttpSession session = this.getHttpSession();
        UploadedFilesBean uploadedFiles = null;
        try {
            uploadedFiles = GenericClientService.getUploadedFiles(sessionKey, session);
            ArrayList<NamedInputStream> files = new ArrayList<NamedInputStream>(uploadedFiles.size());
            for (IUncheckedMultipartFile f : uploadedFiles.iterable()) {
                files.add(new NamedInputStream(f.getInputStream(), f.getOriginalFilename()));
            }
            ExperimentLoader loader = new ExperimentLoader();
            loader.load(files);
            ExperimentLoader experimentLoader = loader;
            return experimentLoader;
        }
        finally {
            GenericClientService.cleanUploadedFiles(sessionKey, session, uploadedFiles);
        }
    }

    private MaterialUploadSectionsParser.BatchMaterialsOperation parseMaterials(HttpSession session, UploadedFilesBean uploadedFiles, MaterialType materialType, String excelSheetName, boolean updateExisting) {
        ArrayList<NamedInputStream> files = new ArrayList<NamedInputStream>(uploadedFiles.size());
        for (IUncheckedMultipartFile f : uploadedFiles.iterable()) {
            files.add(new NamedInputStream(f.getInputStream(), f.getOriginalFilename()));
        }
        MaterialUploadSectionsParser.BatchMaterialsOperation batchMaterialsOperation = MaterialUploadSectionsParser.prepareMaterials(materialType, files, excelSheetName);
        GenericClientService.setUpdatePossibility(batchMaterialsOperation.getMaterials(), updateExisting);
        return batchMaterialsOperation;
    }

    private MaterialUploadSectionsParser.BatchMaterialsOperation parseMaterials(String sessionKey, MaterialType materialType, String excelSheetName, boolean updateExisting) {
        HttpSession session = this.getHttpSession();
        UploadedFilesBean uploadedFiles = null;
        try {
            uploadedFiles = GenericClientService.getUploadedFiles(sessionKey, session);
            MaterialUploadSectionsParser.BatchMaterialsOperation batchMaterialsOperation = this.parseMaterials(session, uploadedFiles, materialType, excelSheetName, updateExisting);
            return batchMaterialsOperation;
        }
        finally {
            GenericClientService.cleanUploadedFiles(sessionKey, session, uploadedFiles);
        }
    }

    @Override
    public SampleUpdateResult updateSample(final SampleUpdates updates) {
        final String sessionToken = this.getSessionToken();
        final SampleUpdateResult result = new SampleUpdateResult();
        new AttachmentRegistrationHelper(){

            @Override
            public void register(Collection<NewAttachment> attachments) {
                ExperimentIdentifier convExperimentIdentifierOrNull = null;
                SampleIdentifier sampleOwner = null;
                if (updates.getExperimentIdentifierOrNull() != null) {
                    convExperimentIdentifierOrNull = new ExperimentIdentifierFactory(updates.getExperimentIdentifierOrNull().getIdentifier()).createIdentifier();
                }
                if (!StringUtils.isBlank((String)updates.getSampleIdentifier())) {
                    sampleOwner = new SampleIdentifierFactory(updates.getSampleIdentifier()).createIdentifier();
                }
                SampleUpdatesDTO updatesDTO = new SampleUpdatesDTO(updates.getSampleIdOrNull(), updates.getProperties(), convExperimentIdentifierOrNull, attachments, updates.getVersion(), sampleOwner, updates.getContainerIdentifierOrNull(), updates.getModifiedParentCodesOrNull());
                updatesDTO.setMetaprojectsOrNull(updates.getMetaprojectsOrNull());
                SampleUpdateResult updateResult = GenericClientService.this.genericServer.updateSample(sessionToken, updatesDTO);
                result.copyFrom(updateResult);
            }
        }.process(updates.getSessionKey(), this.getHttpSession(), updates.getAttachments());
        return result;
    }

    @Override
    public Date updateMaterial(TechId materialId, List<IEntityProperty> properties, String[] metaprojects, Date version) {
        try {
            String sessionToken = this.getSessionToken();
            return this.genericServer.updateMaterial(sessionToken, materialId, properties, metaprojects, version);
        }
        catch (UserFailureException e) {
            throw UserFailureExceptionTranslator.translate(e);
        }
    }

    @Override
    public ExperimentUpdateResult updateExperiment(final ExperimentUpdates updates) {
        final String sessionToken = this.getSessionToken();
        final ExperimentUpdateResult result = new ExperimentUpdateResult();
        if (updates.isRegisterSamples()) {
            ProjectIdentifier newProject = new ProjectIdentifierFactory(updates.getProjectIdentifier()).createIdentifier();
            SampleUploadSectionsParser.BatchSamplesOperation info = this.parseSamples(updates.getSampleType(), updates.getSamplesSessionKey(), new SpaceIdentifier(newProject.getDatabaseInstanceCode(), newProject.getSpaceCode()).toString(), updates.isGenerateCodes(), false, null, BatchOperationKind.REGISTRATION);
            updates.setNewSamples(info.getSamples());
            updates.setSampleCodes(info.getCodes());
        }
        new AttachmentRegistrationHelper(){

            @Override
            public void register(Collection<NewAttachment> attachments) {
                ExperimentUpdatesDTO updatesDTO = GenericClientService.createExperimentUpdatesDTO(updates, attachments);
                ExperimentUpdateResult updateResult = GenericClientService.this.genericServer.updateExperiment(sessionToken, updatesDTO);
                result.copyFrom(updateResult);
            }
        }.process(updates.getAttachmentSessionKey(), this.getHttpSession(), updates.getAttachments());
        return result;
    }

    private static ExperimentUpdatesDTO createExperimentUpdatesDTO(ExperimentUpdates updates, Collection<NewAttachment> attachments) {
        ExperimentUpdatesDTO updatesDTO = new ExperimentUpdatesDTO();
        updatesDTO.setExperimentId(updates.getExperimentId());
        ProjectIdentifier project = new ProjectIdentifierFactory(updates.getProjectIdentifier()).createIdentifier();
        updatesDTO.setProjectIdentifier(project);
        updatesDTO.setAttachments(attachments);
        updatesDTO.setProperties(updates.getProperties());
        updatesDTO.setSampleCodes(updates.getSampleCodes());
        updatesDTO.setVersion(updates.getVersion());
        updatesDTO.setRegisterSamples(updates.isRegisterSamples());
        updatesDTO.setNewSamples(updates.getNewSamples());
        updatesDTO.setSampleType(updates.getSampleType());
        updatesDTO.setMetaprojectsOrNull(updates.getMetaprojectsOrNull());
        return updatesDTO;
    }

    @Override
    public DataSetUpdateResult updateDataSet(DataSetUpdates updates) {
        String sessionToken = this.getSessionToken();
        return this.genericServer.updateDataSet(sessionToken, GenericClientService.createDataSetUpdatesDTO(updates));
    }

    private static DataSetUpdatesDTO createDataSetUpdatesDTO(DataSetUpdates updates) {
        DataSetUpdatesDTO updatesDTO = new DataSetUpdatesDTO();
        updatesDTO.setDatasetId(updates.getDatasetId());
        updatesDTO.setProperties(updates.getProperties());
        updatesDTO.setVersion(updates.getVersion());
        updatesDTO.setModifiedParentDatasetCodesOrNull(updates.getModifiedParentDatasetCodesOrNull());
        updatesDTO.setModifiedContainedDatasetCodesOrNull(updates.getModifiedContainedDatasetCodesOrNull());
        String sampleIdentifierOrNull = updates.getSampleIdentifierOrNull();
        updatesDTO.setSampleIdentifierOrNull(sampleIdentifierOrNull == null ? null : SampleIdentifierFactory.parse(sampleIdentifierOrNull));
        String experimentIdentifierOrNull = updates.getExperimentIdentifierOrNull();
        updatesDTO.setExperimentIdentifierOrNull(experimentIdentifierOrNull == null ? null : new ExperimentIdentifierFactory(experimentIdentifierOrNull).createIdentifier());
        updatesDTO.setFileFormatTypeCode(updates.getFileFormatTypeCode());
        updatesDTO.setExternalCode(updates.getExternalCode());
        updatesDTO.setExternalDataManagementSystemCode(updates.getExternalDataManagementSystemCode());
        updatesDTO.setMetaprojectsOrNull(updates.getMetaprojectsOrNull());
        return updatesDTO;
    }

    @Override
    public List<BatchRegistrationResult> updateDataSets(DataSetType dataSetType, String sessionKey) {
        HttpSession session = this.getHttpSession();
        UploadedFilesBean uploadedFiles = null;
        try {
            uploadedFiles = GenericClientService.getUploadedFiles(sessionKey, session);
            ArrayList<NamedInputStream> files = new ArrayList<NamedInputStream>(uploadedFiles.size());
            for (IUncheckedMultipartFile f : uploadedFiles.iterable()) {
                files.add(new NamedInputStream(f.getInputStream(), f.getOriginalFilename()));
            }
            DataSetLoader loader = new DataSetLoader();
            loader.load(files);
            this.genericServer.updateDataSets(this.getSessionToken(), new NewDataSetsWithTypes(dataSetType, loader.getNewDataSets()));
            List<BatchRegistrationResult> list = loader.getResults();
            return list;
        }
        finally {
            GenericClientService.cleanUploadedFiles(sessionKey, session, uploadedFiles);
        }
    }

    @Override
    public List<BatchRegistrationResult> updateExperiments(ExperimentType experimentType, String sessionKey) throws ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException {
        HttpSession session = this.getHttpSession();
        UploadedFilesBean uploadedFiles = null;
        try {
            uploadedFiles = GenericClientService.getUploadedFiles(sessionKey, session);
            ArrayList<NamedInputStream> files = new ArrayList<NamedInputStream>(uploadedFiles.size());
            for (IUncheckedMultipartFile f : uploadedFiles.iterable()) {
                files.add(new NamedInputStream(f.getInputStream(), f.getOriginalFilename()));
            }
            UpdatedExperimentLoader loader = new UpdatedExperimentLoader();
            loader.load(files);
            this.genericServer.updateExperiments(this.getSessionToken(), new UpdatedExperimentsWithType(experimentType, loader.getNewBasicExperiments()));
            List<BatchRegistrationResult> list = loader.getResults();
            return list;
        }
        finally {
            GenericClientService.cleanUploadedFiles(sessionKey, session, uploadedFiles);
        }
    }

    @Override
    public Map<String, Object> uploadedSamplesInfo(SampleType sampleType, String sessionKey) {
        HashMap<String, Object> info;
        block3: {
            HttpSession httpSession = this.getHttpSession();
            UploadedFilesBean uploadedFiles = (UploadedFilesBean)httpSession.getAttribute(sessionKey);
            ArrayList<NamedInputStream> files = new ArrayList<NamedInputStream>(uploadedFiles.size());
            for (IUncheckedMultipartFile f : uploadedFiles.iterable()) {
                files.add(new NamedInputStream(f.getInputStream(), f.getOriginalFilename()));
            }
            info = new HashMap<String, Object>();
            try {
                SampleUploadSectionsParser.prepareSamples(sampleType, files, null, null, true, null, BatchOperationKind.REGISTRATION);
                info.put("identifiersPressent", Boolean.TRUE);
            }
            catch (Exception ex) {
                if (!ex.getMessage().contains("Mandatory column 'identifier' is missing.")) break block3;
                info.put("identifiersPressent", Boolean.FALSE);
            }
        }
        return info;
    }
}

