/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.logicalimage;

import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.LazyImageSeriesFrame;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.List;

class LogicalImageSeriesDownloader {
    private List<LazyImageSeriesFrame> frames;
    private int selectedFrameIndex = 0;
    private int shownFrameIndex = 0;

    LogicalImageSeriesDownloader(List<LazyImageSeriesFrame> frames, LazyImageSeriesFrame.ImagesDownloadListener imagesDownloadListener) {
        this.frames = frames;
        this.downloadFirstFrame(imagesDownloadListener);
    }

    private void downloadFirstFrame(LazyImageSeriesFrame.ImagesDownloadListener listener) {
        if (this.frames.isEmpty()) {
            if (listener != null) {
                listener.imagesDownloaded(null);
            }
        } else {
            this.downloadFrame(0, listener);
        }
    }

    private void downloadFrame(int frameIndex, LazyImageSeriesFrame.ImagesDownloadListener listener) {
        LazyImageSeriesFrame frame = this.frames.get(frameIndex);
        if (frame.areImagesDownloaded()) {
            if (listener != null) {
                listener.imagesDownloaded(frame);
            }
        } else {
            if (listener != null) {
                frame.addImagesDownloadListener(listener);
            }
            frame.downloadImagesFromServer();
        }
    }

    public void setSelectedFrame(final int newSelectedFrameIndex, final AsyncCallback<Void> callback) {
        this.selectedFrameIndex = newSelectedFrameIndex;
        LazyImageSeriesFrame.ImagesDownloadListener listener = new LazyImageSeriesFrame.ImagesDownloadListener(){

            @Override
            public void imagesDownloaded(LazyImageSeriesFrame frame) {
                if (newSelectedFrameIndex == LogicalImageSeriesDownloader.this.selectedFrameIndex) {
                    LazyImageSeriesFrame selectedFrame = (LazyImageSeriesFrame)((Object)LogicalImageSeriesDownloader.this.frames.get(newSelectedFrameIndex));
                    LazyImageSeriesFrame shownFrame = (LazyImageSeriesFrame)((Object)LogicalImageSeriesDownloader.this.frames.get(LogicalImageSeriesDownloader.this.shownFrameIndex));
                    shownFrame.hide();
                    selectedFrame.show();
                    LogicalImageSeriesDownloader.this.shownFrameIndex = newSelectedFrameIndex;
                }
                if (callback != null) {
                    callback.onSuccess(null);
                }
            }
        };
        this.downloadFrame(newSelectedFrameIndex, listener);
    }
}

