/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.server.logic;

import ch.systemsx.cisd.common.collection.IKeyExtractor;
import ch.systemsx.cisd.common.collection.TableMap;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IDataSetTable;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CodeAndLabel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListMaterialCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelColumnHeader;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRow;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.plugin.screening.server.IScreeningBusinessObjectFactory;
import ch.systemsx.cisd.openbis.plugin.screening.server.dataaccess.IScreeningQuery;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.AbstractContentLoader;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.AnalysisSettings;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.ScreeningUtils;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.WellDataLoader;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.dto.MaterialIdFeatureVectorSummary;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ExperimentFeatureVectorSummary;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ExperimentReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.MaterialFeatureVectorSummary;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.MaterialSummarySettings;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellSearchCriteria;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;

public class ExperimentFeatureVectorSummaryLoader
extends AbstractContentLoader {
    protected final MaterialSummarySettings settings;
    private final WellDataLoader wellDataLoader;

    public ExperimentFeatureVectorSummaryLoader(Session session, IScreeningBusinessObjectFactory businessObjectFactory, IDAOFactory daoFactory, IScreeningQuery screeningQuery, MaterialSummarySettings settings) {
        super(session, businessObjectFactory, daoFactory, screeningQuery);
        this.settings = settings;
        this.wellDataLoader = new WellDataLoader(session, businessObjectFactory, daoFactory, screeningQuery, settings);
    }

    public ExperimentFeatureVectorSummary loadExperimentFeatureVectors(TechId experimentId, WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria, AnalysisSettings analysisSettings) {
        ExperimentReference experiment = this.loadExperimentByTechId(experimentId);
        if (!analysisSettings.noAnalysisSettings()) {
            List<AbstractExternalData> matchingDataSets = this.getMatchingDataSets(experimentId, analysisProcedureCriteria, analysisSettings);
            TableModel tabelModel = new TableModel(Collections.<TableModelColumnHeader>emptyList(), Collections.<TableModelRow>emptyList());
            if (matchingDataSets.size() == 1) {
                AbstractExternalData ds = matchingDataSets.get(0);
                String reportingPluginKey = analysisSettings.tryToGetReportingPluginKey(ds);
                String dataStore = ds.getDataStore().getCode();
                List<String> codes = Arrays.asList(ds.getCode());
                IDataSetTable dataSetTable = this.businessObjectFactory.createDataSetTable(this.session);
                try {
                    tabelModel = dataSetTable.createReportFromDatasets(reportingPluginKey, dataStore, codes);
                }
                catch (UserFailureException ex) {
                    String message = ex.getMessage();
                    if (message.startsWith("Main ")) {
                        message = String.valueOf(message) + "\n\nHint: The file pattern for the data set type " + ds.getDataSetType().getCode() + " might be wrong.";
                    }
                    throw this.decorateException(ex, ds, "Reason: " + message);
                }
                catch (Exception ex) {
                    throw this.decorateException(ex, ds, "See server logs for the reason.");
                }
            }
            return new ExperimentFeatureVectorSummary(experiment, Collections.<MaterialFeatureVectorSummary>emptyList(), Collections.<CodeAndLabel>emptyList(), tabelModel);
        }
        return this.calculatedSummary(experimentId, analysisProcedureCriteria, experiment);
    }

    ExperimentFeatureVectorSummary calculatedSummary(TechId experimentId, WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria, ExperimentReference experiment) {
        WellDataLoader.MaterialIdSummariesAndFeatures summaries = this.wellDataLoader.tryCalculateExperimentFeatureVectorSummaries(experimentId, this.settings.getReplicaMaterialTypeSubstrings(), analysisProcedureCriteria, false);
        if (summaries == null) {
            return ExperimentFeatureVectorSummaryLoader.createEmptySummary(experiment);
        }
        List<MaterialFeatureVectorSummary> enrichedFeatureSummaries = this.enrichWithMaterials(summaries.getFeatureSummaries());
        return new ExperimentFeatureVectorSummary(experiment, enrichedFeatureSummaries, summaries.getFeatureNames(), null);
    }

    private UserFailureException decorateException(Exception ex, AbstractExternalData dataSet, String message) {
        return new UserFailureException("Analysis summary for data set " + dataSet.getCode() + " couldn't retrieved from Data Store Server. " + message, ex);
    }

    private List<AbstractExternalData> getMatchingDataSets(TechId experimentId, WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria, AnalysisSettings analysisSettings) {
        List<AbstractExternalData> dataSets = this.businessObjectFactory.createDatasetLister(this.session).listByExperimentTechId(experimentId, true);
        ArrayList<AbstractExternalData> matchingDataSets = new ArrayList<AbstractExternalData>();
        for (AbstractExternalData dataSet : dataSets) {
            if (!ScreeningUtils.isMatchingAnalysisProcedure(dataSet, analysisProcedureCriteria) || analysisSettings.tryToGetReportingPluginKey(dataSet) == null) continue;
            matchingDataSets.add(dataSet);
        }
        return matchingDataSets;
    }

    private List<MaterialFeatureVectorSummary> enrichWithMaterials(List<MaterialIdFeatureVectorSummary> summaries) {
        Set<Long> materialIds = ExperimentFeatureVectorSummaryLoader.extractMaterialIds(summaries);
        List<Material> materials = this.fetchMaterials(materialIds);
        return ExperimentFeatureVectorSummaryLoader.enrichWithMaterials(summaries, materials);
    }

    private static List<MaterialFeatureVectorSummary> enrichWithMaterials(List<MaterialIdFeatureVectorSummary> summaries, List<Material> materials) {
        final TableMap<Long, Material> materialMap = ExperimentFeatureVectorSummaryLoader.createMaterialMap(materials);
        Collection collection = CollectionUtils.collect(summaries, (Transformer)new Transformer<MaterialIdFeatureVectorSummary, MaterialFeatureVectorSummary>(){

            public MaterialFeatureVectorSummary transform(MaterialIdFeatureVectorSummary summary) {
                return ExperimentFeatureVectorSummaryLoader.convert(summary, materialMap);
            }
        });
        return new LinkedList<MaterialFeatureVectorSummary>(collection);
    }

    private List<Material> fetchMaterials(Set<Long> materialIds) {
        return this.businessObjectFactory.createMaterialLister(this.session).list(ListMaterialCriteria.createFromMaterialIds(materialIds), true);
    }

    private static Set<Long> extractMaterialIds(List<MaterialIdFeatureVectorSummary> summaries) {
        HashSet<Long> ids = new HashSet<Long>();
        for (MaterialIdFeatureVectorSummary summary : summaries) {
            ids.add((Long)summary.getMaterial());
        }
        return ids;
    }

    private static MaterialFeatureVectorSummary convert(MaterialIdFeatureVectorSummary summary, TableMap<Long, Material> materialMap) {
        Material material = materialMap.getOrDie((Long)summary.getMaterial());
        return summary.createWithMaterial(material);
    }

    private static TableMap<Long, Material> createMaterialMap(List<Material> materials) {
        return new TableMap<Long, Material>(materials, new IKeyExtractor<Long, Material>(){

            @Override
            public Long getKey(Material material) {
                return material.getId();
            }
        }, TableMap.UniqueKeyViolationStrategy.ERROR);
    }

    private static ExperimentFeatureVectorSummary createEmptySummary(ExperimentReference experiment) {
        List<MaterialFeatureVectorSummary> materialsSummary = Collections.emptyList();
        List<CodeAndLabel> featureDescriptions = Collections.emptyList();
        return new ExperimentFeatureVectorSummary(experiment, materialsSummary, featureDescriptions, null);
    }
}

