/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess;

import ch.systemsx.cisd.hcs.Location;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.LongArrayMapper;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.StringArrayMapper;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.FeatureVectorDataObjectBinding;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgAcquiredImageDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgAcquiredImageEnrichedDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgAnalysisDatasetDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgChannelDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgChannelStackDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgContainerDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgExperimentDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgFeatureDefDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgFeatureValuesDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgFeatureVocabularyTermDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgImageDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgImageDatasetDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgImageEnrichedDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgImageTransformationDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgImageZoomLevelDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgImageZoomLevelTransformationEnrichedDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgSpotDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.WidthAndHeightAndPermIdDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.WidthAndHeightDTO;
import java.util.List;
import net.lemnik.eodsql.BaseQuery;
import net.lemnik.eodsql.Select;

public interface IImagingReadonlyQueryDAO
extends BaseQuery {
    public static final int FETCH_SIZE = 1000;
    public static final String SQL_HCS_IMAGE = "select i.*, ACQUIRED_IMAGES.image_transformer_factory as image_transformer_factory from CHANNEL_STACKS, SPOTS, ACQUIRED_IMAGES, IMAGES as i where                                                                ACQUIRED_IMAGES.CHANNEL_ID = ?{1} and CHANNEL_STACKS.DS_ID = ?{2} and CHANNEL_STACKS.x = ?{3.x} and CHANNEL_STACKS.y = ?{3.y} and SPOTS.x = ?{4.x} and SPOTS.y = ?{4.y} and ACQUIRED_IMAGES.CHANNEL_STACK_ID = CHANNEL_STACKS.ID and CHANNEL_STACKS.SPOT_ID = SPOTS.ID ";
    public static final String SQL_MICROSCOPY_IMAGE = "select i.*, ACQUIRED_IMAGES.image_transformer_factory as image_transformer_factory from CHANNEL_STACKS, ACQUIRED_IMAGES, IMAGES as i where                                                                ACQUIRED_IMAGES.CHANNEL_ID = ?{1} and CHANNEL_STACKS.DS_ID = ?{2} and CHANNEL_STACKS.x = ?{3.x} and CHANNEL_STACKS.y = ?{3.y} and CHANNEL_STACKS.spot_id IS NULL and ACQUIRED_IMAGES.CHANNEL_STACK_ID = CHANNEL_STACKS.ID ";
    public static final String SQL_HCS_IMAGE_REPRESENTATIVE = "select i.*, ACQUIRED_IMAGES.image_transformer_factory as image_transformer_factory from CHANNEL_STACKS, SPOTS, ACQUIRED_IMAGES, IMAGES as i where                                        CHANNEL_STACKS.is_representative = 'T' and   CHANNEL_STACKS.DS_ID = ?{1} and              ACQUIRED_IMAGES.channel_id = ?{3} and        SPOTS.x = ?{2.x} and SPOTS.y = ?{2.y} and    ACQUIRED_IMAGES.CHANNEL_STACK_ID = CHANNEL_STACKS.ID and CHANNEL_STACKS.SPOT_ID = SPOTS.ID ";
    public static final String SQL_MICROSCOPY_IMAGE_REPRESENTATIVE = "select i.*, ACQUIRED_IMAGES.image_transformer_factory as image_transformer_factory from CHANNEL_STACKS, ACQUIRED_IMAGES, IMAGES as i where                                         CHANNEL_STACKS.is_representative = 'T' and    CHANNEL_STACKS.DS_ID = ?{1} and               ACQUIRED_IMAGES.channel_id = ?{2} and         ACQUIRED_IMAGES.CHANNEL_STACK_ID = CHANNEL_STACKS.ID ";
    public static final String SQL_ZOOM_LEVEL_TRANSFORMATIONS_ENRICHED = "select izlt.zoom_level_id as zoom_level_id, izlt.channel_id as channel_id, izlt.image_transformation_id as image_transformation_id, ch.code as channel_code, it.code as image_transformation_code, zl.physical_dataset_perm_id as physical_dataset_perm_id from image_zoom_levels zl, image_zoom_level_transformations izlt, image_transformations it, channels ch where                                            izlt.zoom_level_id = zl.id and                   it.id = izlt.image_transformation_id and         ch.id = izlt.channel_id ";
    public static final String SQL_NO_MULTIDIMENTIONAL_DATA_COND = " order by CHANNEL_STACKS.T_in_SEC, CHANNEL_STACKS.Z_in_M limit 1";
    public static final String SQL_HCS_WELLS_WITH_IMAGES = "select distinct s.*                              from CHANNEL_STACKS ch, SPOTS s, ACQUIRED_IMAGES ai where ch.is_representative = 'T' and ch.DS_ID = ?{1} and       ai.CHANNEL_STACK_ID = ch.ID and ch.SPOT_ID = s.ID";
    public static final String SELECT_PLATE_GEOMETRIES_FOR_EXPERIMENT = " select distinct container.spots_width as width, container.spots_height as height       from experiments exp            join containers container on container.expe_id = exp.id       where exp.id = ?{1}";
    public static final String SELECT_TILE_GEOMETRIES_FOR_EXPERIMENT = " select distinct dataset.fields_width as width, dataset.fields_height as height       from experiments exp            join containers container on container.expe_id = exp.id            join image_data_sets dataset on dataset.cont_id = container.id       where exp.id = ?{1}";
    public static final String SELECT_IMAGE_SIZES_FOR_EXPERIMENT = " select dataset.perm_id, level.width, level.height       from experiments exp            join containers container on container.expe_id = exp.id            join image_data_sets dataset on dataset.cont_id = container.id            join image_zoom_levels level on level.container_dataset_id = dataset.id       where exp.id = ?{1} and level.is_original = ?{2}";

    @Select(value="select i.*, ACQUIRED_IMAGES.image_transformer_factory as image_transformer_factory from CHANNEL_STACKS, SPOTS, ACQUIRED_IMAGES, IMAGES as i where                                                                ACQUIRED_IMAGES.CHANNEL_ID = ?{1} and CHANNEL_STACKS.DS_ID = ?{2} and CHANNEL_STACKS.x = ?{3.x} and CHANNEL_STACKS.y = ?{3.y} and SPOTS.x = ?{4.x} and SPOTS.y = ?{4.y} and ACQUIRED_IMAGES.CHANNEL_STACK_ID = CHANNEL_STACKS.ID and CHANNEL_STACKS.SPOT_ID = SPOTS.ID  and ACQUIRED_IMAGES.IMG_ID = i.ID  order by CHANNEL_STACKS.T_in_SEC, CHANNEL_STACKS.Z_in_M limit 1")
    public ImgImageDTO tryGetHCSImage(long var1, long var3, Location var5, Location var6);

    @Select(value="select i.*, ACQUIRED_IMAGES.image_transformer_factory as image_transformer_factory from CHANNEL_STACKS, SPOTS, ACQUIRED_IMAGES, IMAGES as i where                                                                ACQUIRED_IMAGES.CHANNEL_ID = ?{1} and CHANNEL_STACKS.DS_ID = ?{2} and CHANNEL_STACKS.x = ?{3.x} and CHANNEL_STACKS.y = ?{3.y} and SPOTS.x = ?{4.x} and SPOTS.y = ?{4.y} and ACQUIRED_IMAGES.CHANNEL_STACK_ID = CHANNEL_STACKS.ID and CHANNEL_STACKS.SPOT_ID = SPOTS.ID  and ACQUIRED_IMAGES.THUMBNAIL_ID = i.ID  order by CHANNEL_STACKS.T_in_SEC, CHANNEL_STACKS.Z_in_M limit 1")
    public ImgImageDTO tryGetHCSThumbnail(long var1, long var3, Location var5, Location var6);

    @Select(value="select i.*, ACQUIRED_IMAGES.image_transformer_factory as image_transformer_factory from CHANNEL_STACKS, SPOTS, ACQUIRED_IMAGES, IMAGES as i where                                        CHANNEL_STACKS.is_representative = 'T' and   CHANNEL_STACKS.DS_ID = ?{1} and              ACQUIRED_IMAGES.channel_id = ?{3} and        SPOTS.x = ?{2.x} and SPOTS.y = ?{2.y} and    ACQUIRED_IMAGES.CHANNEL_STACK_ID = CHANNEL_STACKS.ID and CHANNEL_STACKS.SPOT_ID = SPOTS.ID  and ACQUIRED_IMAGES.IMG_ID = i.ID ")
    public ImgImageDTO tryGetHCSRepresentativeImage(long var1, Location var3, long var4);

    @Select(value="select i.*, ACQUIRED_IMAGES.image_transformer_factory as image_transformer_factory from CHANNEL_STACKS, SPOTS, ACQUIRED_IMAGES, IMAGES as i where                                        CHANNEL_STACKS.is_representative = 'T' and   CHANNEL_STACKS.DS_ID = ?{1} and              ACQUIRED_IMAGES.channel_id = ?{3} and        SPOTS.x = ?{2.x} and SPOTS.y = ?{2.y} and    ACQUIRED_IMAGES.CHANNEL_STACK_ID = CHANNEL_STACKS.ID and CHANNEL_STACKS.SPOT_ID = SPOTS.ID  and ACQUIRED_IMAGES.THUMBNAIL_ID = i.ID ")
    public ImgImageDTO tryGetHCSRepresentativeThumbnail(long var1, Location var3, long var4);

    @Select(value="select i.*, ai.image_transformer_factory as image_transformer_factory, s.id as spot_id, ai.id as acquired_image_id               from image_data_sets d                                        join channel_stacks cs on cs.ds_id = d.id               join spots s on cs.spot_id = s.id                       join acquired_images ai on ai.channel_stack_id = cs.id  join channels ch on ai.channel_id = ch.id               join images i on i.id = ai.img_id                       where d.perm_id = ?{1} and ch.code = upper(?{2}) and s.id is NOT NULL")
    public List<ImgImageEnrichedDTO> listHCSImages(String var1, String var2);

    @Select(value="select distinct s.*                              from CHANNEL_STACKS ch, SPOTS s, ACQUIRED_IMAGES ai where ch.is_representative = 'T' and ch.DS_ID = ?{1} and       ai.CHANNEL_STACK_ID = ch.ID and ch.SPOT_ID = s.ID")
    public List<ImgSpotDTO> listWellsWithAnyImages(long var1);

    @Select(value="select distinct s.*                              from CHANNEL_STACKS ch, SPOTS s, ACQUIRED_IMAGES ai where ch.is_representative = 'T' and ch.DS_ID = ?{1} and       ai.CHANNEL_STACK_ID = ch.ID and ch.SPOT_ID = s.ID and ai.thumbnail_id is not null")
    public List<ImgSpotDTO> listWellsWithAnyThumbnails(long var1);

    @Select(value="select distinct s.*                              from CHANNEL_STACKS ch, SPOTS s, ACQUIRED_IMAGES ai where ch.is_representative = 'T' and ch.DS_ID = ?{1} and       ai.CHANNEL_STACK_ID = ch.ID and ch.SPOT_ID = s.ID and ai.img_id is not null")
    public List<ImgSpotDTO> listWellsWithAnyOriginalImages(long var1);

    @Select(value="select i.*, ACQUIRED_IMAGES.image_transformer_factory as image_transformer_factory from CHANNEL_STACKS, ACQUIRED_IMAGES, IMAGES as i where                                                                ACQUIRED_IMAGES.CHANNEL_ID = ?{1} and CHANNEL_STACKS.DS_ID = ?{2} and CHANNEL_STACKS.x = ?{3.x} and CHANNEL_STACKS.y = ?{3.y} and CHANNEL_STACKS.spot_id IS NULL and ACQUIRED_IMAGES.CHANNEL_STACK_ID = CHANNEL_STACKS.ID  and ACQUIRED_IMAGES.IMG_ID = i.ID  order by CHANNEL_STACKS.T_in_SEC, CHANNEL_STACKS.Z_in_M limit 1")
    public ImgImageDTO tryGetMicroscopyImage(long var1, long var3, Location var5);

    @Select(value="select i.*, ACQUIRED_IMAGES.image_transformer_factory as image_transformer_factory from CHANNEL_STACKS, ACQUIRED_IMAGES, IMAGES as i where                                                                ACQUIRED_IMAGES.CHANNEL_ID = ?{1} and CHANNEL_STACKS.DS_ID = ?{2} and CHANNEL_STACKS.x = ?{3.x} and CHANNEL_STACKS.y = ?{3.y} and CHANNEL_STACKS.spot_id IS NULL and ACQUIRED_IMAGES.CHANNEL_STACK_ID = CHANNEL_STACKS.ID  and ACQUIRED_IMAGES.THUMBNAIL_ID = i.ID  order by CHANNEL_STACKS.T_in_SEC, CHANNEL_STACKS.Z_in_M limit 1")
    public ImgImageDTO tryGetMicroscopyThumbnail(long var1, long var3, Location var5);

    @Select(value="select i.*, ACQUIRED_IMAGES.image_transformer_factory as image_transformer_factory from CHANNEL_STACKS, ACQUIRED_IMAGES, IMAGES as i where                                         CHANNEL_STACKS.is_representative = 'T' and    CHANNEL_STACKS.DS_ID = ?{1} and               ACQUIRED_IMAGES.channel_id = ?{2} and         ACQUIRED_IMAGES.CHANNEL_STACK_ID = CHANNEL_STACKS.ID  and ACQUIRED_IMAGES.IMG_ID = i.ID ")
    public ImgImageDTO tryGetMicroscopyRepresentativeImage(long var1, long var3);

    @Select(value="select i.*, ACQUIRED_IMAGES.image_transformer_factory as image_transformer_factory from CHANNEL_STACKS, ACQUIRED_IMAGES, IMAGES as i where                                         CHANNEL_STACKS.is_representative = 'T' and    CHANNEL_STACKS.DS_ID = ?{1} and               ACQUIRED_IMAGES.channel_id = ?{2} and         ACQUIRED_IMAGES.CHANNEL_STACK_ID = CHANNEL_STACKS.ID  and ACQUIRED_IMAGES.THUMBNAIL_ID = i.ID ")
    public ImgImageDTO tryGetMicroscopyRepresentativeThumbnail(long var1, long var3);

    @Select(value="select cs.* from CHANNEL_STACKS cs               where cs.ds_id = ?{1} and cs.spot_id is NULL")
    public List<ImgChannelStackDTO> listSpotlessChannelStacks(long var1);

    @Select(value="select i.*, ACQUIRED_IMAGES.image_transformer_factory as image_transformer_factory from IMAGES as i                                      join ACQUIRED_IMAGES on ACQUIRED_IMAGES.IMG_ID = i.ID join CHANNEL_STACKS on ACQUIRED_IMAGES.CHANNEL_STACK_ID = CHANNEL_STACKS.ID where                                                                ACQUIRED_IMAGES.CHANNEL_ID = ?{1} and CHANNEL_STACKS.ID = ?{2} and CHANNEL_STACKS.DS_ID = ?{3}")
    public ImgImageDTO tryGetImage(long var1, Long var3, long var4);

    @Select(value="select i.*, ACQUIRED_IMAGES.image_transformer_factory as image_transformer_factory from IMAGES as i                                      join ACQUIRED_IMAGES on ACQUIRED_IMAGES.THUMBNAIL_ID = i.ID join CHANNEL_STACKS on ACQUIRED_IMAGES.CHANNEL_STACK_ID = CHANNEL_STACKS.ID where                                                                ACQUIRED_IMAGES.CHANNEL_ID = ?{1} and CHANNEL_STACKS.ID = ?{2} and CHANNEL_STACKS.DS_ID = ?{3}")
    public ImgImageDTO tryGetThumbnail(long var1, Long var3, long var4);

    @Select(value="select * from ACQUIRED_IMAGES where CHANNEL_ID in (select ID from CHANNELS where DS_ID = (SELECT ID FROM IMAGE_DATA_SETS WHERE PERM_ID = ?{1}))or CHANNEL_STACK_ID in (select id from CHANNEL_STACKS where DS_ID = (SELECT ID FROM IMAGE_DATA_SETS WHERE PERM_ID = ?{1}))")
    public List<ImgAcquiredImageDTO> listAllAcquiredImagesForDataSet(String var1);

    @Select(value="select * from ACQUIRED_IMAGES where CHANNEL_ID in (select ID from CHANNELS where DS_ID = ?{1}) or CHANNEL_STACK_ID in (select id from CHANNEL_STACKS where DS_ID = ?{1})")
    public List<ImgAcquiredImageDTO> listAllAcquiredImagesForDataSet(long var1);

    @Select(value="select ai.ID as ID, ai.IMAGE_TRANSFORMER_FACTORY as IMAGE_TRANSFORMER_FACTORY, ai.IMG_ID as IMG_ID, ai.CHANNEL_STACK_ID as CHANNEL_STACK_ID, ai.CHANNEL_ID as CHANNEL_ID,   s.X as SPOT_X, s.Y as SPOT_Y, i.path as IMAGE_PATH, i.IMAGE_ID as IMAGE_ID, i.color as IMAGE_COLOR,   th.path as THUMBNAIL_PATH, th.IMAGE_ID as THUMBNAIL_IMAGE_ID, th.color as THUMBNAIL_COLOR,   ch.code as CHANNEL_CODE, cs.X as X, cs.Y as Y, cs.Z_in_M as Z_in_M, cs.T_in_SEC as T_in_SEC, cs.SERIES_NUMBER as SERIES_NUMBER from acquired_images ai   join images i on ai.img_id = i.id   left outer join images th on ai.thumbnail_id = th.id   left outer join channels ch on ai.channel_id = ch.id   left outer join channel_stacks cs on ai.channel_stack_id = cs.id   left outer join spots s on cs.spot_id = s.id where ch.ds_id = ?{1} or cs.ds_id = ?{1}")
    public List<ImgAcquiredImageEnrichedDTO> listAllEnrichedAcquiredImagesForDataSet(long var1);

    @Select(value="select * from IMAGE_DATA_SETS where PERM_ID = ?{1}")
    public ImgImageDatasetDTO tryGetImageDatasetByPermId(String var1);

    @Select(value="select * from IMAGE_DATA_SETS where ID = ?{1}")
    public ImgImageDatasetDTO tryGetImageDatasetById(long var1);

    @Select(value="select id from IMAGE_DATA_SETS where ID > ?{1} order by id limit 1")
    public Long tryGetNextDatasetId(long var1);

    @Select(value="select count(*) > 0 from channels ch, image_transformations it where ch.ds_id = ?{1} and it.channel_id = ch.id and it.code = upper(?{2})")
    public boolean hasDatasetDefinedTransformation(long var1, String var3);

    @Select(value="select * from ANALYSIS_DATA_SETS where PERM_ID = ?{1}")
    public ImgAnalysisDatasetDTO tryGetAnalysisDatasetByPermId(String var1);

    @Select(sql="select * from IMAGE_DATA_SETS where PERM_ID = any(?{1})", parameterBindings={StringArrayMapper.class}, fetchSize=1000)
    public List<ImgImageDatasetDTO> listImageDatasetsByPermId(String ... var1);

    @Select(sql="select * from IMAGE_ZOOM_LEVELS zoom where zoom.CONTAINER_DATASET_ID = ?{1}", fetchSize=1000)
    public List<ImgImageZoomLevelDTO> listImageZoomLevels(long var1);

    @Select(sql="select * from IMAGE_ZOOM_LEVELS zoom where zoom.CONTAINER_DATASET_ID = ?{1} and ID not in (select ZOOM_LEVEL_ID from IMAGE_ZOOM_LEVEL_TRANSFORMATIONS)", fetchSize=1000)
    public List<ImgImageZoomLevelDTO> listImageZoomLevelsWithNoTransformations(long var1);

    @Select(sql="select izlt.zoom_level_id as zoom_level_id, izlt.channel_id as channel_id, izlt.image_transformation_id as image_transformation_id, ch.code as channel_code, it.code as image_transformation_code, zl.physical_dataset_perm_id as physical_dataset_perm_id from image_zoom_levels zl, image_zoom_level_transformations izlt, image_transformations it, channels ch where                                            izlt.zoom_level_id = zl.id and                   it.id = izlt.image_transformation_id and         ch.id = izlt.channel_id  and zl.container_dataset_id = ?{1}", fetchSize=1000)
    public List<ImgImageZoomLevelTransformationEnrichedDTO> listImageZoomLevelTransformations(long var1);

    @Select(sql="select izlt.zoom_level_id as zoom_level_id, izlt.channel_id as channel_id, izlt.image_transformation_id as image_transformation_id, ch.code as channel_code, it.code as image_transformation_code, zl.physical_dataset_perm_id as physical_dataset_perm_id from image_zoom_levels zl, image_zoom_level_transformations izlt, image_transformations it, channels ch where                                            izlt.zoom_level_id = zl.id and                   it.id = izlt.image_transformation_id and         ch.id = izlt.channel_id  and zl.container_dataset_id = ?{1} and izlt.channel_id = ?{2} and it.code = ?{3}", fetchSize=1000)
    public List<ImgImageZoomLevelTransformationEnrichedDTO> findImageZoomLevelTransformations(long var1, long var3, String var5);

    @Select(sql="  select * from IMAGE_ZOOM_LEVELS zoom where zoom.physical_dataset_perm_id = ?{1} and zoom.is_original UNION ALL  select zoom.* from IMAGE_ZOOM_LEVELS zoom left join image_data_sets data on data.id = zoom.container_dataset_id     where data.perm_id = ?{1} and zoom.is_original")
    public List<ImgImageZoomLevelDTO> listOriginalImageZoomLevelsByPermId(String var1);

    @Select(sql="select * from IMAGE_ZOOM_LEVELS zoom where zoom.physical_dataset_perm_id = ?{1} and not zoom.is_original UNION ALL  select zoom.* from IMAGE_ZOOM_LEVELS zoom left join image_data_sets data on data.id = zoom.container_dataset_id     where data.perm_id = ?{1} and not zoom.is_original")
    public List<ImgImageZoomLevelDTO> listThumbImageZoomLevelsByPermId(String var1);

    @Select(sql="select * from ANALYSIS_DATA_SETS where PERM_ID = any(?{1})", parameterBindings={StringArrayMapper.class}, fetchSize=1000)
    public List<ImgAnalysisDatasetDTO> listAnalysisDatasetsByPermId(String ... var1);

    @Select(value="select * from CHANNELS where DS_ID = ?{1} order by ID")
    public List<ImgChannelDTO> getChannelsByDatasetId(long var1);

    @Select(sql="select * from CHANNELS where EXP_ID = ?{1} order by ID", fetchSize=1000)
    public List<ImgChannelDTO> getChannelsByExperimentId(long var1);

    @Select(value="select * from CHANNELS where (DS_ID = ?{1}) and CODE = upper(?{2})")
    public ImgChannelDTO tryGetChannelForDataset(long var1, String var3);

    @Select(value="select * from CHANNELS where (EXP_ID = ?{1}) and CODE = upper(?{2})")
    public ImgChannelDTO tryGetChannelForExperiment(long var1, String var3);

    @Select(value="select id from channels where ds_id = ?{1} and code = upper(?{2})")
    public long getDatasetChannelId(long var1, String var3);

    @Select(value="select id from channels where exp_id = ?{1} and code = upper(?{2})")
    public long getExperimentChannelId(long var1, String var3);

    @Select(value="select count(*) > 0 from CHANNELS ch join IMAGE_DATA_SETS d on ch.ds_id = d.id where d.PERM_ID = ?{1}")
    public boolean hasDatasetChannels(String var1);

    @Select(value="select * from channels where code = ?{2} and exp_id in (select id from experiments where perm_id = ?{1})")
    public ImgChannelDTO tryGetChannelForExperimentPermId(String var1, String var2);

    @Select(value="select * from IMAGE_TRANSFORMATIONS tr where tr.channel_id = ?{1} order by tr.ID")
    public List<ImgImageTransformationDTO> listImageTransformations(long var1);

    @Select(value="select id from image_transformations where channel_id = ?{1} and code = ?{2}")
    public Long tryGetImageTransformationId(long var1, String var3);

    @Select(value="select * from image_transformations where channel_id = ?{1} and code = ?{2}")
    public ImgImageTransformationDTO tryGetImageTransformation(long var1, String var3);

    @Select(value="select tr.* from IMAGE_TRANSFORMATIONS tr                        join channels ch on tr.channel_id = ch.id                     where ch.ds_id = ?{1} order by tr.ID                        ")
    public List<ImgImageTransformationDTO> listImageTransformationsByDatasetId(long var1);

    @Select(value="select tr.* from IMAGE_TRANSFORMATIONS tr                        join channels ch on tr.channel_id = ch.id                     where ch.exp_id = ?{1} order by tr.ID                        ")
    public List<ImgImageTransformationDTO> listImageTransformationsByExperimentId(long var1);

    @Select(value="select * from EXPERIMENTS where PERM_ID = ?{1}")
    public ImgExperimentDTO tryGetExperimentByPermId(String var1);

    @Select(value="select * from EXPERIMENTS where ID = ?{1}")
    public ImgExperimentDTO tryGetExperimentById(long var1);

    @Select(value="select ID from CONTAINERS where PERM_ID = ?{1}")
    public Long tryGetContainerIdPermId(String var1);

    @Select(value="select * from CONTAINERS where ID = ?{1}")
    public ImgContainerDTO getContainerById(long var1);

    @Select(sql="select * from CONTAINERS where ID = any(?{1})", parameterBindings={LongArrayMapper.class}, fetchSize=1000)
    public List<ImgContainerDTO> listContainersByIds(long ... var1);

    @Select(value="select cs.* from CHANNEL_STACKS cs               join SPOTS s on s.id = cs.spot_id              join CONTAINERS c on c.id = s.cont_id          where cs.ds_id = ?{1} and s.x = ?{2} and s.y = ?{3}")
    public List<ImgChannelStackDTO> listChannelStacks(long var1, int var3, int var4);

    @Select(value="select cs.* from CHANNEL_STACKS cs               join SPOTS s on s.id = cs.spot_id              join CONTAINERS c on c.id = s.cont_id          where cs.ds_id = ?{1} and s.id = ?{2}")
    public List<ImgChannelStackDTO> listChannelStacks(long var1, long var3);

    @Select(value="select cs.* from CHANNEL_STACKS cs               join SPOTS s on s.id = cs.spot_id              join CONTAINERS c on c.id = s.cont_id          where cs.ds_id = ?{1} and s.id IS NULL")
    public List<ImgChannelStackDTO> listChannelStacks(long var1);

    @Select(value="select * from SPOTS where cont_id = ?{1}")
    public List<ImgSpotDTO> listSpots(long var1);

    @Select(sql="select * from FEATURE_DEFS where DS_ID = any(?{1}) ORDER BY ds_id ASC, id ASC", parameterBindings={LongArrayMapper.class}, fetchSize=1000)
    public List<ImgFeatureDefDTO> listFeatureDefsByDataSetIds(long ... var1);

    @Select(sql="select t.*, fd.ds_id as DS_ID from FEATURE_VOCABULARY_TERMS t      join FEATURE_DEFS fd on fd.id = t.fd_id                                where fd.DS_ID = any(?{1}) ORDER BY fd.ds_id ASC, fd.id ASC            ", parameterBindings={LongArrayMapper.class}, fetchSize=1000)
    public List<ImgFeatureVocabularyTermDTO> listFeatureVocabularyTermsByDataSetId(long ... var1);

    @Select(sql="select * from FEATURE_VALUES where FD_ID = any(?{1}) order by T_in_SEC, Z_in_M", parameterBindings={LongArrayMapper.class}, fetchSize=1000, resultSetBinding=FeatureVectorDataObjectBinding.class)
    public List<ImgFeatureValuesDTO> getFeatureValues(long ... var1);

    @Select(sql=" select distinct container.spots_width as width, container.spots_height as height       from experiments exp            join containers container on container.expe_id = exp.id       where exp.id = ?{1}")
    public List<WidthAndHeightDTO> listPlateGeometriesForExperiment(long var1);

    @Select(sql=" select distinct dataset.fields_width as width, dataset.fields_height as height       from experiments exp            join containers container on container.expe_id = exp.id            join image_data_sets dataset on dataset.cont_id = container.id       where exp.id = ?{1}")
    public List<WidthAndHeightDTO> listTileGeometriesForExperiment(long var1);

    @Select(sql=" select dataset.perm_id, level.width, level.height       from experiments exp            join containers container on container.expe_id = exp.id            join image_data_sets dataset on dataset.cont_id = container.id            join image_zoom_levels level on level.container_dataset_id = dataset.id       where exp.id = ?{1} and level.is_original = ?{2}")
    public List<WidthAndHeightAndPermIdDTO> listImageSizesForExperiment(long var1, boolean var3);
}

