/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client;

import ch.systemsx.cisd.cifex.rpc.client.FileItemStatus;
import ch.systemsx.cisd.cifex.rpc.client.TransmissionSpeedCalculator;
import ch.systemsx.cisd.common.utilities.ITimeProvider;
import java.io.File;

public final class FileItem {
    private final File originalFile;
    private File uploadedFile;
    private final long length;
    private FileItemStatus status;
    private long numberOfBytesUploaded;
    private final TransmissionSpeedCalculator transmissionSpeedCalculator;

    public FileItem(File file, ITimeProvider timeProvider) {
        this.originalFile = file;
        this.uploadedFile = file;
        this.transmissionSpeedCalculator = new TransmissionSpeedCalculator(timeProvider);
        this.length = file.length();
        this.status = FileItemStatus.NOT_STARTED;
    }

    public File getFile() {
        return this.originalFile;
    }

    public File getUploadedFile() {
        return this.uploadedFile;
    }

    public void setUploadedFile(File uploadedFile) {
        this.uploadedFile = uploadedFile;
    }

    public long getLength() {
        return this.length;
    }

    public FileItemStatus getStatus() {
        return this.status;
    }

    public void setStatus(FileItemStatus status) {
        this.status = status;
    }

    public long getNumberOfBytesUploaded() {
        return this.numberOfBytesUploaded;
    }

    public void setNumberOfBytesUploaded(long numberOfBytesUploaded) {
        this.setStatus(FileItemStatus.UPLOADING);
        int transmittedSinceLastUpdate = (int)(numberOfBytesUploaded - this.numberOfBytesUploaded);
        this.transmissionSpeedCalculator.noteTransmittedBytesSinceLastUpdate(transmittedSinceLastUpdate);
        this.numberOfBytesUploaded = numberOfBytesUploaded;
    }

    public long getEstimatedTimeOfArrival() {
        float remainingBytes = this.length - this.numberOfBytesUploaded;
        float bytesPerMillisecond = this.transmissionSpeedCalculator.getEstimatedBytesPerMillisecond();
        if ((double)bytesPerMillisecond < 0.001) {
            return -1L;
        }
        return (long)(remainingBytes / bytesPerMillisecond);
    }

    public String toString() {
        return this.originalFile.getName();
    }
}

