/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.model;

import loci.poi.ddf.EscherArrayProperty;
import loci.poi.ddf.EscherClientDataRecord;
import loci.poi.ddf.EscherContainerRecord;
import loci.poi.ddf.EscherOptRecord;
import loci.poi.ddf.EscherRecord;
import loci.poi.ddf.EscherShapePathProperty;
import loci.poi.ddf.EscherSimpleProperty;
import loci.poi.ddf.EscherSpRecord;
import loci.poi.hssf.model.AbstractShape;
import loci.poi.hssf.record.CommonObjectDataSubRecord;
import loci.poi.hssf.record.EndSubRecord;
import loci.poi.hssf.record.ObjRecord;
import loci.poi.hssf.usermodel.HSSFPolygon;
import loci.poi.hssf.usermodel.HSSFShape;
import loci.poi.util.LittleEndian;

public class PolygonShape
extends AbstractShape {
    public static final short OBJECT_TYPE_MICROSOFT_OFFICE_DRAWING = 30;
    private EscherContainerRecord spContainer;
    private ObjRecord objRecord;

    PolygonShape(HSSFPolygon hssfShape, int shapeId) {
        this.spContainer = this.createSpContainer(hssfShape, shapeId);
        this.objRecord = this.createObjRecord(hssfShape, shapeId);
    }

    private EscherContainerRecord createSpContainer(HSSFPolygon hssfShape, int shapeId) {
        byte[] data;
        HSSFPolygon shape = hssfShape;
        EscherContainerRecord spContainer = new EscherContainerRecord();
        EscherSpRecord sp = new EscherSpRecord();
        EscherOptRecord opt = new EscherOptRecord();
        EscherClientDataRecord clientData = new EscherClientDataRecord();
        spContainer.setRecordId((short)-4092);
        spContainer.setOptions((short)15);
        sp.setRecordId((short)-4086);
        sp.setOptions((short)370);
        sp.setShapeId(shapeId);
        if (hssfShape.getParent() == null) {
            sp.setFlags(2560);
        } else {
            sp.setFlags(2562);
        }
        opt.setRecordId((short)-4085);
        opt.addEscherProperty(new EscherSimpleProperty(4, false, false, 0));
        opt.addEscherProperty(new EscherSimpleProperty(322, false, false, hssfShape.getDrawAreaWidth()));
        opt.addEscherProperty(new EscherSimpleProperty(323, false, false, hssfShape.getDrawAreaHeight()));
        opt.addEscherProperty(new EscherShapePathProperty(324, 4));
        EscherArrayProperty verticesProp = new EscherArrayProperty(325, false, new byte[0]);
        verticesProp.setNumberOfElementsInArray(hssfShape.getXPoints().length + 1);
        verticesProp.setNumberOfElementsInMemory(hssfShape.getXPoints().length + 1);
        verticesProp.setSizeOfElements(65520);
        for (int i = 0; i < hssfShape.getXPoints().length; ++i) {
            data = new byte[4];
            LittleEndian.putShort(data, 0, (short)hssfShape.getXPoints()[i]);
            LittleEndian.putShort(data, 2, (short)hssfShape.getYPoints()[i]);
            verticesProp.setElement(i, data);
        }
        int point = hssfShape.getXPoints().length;
        data = new byte[4];
        LittleEndian.putShort(data, 0, (short)hssfShape.getXPoints()[0]);
        LittleEndian.putShort(data, 2, (short)hssfShape.getYPoints()[0]);
        verticesProp.setElement(point, data);
        opt.addEscherProperty(verticesProp);
        EscherArrayProperty segmentsProp = new EscherArrayProperty(326, false, null);
        segmentsProp.setSizeOfElements(2);
        segmentsProp.setNumberOfElementsInArray(hssfShape.getXPoints().length * 2 + 4);
        segmentsProp.setNumberOfElementsInMemory(hssfShape.getXPoints().length * 2 + 4);
        segmentsProp.setElement(0, new byte[]{0, 64});
        segmentsProp.setElement(1, new byte[]{0, -84});
        for (int i = 0; i < hssfShape.getXPoints().length; ++i) {
            segmentsProp.setElement(2 + i * 2, new byte[]{1, 0});
            segmentsProp.setElement(3 + i * 2, new byte[]{0, -84});
        }
        segmentsProp.setElement(segmentsProp.getNumberOfElementsInArray() - 2, new byte[]{1, 96});
        segmentsProp.setElement(segmentsProp.getNumberOfElementsInArray() - 1, new byte[]{0, -128});
        opt.addEscherProperty(segmentsProp);
        opt.addEscherProperty(new EscherSimpleProperty(383, false, false, 65537));
        opt.addEscherProperty(new EscherSimpleProperty(464, false, false, 0));
        opt.addEscherProperty(new EscherSimpleProperty(465, false, false, 0));
        opt.addEscherProperty(new EscherSimpleProperty(471, false, false, 0));
        this.addStandardOptions(shape, opt);
        EscherRecord anchor = this.createAnchor(shape.getAnchor());
        clientData.setRecordId((short)-4079);
        clientData.setOptions((short)0);
        spContainer.addChildRecord(sp);
        spContainer.addChildRecord(opt);
        spContainer.addChildRecord(anchor);
        spContainer.addChildRecord(clientData);
        return spContainer;
    }

    private ObjRecord createObjRecord(HSSFShape hssfShape, int shapeId) {
        HSSFShape shape = hssfShape;
        ObjRecord obj = new ObjRecord();
        CommonObjectDataSubRecord c = new CommonObjectDataSubRecord();
        c.setObjectType((short)30);
        c.setObjectId((short)shapeId);
        c.setLocked(true);
        c.setPrintable(true);
        c.setAutofill(true);
        c.setAutoline(true);
        EndSubRecord e = new EndSubRecord();
        obj.addSubRecord(c);
        obj.addSubRecord(e);
        return obj;
    }

    public EscherContainerRecord getSpContainer() {
        return this.spContainer;
    }

    public ObjRecord getObjRecord() {
        return this.objRecord;
    }
}

