/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.sybit.imageviewer.service;

import ch.systemsx.sybit.imageviewer.data.SettingsUtil;
import ch.systemsx.sybit.imageviewer.gui.ImageViewer;
import java.awt.EventQueue;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URLDecoder;

public class ImageViewerServer {
    private ServerSocket serverSocket;
    private String topPath = null;
    private ImageViewer imageViewer;

    public ImageViewerServer(int port, String topPath) throws IOException {
        this.topPath = topPath;
        this.serverSocket = new ServerSocket(port);
        System.out.println("Listening on port: " + port + " started");
    }

    public void run() throws IOException {
        while (true) {
            System.out.println("Waiting");
            Socket socket = this.serverSocket.accept();
            BufferedOutputStream outputWriter = new BufferedOutputStream(socket.getOutputStream());
            BufferedReader inputReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            String input = inputReader.readLine();
            if (input != null) {
                try {
                    this.handleRequest(input);
                    this.sendMessage(outputWriter, 100, "");
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    this.sendMessage(outputWriter, 404, t.getMessage());
                }
            } else {
                this.sendMessage(outputWriter, 404, "No input stream available");
            }
            outputWriter.close();
            inputReader.close();
            socket.close();
            System.out.println("Served");
        }
    }

    private void handleRequest(String input) throws Throwable {
        if (input == null) {
            throw new Exception("Incorrect format of the request");
        }
        if (!input.startsWith("GET ")) {
            throw new Exception("Only GET method is supported");
        }
        if (!input.endsWith(" HTTP/1.0") && !input.endsWith("HTTP/1.1")) {
            throw new Exception("Incorrect format of the request");
        }
        String url = input.substring(4, input.length() - 9);
        if ((url = url.trim()).contains("?") && url.indexOf("?") != url.length() - 1) {
            url = url.substring(url.indexOf("?") + 1);
            String[] parameters = url.split("&");
            String path = null;
            String filter = null;
            String defaultImageSize = null;
            String newWindow = null;
            for (int i = 0; i < parameters.length && (path == null || filter == null || defaultImageSize == null || newWindow == null); ++i) {
                if (parameters[i].startsWith("path=") && parameters[i].length() > 5) {
                    path = parameters[i].substring(5);
                }
                if (parameters[i].startsWith("filter=") && parameters[i].length() > 7) {
                    filter = parameters[i].substring(7);
                }
                if (parameters[i].startsWith("size=") && parameters[i].length() > 5) {
                    defaultImageSize = parameters[i].substring(5);
                    try {
                        Integer.parseInt(defaultImageSize);
                    }
                    catch (Throwable t) {
                        throw new Exception("Default size of the image specified but is not integer");
                    }
                }
                if (!parameters[i].startsWith("newwindow=") || parameters[i].length() <= 10) continue;
                newWindow = parameters[i].substring(10);
                try {
                    Boolean.parseBoolean(newWindow);
                    continue;
                }
                catch (Throwable t) {
                    throw new Exception("New window parameter specified but is not boolean(true/false)");
                }
            }
            if (path == null) {
                throw new Exception("Directory or file not specified");
            }
            File file = new File(URLDecoder.decode(path, "UTF-8")).getCanonicalFile();
            if (this.topPath != null && !file.toString().startsWith(this.topPath.toString())) {
                throw new Exception("Permission denied");
            }
            if (!file.exists()) {
                throw new Exception("File Not Found");
            }
            if (defaultImageSize == null) {
                defaultImageSize = SettingsUtil.localSystemDefaultScale;
            }
            if (newWindow == null) {
                newWindow = "false";
            }
            int mode = SettingsUtil.LocalSystem;
            boolean useNewWindow = Boolean.parseBoolean(newWindow);
            String[] args = new String[]{"-i", path};
            if (!useNewWindow && this.imageViewer != null) {
                this.imageViewer.checkBeforeExit();
                this.imageViewer.finish();
                this.imageViewer.dispose();
            }
            final ImageViewer usedImageViewer = new ImageViewer(args, mode, defaultImageSize);
            usedImageViewer.setTitle(usedImageViewer.getTitle() + " - " + path);
            Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                public void uncaughtException(Thread t, Throwable e) {
                    usedImageViewer.showErrorDialog("Default handler", e, true);
                    e.printStackTrace();
                }
            });
            if (!useNewWindow || this.imageViewer == null) {
                this.imageViewer = usedImageViewer;
            }
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    usedImageViewer.setVisible(true);
                    usedImageViewer.showLoading();
                }
            });
            usedImageViewer.loadImages(filter);
        } else if (!url.contains("favicon.ico")) {
            throw new Exception("No parameters specified in the request");
        }
    }

    private void sendMessage(BufferedOutputStream outputStream, int code, String message) throws IOException {
        outputStream.write(("HTTP/1.0 " + code + " OK\r\n" + "\r\n").getBytes());
        outputStream.write(message.getBytes());
    }
}

