/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.etlserver.IDataStoreStrategy;
import java.io.File;

public final class BaseDirectoryHolder {
    private final File baseDirectory;
    private final IDataStoreStrategy dataStoreStrategy;
    private final File incomingDataSetPath;
    private File targetFile;

    public BaseDirectoryHolder(IDataStoreStrategy dataStoreStrategy, File baseDirectory, File incomingDataSetPath) {
        assert (dataStoreStrategy != null) : "Data store strategy can not be null.";
        assert (baseDirectory != null) : "Base directory can not be null";
        assert (incomingDataSetPath != null) : "Incoming data set can not be null.";
        this.dataStoreStrategy = dataStoreStrategy;
        this.baseDirectory = baseDirectory;
        this.incomingDataSetPath = incomingDataSetPath;
    }

    private final File createTargetFile() {
        return this.dataStoreStrategy.getTargetPath(this.baseDirectory, this.incomingDataSetPath);
    }

    public final File getBaseDirectory() {
        return this.baseDirectory;
    }

    public final synchronized File getTargetFile() {
        if (this.targetFile == null) {
            this.targetFile = this.createTargetFile();
        }
        return this.targetFile;
    }
}

