/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.LongRunningThreadInterceptor;
import ch.systemsx.cisd.openbis.generic.server.LongRunningThreadLogConfiguration;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public class LongRunningThreadLogger
implements Runnable {
    private static final Logger logger = LogFactory.getLogger(LogCategory.ACCESS, LongRunningThreadLogger.class);
    private final LongRunningThreadLogConfiguration config;
    private final LongRunningThreadInterceptor interceptor;

    public LongRunningThreadLogger(LongRunningThreadInterceptor interceptor, LongRunningThreadLogConfiguration config) {
        this.interceptor = interceptor;
        this.config = config;
    }

    @Override
    public void run() {
        while (true) {
            Set<LongRunningThreadInterceptor.InvocationStart> invocations = this.interceptor.getInvocationsRunningLongerThan(this.config.maxValidInvocationLength());
            if (this.config.isLoggingEnabled()) {
                this.log(invocations);
            }
            try {
                Thread.sleep(this.config.logInterval());
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private void log(Set<LongRunningThreadInterceptor.InvocationStart> invocations) {
        if (invocations.size() != 0) {
            logger.warn((Object)("Long running invocation report at " + this.format(System.currentTimeMillis())));
            for (LongRunningThreadInterceptor.InvocationStart invocation : invocations) {
                Method method = invocation.invocation.getMethod();
                long duration = (System.currentTimeMillis() - invocation.startTime) / 1000L;
                logger.warn((Object)("Thread " + invocation.threadName + " has been executing " + method.getDeclaringClass().getCanonicalName() + "." + method.getName() + "(" + this.argumentsToString(invocation.invocation.getArguments()) + ") for " + String.format("%d:%02d:%02d", duration / 3600L, duration % 3600L / 60L, duration % 60L)));
            }
            logger.info((Object)"-----------");
        }
    }

    private String argumentsToString(Object[] arguments) {
        if (arguments.length == 0) {
            return "";
        }
        String args = "";
        Object[] objectArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            Object argument = objectArray[n2];
            args = argument != null ? String.valueOf(args) + ", " + argument.toString() : String.valueOf(args) + ", null";
            ++n2;
        }
        return args.substring(2);
    }

    private String format(long time) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(new Date(time));
    }
}

