/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.translator;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.translator.DataSetTypePropertyTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.DatabaseInstanceTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.ScriptTranslator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DataSetTypeTranslator {
    private DataSetTypeTranslator() {
    }

    public static DataSetType translate(DataSetTypePE entityTypeOrNull, Map<PropertyTypePE, PropertyType> cacheOrNull) {
        if (entityTypeOrNull == null) {
            return null;
        }
        DataSetType result = new DataSetType();
        result.setCode(entityTypeOrNull.getCode());
        result.setDescription(entityTypeOrNull.getDescription());
        result.setDatabaseInstance(DatabaseInstanceTranslator.translate(entityTypeOrNull.getDatabaseInstance()));
        result.setDataSetTypePropertyTypes(EntityType.sortedInternally(DataSetTypePropertyTypeTranslator.translate(entityTypeOrNull.getDataSetTypePropertyTypes(), result, cacheOrNull)));
        result.setMainDataSetPath(entityTypeOrNull.getMainDataSetPath());
        result.setMainDataSetPattern(entityTypeOrNull.getMainDataSetPattern());
        result.setDataSetKind(DataSetKind.valueOf(entityTypeOrNull.getDataSetKind()));
        result.setDeletionDisallow(entityTypeOrNull.isDeletionDisallow());
        result.setModificationDate(entityTypeOrNull.getModificationDate());
        result.setValidationScript(ScriptTranslator.translate(entityTypeOrNull.getValidationScript()));
        return result;
    }

    public static List<DataSetType> translate(List<DataSetTypePE> dataSetTypes, Map<PropertyTypePE, PropertyType> cacheOrNull) {
        ArrayList<DataSetType> result = new ArrayList<DataSetType>();
        for (DataSetTypePE dataSetType : dataSetTypes) {
            result.add(DataSetTypeTranslator.translate(dataSetType, cacheOrNull));
        }
        return result;
    }

    public static DataSetTypePE translate(DataSetType type) {
        DataSetTypePE result = new DataSetTypePE();
        result.setCode(type.getCode());
        return result;
    }
}

