/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.PropertyValueRenderers;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property.AbstractPropertyValueRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property.IPropertyValueRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.ExternalHyperlink;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application.AccessionNumberURLCreator;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application.ProteinViewer;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.AccessionNumberProvider;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.Occurrence;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.OccurrenceUtil;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.Peptide;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.PeptideModification;
import com.extjs.gxt.ui.client.widget.Text;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.InlineHTML;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class ProteinRenderers {
    private ProteinRenderers() {
    }

    public static final IPropertyValueRenderer<AccessionNumberProvider> createProteinIdentLinkRenderer(IViewContext<?> viewContext) {
        return new AccessionNumberRenderer(viewContext);
    }

    public static final IPropertyValueRenderer<Peptide> createPeptideRenderer(IViewContext<?> viewContext) {
        return new PeptideRenderer(viewContext);
    }

    public static final IPropertyValueRenderer<Experiment> createExperimentPropertyValueRenderer(IViewContext<?> viewContext) {
        return PropertyValueRenderers.createExperimentPropertyValueRenderer(viewContext);
    }

    public static final IPropertyValueRenderer<ProteinViewer.DatasetInformationHolder> createEntityInformationPropertyValueRenderer(IViewContext<?> viewContext) {
        return new PropertyValueRenderers.EntityInformationHolderPropertyValueRenderer<ProteinViewer.DatasetInformationHolder>(viewContext);
    }

    public static String getFixedWidthHTMLString(String text) {
        return "<font style='font-family:monospace'>" + text + "</font>";
    }

    public static String markOccurrencesWithHtml(String proteinSequence, List<Peptide> peptides, int blockLength) {
        List<Symbol> symbols = ProteinRenderers.createSymbols(proteinSequence, peptides);
        StringBuilder builder = new StringBuilder();
        boolean inPeptide = false;
        int i = 0;
        int n = symbols.size();
        while (i < n) {
            Symbol symbol;
            boolean nextInPeptide;
            if (i > 0 && i % blockLength == 0) {
                builder.append(" ");
            }
            if (inPeptide != (nextInPeptide = (symbol = symbols.get(i)).isInPeptide())) {
                builder.append(nextInPeptide ? "<font color='red'>" : "</font>");
            }
            inPeptide = nextInPeptide;
            Double mass = symbol.getMass();
            char character = symbol.getCharacter();
            if (mass == null) {
                builder.append(character);
            } else {
                builder.append(ProteinRenderers.renderAminoAcidSymbol(character, i + 1, mass));
            }
            ++i;
        }
        return builder.toString();
    }

    public static String renderAminoAcidSymbol(char character, Integer positionOrNull, double mass) {
        String tooltip = positionOrNull == null ? "" : "position=" + positionOrNull + ", ";
        tooltip = String.valueOf(tooltip) + "mass=" + mass;
        return "<font style='text-decoration:underline; cursor:pointer' color='blue' title='" + tooltip + "'>" + character + "</font>";
    }

    private static List<Symbol> createSymbols(String proteinSequence, List<Peptide> peptides) {
        ArrayList<Symbol> symbols = new ArrayList<Symbol>();
        int i = 0;
        int n = proteinSequence.length();
        while (i < n) {
            symbols.add(new Symbol(proteinSequence.charAt(i)));
            ++i;
        }
        for (Peptide peptide : peptides) {
            List<Occurrence> occurances = OccurrenceUtil.findAllOccurrences(proteinSequence, peptide.getSequence());
            List<PeptideModification> modifications = peptide.getModifications();
            for (Occurrence occurrence : occurances) {
                int startIndex;
                int i2 = startIndex = occurrence.getStartIndex();
                int n2 = occurrence.getEndIndex();
                while (i2 <= n2) {
                    ((Symbol)symbols.get(i2)).inPeptide();
                    ++i2;
                }
                for (PeptideModification peptideModification : modifications) {
                    Symbol symbol = (Symbol)symbols.get(startIndex + peptideModification.getPosition() - 1);
                    symbol.setMass(peptideModification.getMass());
                }
            }
        }
        return symbols;
    }

    private static final class AccessionNumberRenderer
    extends AbstractPropertyValueRenderer<AccessionNumberProvider> {
        AccessionNumberRenderer(IMessageProvider messageProvider) {
            super(messageProvider);
        }

        @Override
        public Widget getAsWidget(AccessionNumberProvider object) {
            String accessionNumber = object.getAccessionNumber();
            String type = object.getAccessionNumberType();
            String url = AccessionNumberURLCreator.tryToCreateURL(type, accessionNumber);
            if (url == null) {
                return new Text(accessionNumber);
            }
            return new ExternalHyperlink(accessionNumber, url);
        }
    }

    private static final class PeptideRenderer
    extends AbstractPropertyValueRenderer<Peptide> {
        PeptideRenderer(IMessageProvider messageProvider) {
            super(messageProvider);
        }

        @Override
        public Widget getAsWidget(Peptide peptide) {
            StringBuilder builder = new StringBuilder();
            String sequence = peptide.getSequence();
            List<PeptideModification> modifications = peptide.getModifications();
            HashMap<Integer, PeptideModification> modificationsMap = new HashMap<Integer, PeptideModification>();
            for (PeptideModification modification : modifications) {
                modificationsMap.put(modification.getPosition(), modification);
            }
            int i = 0;
            int n = sequence.length();
            while (i < n) {
                char c = sequence.charAt(i);
                PeptideModification peptideModification = (PeptideModification)modificationsMap.get(i + 1);
                if (peptideModification != null) {
                    builder.append(ProteinRenderers.renderAminoAcidSymbol(c, null, peptideModification.getMass()));
                } else {
                    builder.append(c);
                }
                ++i;
            }
            FlowPanel panel = new FlowPanel();
            panel.add((Widget)new InlineHTML(ProteinRenderers.getFixedWidthHTMLString(builder.toString())));
            return panel;
        }
    }

    private static final class Symbol {
        private final char character;
        private boolean inPeptide;
        private Double mass;

        Symbol(char character) {
            this.character = character;
        }

        public char getCharacter() {
            return this.character;
        }

        public boolean isInPeptide() {
            return this.inPeptide;
        }

        public void inPeptide() {
            this.inPeptide = true;
        }

        public Double getMass() {
            return this.mass;
        }

        public void setMass(Double mass) {
            this.mass = mass;
        }
    }
}

