/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.server.dataaccess.db;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataSourceProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.dataaccess.IPhosphoNetXDAOFactory;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.dataaccess.IProteinQueryDAO;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import net.lemnik.eodsql.QueryTool;
import org.apache.log4j.Logger;

public class PhosphoNetXDAOFactory
implements IPhosphoNetXDAOFactory {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, PhosphoNetXDAOFactory.class);
    private final Map<DataSource, IProteinQueryDAO> daos = new HashMap<DataSource, IProteinQueryDAO>();
    private final IDAOFactory daoFactory;
    private final IDataSourceProvider dataSourceProvider;

    public PhosphoNetXDAOFactory(IDataSourceProvider dataSourceProvider, IDAOFactory daoFactory) {
        this.dataSourceProvider = dataSourceProvider;
        this.daoFactory = daoFactory;
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)"DAO factory for proteomics created.");
        }
    }

    @Override
    public IProteinQueryDAO getProteinQueryDAO(String experimentPermID) {
        ExperimentPE experiment = this.daoFactory.getExperimentDAO().tryGetByPermID(experimentPermID);
        if (experiment == null) {
            throw new UserFailureException("No experiment with following perm ID found: " + experimentPermID);
        }
        return this.getProteinQueryDAO(experiment);
    }

    @Override
    public IProteinQueryDAO getProteinQueryDAO(TechId experimentID) {
        ExperimentPE experiment = (ExperimentPE)this.daoFactory.getExperimentDAO().tryGetByTechId(experimentID, new String[0]);
        if (experiment == null) {
            throw new UserFailureException("No experiment with following technical ID found: " + experimentID);
        }
        return this.getProteinQueryDAO(experiment);
    }

    public IProteinQueryDAO getProteinQueryDAO(ExperimentPE experiment) {
        DataSource dataSource = this.getDataSource(experiment);
        IProteinQueryDAO dao = this.daos.get(dataSource);
        if (dao == null) {
            dao = (IProteinQueryDAO)QueryTool.getQuery((DataSource)dataSource, IProteinQueryDAO.class);
            this.daos.put(dataSource, dao);
        }
        return dao;
    }

    private DataSource getDataSource(ExperimentPE experiment) {
        IDataDAO dataDAO = this.daoFactory.getDataDAO();
        List<DataPE> dataSets = dataDAO.listDataSets(experiment);
        HashSet<String> dataStores = new HashSet<String>();
        for (DataPE data : dataSets) {
            dataStores.add(data.getDataStore().getCode());
        }
        if (dataStores.isEmpty()) {
            throw new UserFailureException("Experiment with " + experiment.getIdentifier() + " has no data sets.");
        }
        if (dataStores.size() > 1) {
            throw new UserFailureException("Experiment with " + experiment.getIdentifier() + " has data sets from more than one store. The stores are the following: " + dataStores);
        }
        DataSource dataSource = this.dataSourceProvider.getDataSourceByDataStoreServerCode((String)dataStores.iterator().next(), "proteomics");
        return dataSource;
    }
}

