/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.jython.v2;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.etlserver.registrator.DataSetRegistrationDetails;
import ch.systemsx.cisd.etlserver.registrator.api.v2.IDataSet;
import ch.systemsx.cisd.etlserver.registrator.api.v2.IDataSetUpdatable;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.DataSet;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.DataSetRegistrationTransaction;
import ch.systemsx.cisd.etlserver.registrator.v2.DataSetRegistrationService;
import ch.systemsx.cisd.etlserver.registrator.v2.IDataSetRegistrationDetailsFactory;
import ch.systemsx.cisd.openbis.common.io.FileBasedContentNode;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.etl.Hdf5ThumbnailGenerator;
import ch.systemsx.cisd.openbis.dss.etl.Utils;
import ch.systemsx.cisd.openbis.dss.etl.dto.ImageLibraryInfo;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ImageFileInfo;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.SimpleImageDataConfig;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ThumbnailsStorageFormat;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.impl.FeatureDefinition;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.impl.FeatureVectorDataSetInformation;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.impl.FeaturesBuilder;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.impl.ImageDataSetInformation;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.impl.ImageDataSetStructure;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.impl.ThumbnailsInfo;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.v2.FeatureListDataConfig;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.v2.IImageDataSet;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.v2.SimpleFeatureVectorDataConfig;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.v2.impl.FeatureVectorContainerDataSet;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.v2.impl.FeatureVectorDataSet;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.v2.impl.ImageContainerDataSet;
import ch.systemsx.cisd.openbis.dss.etl.featurevector.CsvFeatureVectorParser;
import ch.systemsx.cisd.openbis.dss.etl.jython.v2.JythonPlateDatasetFactory;
import ch.systemsx.cisd.openbis.dss.etl.jython.v2.SimpleImageDataSetRegistrator;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.IDataSetImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.Size;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchSubCriteria;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class ImagingDataSetRegistrationTransaction
extends DataSetRegistrationTransaction {
    private final IDataSetRegistrationDetailsFactory<ImageDataSetInformation> imageDatasetFactory;
    private final IDataSetRegistrationDetailsFactory<DataSetInformation> imageContainerDatasetFactory;
    private final String originalDirName;
    private final JythonPlateDatasetFactory factory;

    public ImagingDataSetRegistrationTransaction(File rollBackStackParentFolder, File workingDirectory, File stagingDirectory, DataSetRegistrationService<DataSetInformation> registrationService, IDataSetRegistrationDetailsFactory<DataSetInformation> registrationDetailsFactory, String originalDirName, String userSessionToken) {
        super(rollBackStackParentFolder, workingDirectory, stagingDirectory, registrationService, registrationDetailsFactory, userSessionToken);
        assert (registrationDetailsFactory instanceof JythonPlateDatasetFactory) : "JythonPlateDatasetFactory expected, but got: " + registrationDetailsFactory.getClass().getCanonicalName();
        this.factory = (JythonPlateDatasetFactory)registrationDetailsFactory;
        this.imageDatasetFactory = this.factory.imageDatasetFactory;
        this.imageContainerDatasetFactory = this.factory.imageContainerDatasetFactory;
        this.originalDirName = originalDirName;
    }

    public JythonPlateDatasetFactory getFactory() {
        return this.factory;
    }

    public IImageDataSet createNewImageDataSet(SimpleImageDataConfig imageDataSet, File incomingFolderWithImages) {
        DataSetRegistrationDetails<ImageDataSetInformation> details = SimpleImageDataSetRegistrator.createImageDatasetDetails(imageDataSet, incomingFolderWithImages, this.imageDatasetFactory);
        return this.createNewImageDataSet(details);
    }

    public IDataSet createNewOverviewImageDataSet(SimpleImageDataConfig imageDataSet, File incomingFolderWithImages) {
        DataSetRegistrationDetails<ImageDataSetInformation> details = SimpleImageDataSetRegistrator.createImageDatasetDetails(imageDataSet, incomingFolderWithImages, this.imageDatasetFactory);
        return this.createNewOverviewImageDataSet(details);
    }

    public IDataSet createNewFeatureListDataSet(FeatureListDataConfig config) {
        IDataSet dataSet = this.createNewDataSet();
        dataSet.setDataSetType("HCS_ANALYSIS_FEATURES_LIST");
        IDataSetUpdatable container = config.getContainerDataSet();
        this.verifyFeatureVectorContainer(container);
        this.addNewDataSetToContainer(dataSet, container);
        dataSet.setExperiment(container.getExperiment());
        this.storeFeatureListInDataset(config, dataSet);
        return dataSet;
    }

    private void storeFeatureListInDataset(FeatureListDataConfig config, IDataSet dataSet) {
        try {
            File directory = new File(this.getIncoming().getParentFile().getAbsolutePath(), "feature_lists");
            directory.mkdirs();
            File file = new File(directory, config.getName());
            file.createNewFile();
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            for (String feature : config.getFeatureList()) {
                bw.append(feature);
                bw.newLine();
            }
            bw.close();
            this.moveFile(directory.getAbsolutePath(), dataSet);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    private void addNewDataSetToContainer(IDataSet dataSet, IDataSetUpdatable container) {
        LinkedList<String> contained = new LinkedList<String>(container.getContainedDataSetCodes());
        contained.add(dataSet.getDataSetCode());
        container.setContainedDataSetCodes(contained);
    }

    private void verifyFeatureVectorContainer(IDataSetUpdatable container) {
        if (container == null) {
            throw new UserFailureException("Setting of container dataset for feature list data set is obligatory");
        }
        if (!container.getDataSetType().startsWith("HCS_ANALYSIS_CONTAINER")) {
            throw new UserFailureException("Container for feature list must be of HCS_ANALYSIS_CONTAINER.* type");
        }
    }

    public FeatureVectorContainerDataSet createNewFeatureVectorDataSet(SimpleFeatureVectorDataConfig featureDataSetConfig, File featureVectorFileOrNull) {
        DataSetRegistrationDetails<FeatureVectorDataSetInformation> registrationDetails = this.createFeatureVectorDataSetRegistrationDetails(featureDataSetConfig, featureVectorFileOrNull);
        return this.createFeatureVectorDataSet(registrationDetails);
    }

    private FeatureVectorContainerDataSet createFeatureVectorDataSet(DataSetRegistrationDetails<FeatureVectorDataSetInformation> registrationDetails) {
        DataSet dataSet = (DataSet)super.createNewDataSet(registrationDetails);
        FeatureVectorDataSet featureDataset = new FeatureVectorDataSet((DataSet<FeatureVectorDataSetInformation>)dataSet, this.getGlobalState().getOpenBisService());
        FeatureVectorContainerDataSet containerDataset = this.createFeatureVectorContainerDataSet(featureDataset);
        ((FeatureVectorDataSetInformation)registrationDetails.getDataSetInformation()).setContainerDatasetPermId(containerDataset.getDataSetCode());
        return containerDataset;
    }

    private DataSetRegistrationDetails<FeatureVectorDataSetInformation> createFeatureVectorDataSetRegistrationDetails(SimpleFeatureVectorDataConfig featureDataSetConfig, File featureVectorFileOrNull) {
        List<FeatureDefinition> featureDefinitions;
        Properties properties = featureDataSetConfig.getProperties();
        if (properties == null) {
            featureDefinitions = ((FeaturesBuilder)featureDataSetConfig.getFeaturesBuilder()).getFeatureDefinitionValuesList();
        } else {
            try {
                featureDefinitions = CsvFeatureVectorParser.parse(featureVectorFileOrNull, properties);
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
            }
        }
        DataSetRegistrationDetails<FeatureVectorDataSetInformation> registrationDetails = this.factory.createFeatureVectorRegistrationDetails(featureDefinitions);
        return registrationDetails;
    }

    public IImageDataSet createNewImageDataSet(DataSetRegistrationDetails<ImageDataSetInformation> imageRegistrationDetails) {
        ImageDataSetInformation imageDataSetInformation = (ImageDataSetInformation)imageRegistrationDetails.getDataSetInformation();
        ImageDataSetStructure imageDataSetStructure = imageDataSetInformation.getImageDataSetStructure();
        File incomingDirectory = imageDataSetInformation.getIncomingDirectory();
        ArrayList<String> containedDataSetCodes = new ArrayList<String>();
        this.calculateBoundingBox(imageDataSetInformation, imageDataSetStructure, incomingDirectory);
        ArrayList<IDataSet> thumbnailDatasets = new ArrayList<IDataSet>();
        boolean generateThumbnails = imageDataSetStructure.areThumbnailsGenerated();
        if (generateThumbnails) {
            imageDataSetStructure.validateImageRepresentationGenerationParameters(imageDataSetInformation);
            List<ThumbnailsStorageFormat> thumbnailsStorageFormatList = imageDataSetStructure.getImageStorageConfiguraton().getThumbnailsStorageFormat();
            ThumbnailsInfo thumbnailsInfo = new ThumbnailsInfo();
            for (ThumbnailsStorageFormat thumbnailsStorageFormat : thumbnailsStorageFormatList) {
                IDataSet thumbnailDataset = this.createThumbnailDataset(imageDataSetInformation, thumbnailsStorageFormat);
                thumbnailDatasets.add(thumbnailDataset);
                this.generateThumbnails(imageDataSetStructure, incomingDirectory, thumbnailDataset, thumbnailsStorageFormat, thumbnailsInfo, false, null);
                containedDataSetCodes.add(thumbnailDataset.getDataSetCode());
            }
            imageDataSetInformation.setThumbnailsInfo(thumbnailsInfo);
        }
        DataSet mainDataset = (DataSet)super.createNewDataSet(imageRegistrationDetails);
        containedDataSetCodes.add(mainDataset.getDataSetCode());
        for (IDataSet thumbnailDataset : thumbnailDatasets) {
            ImagingDataSetRegistrationTransaction.setSameDatasetOwner((IDataSetImmutable)mainDataset, thumbnailDataset);
        }
        ImageContainerDataSet containerDataset = this.createImageContainerDataset((IDataSet)mainDataset, imageDataSetInformation, containedDataSetCodes);
        containerDataset.setOriginalDataset((DataSet<ImageDataSetInformation>)mainDataset);
        containerDataset.setThumbnailDatasets(thumbnailDatasets);
        imageDataSetInformation.setContainerDatasetPermId(containerDataset.getDataSetCode());
        return containerDataset;
    }

    private IDataSet createNewOverviewImageDataSet(DataSetRegistrationDetails<ImageDataSetInformation> imageRegistrationDetails) {
        ImageDataSetInformation imageDataSetInformation = (ImageDataSetInformation)imageRegistrationDetails.getDataSetInformation();
        ImageDataSetStructure imageDataSetStructure = imageDataSetInformation.getImageDataSetStructure();
        File incomingDirectory = imageDataSetInformation.getIncomingDirectory();
        String containerCode = imageDataSetInformation.tryGetContainerDatasetPermId();
        IDataSetUpdatable container = this.getDataSetForUpdate(containerCode);
        if (container == null || !container.isContainerDataSet()) {
            throw UserFailureException.fromTemplate((String)"Container data set %s coudn't be found.", (Object[])new Object[]{container});
        }
        this.calculateBoundingBox(imageDataSetInformation, imageDataSetStructure, incomingDirectory);
        SearchCriteria searchCriteria = new SearchCriteria();
        SearchCriteria searchSubCriteria = new SearchCriteria();
        searchSubCriteria.addMatchClause(SearchCriteria.MatchClause.createAttributeMatch((SearchCriteria.MatchClauseAttribute)SearchCriteria.MatchClauseAttribute.CODE, (String)containerCode));
        searchCriteria.addSubCriteria(SearchSubCriteria.createDataSetContainerCriteria((SearchCriteria)searchSubCriteria));
        List containedDataSets = this.getSearchService().searchForDataSets(searchCriteria);
        IDataSetImmutable exampleDataSet = (IDataSetImmutable)containedDataSets.iterator().next();
        imageDataSetStructure.validateImageRepresentationGenerationParameters(imageDataSetInformation);
        ThumbnailsInfo thumbnailsInfo = new ThumbnailsInfo();
        ArrayList<String> containedDataSetCodes = new ArrayList<String>();
        containedDataSetCodes.addAll(container.getContainedDataSetCodes());
        ArrayList<Object> thumbnailDatasets = new ArrayList<Object>();
        if (imageDataSetInformation.isGenerateOverviewImagesFromRegisteredImages()) {
            IHierarchicalContent iHierarchicalContent = ServiceProvider.getHierarchicalContentProvider().asContent(containerCode);
            try {
                imageDataSetStructure.validateImageRepresentationGenerationParameters(imageDataSetInformation);
                List<ThumbnailsStorageFormat> thumbnailsStorageFormatList = imageDataSetStructure.getImageStorageConfiguraton().getThumbnailsStorageFormat();
                boolean isFirst = true;
                for (ThumbnailsStorageFormat thumbnailsStorageFormat : thumbnailsStorageFormatList) {
                    IDataSet thumbnailDataset = null;
                    if (isFirst) {
                        thumbnailDataset = super.createNewDataSet(imageRegistrationDetails);
                        thumbnailDataset.setFileFormatType(thumbnailsStorageFormat.getFileFormat().getOpenBISFileType());
                        thumbnailDataset.setMeasuredData(false);
                        isFirst = false;
                    } else {
                        thumbnailDataset = this.createThumbnailDataset(imageDataSetInformation, thumbnailsStorageFormat);
                    }
                    thumbnailDatasets.add(thumbnailDataset);
                    this.generateThumbnails(imageDataSetStructure, incomingDirectory, thumbnailDataset, thumbnailsStorageFormat, thumbnailsInfo, false, iHierarchicalContent);
                    containedDataSetCodes.add(thumbnailDataset.getDataSetCode());
                }
            }
            finally {
                if (iHierarchicalContent != null) {
                    iHierarchicalContent.close();
                }
            }
        } else {
            DataSet dataSet = (DataSet)super.createNewDataSet(imageRegistrationDetails);
            dataSet.setFileFormatType(imageDataSetInformation.getFileFormatTypeCode());
            dataSet.setMeasuredData(false);
            thumbnailDatasets.add(dataSet);
            this.generateThumbnails(imageDataSetStructure, incomingDirectory, (IDataSet)dataSet, ImagingDataSetRegistrationTransaction.createThumbnailsStorageFormat(imageDataSetInformation), thumbnailsInfo, true, null);
            containedDataSetCodes.add(dataSet.getDataSetCode());
        }
        imageDataSetInformation.setThumbnailsInfo(thumbnailsInfo);
        for (IDataSet iDataSet : thumbnailDatasets) {
            ImagingDataSetRegistrationTransaction.setSameDatasetOwner(exampleDataSet, iDataSet);
        }
        container.setContainedDataSetCodes(containedDataSetCodes);
        return (IDataSet)thumbnailDatasets.iterator().next();
    }

    private static ThumbnailsStorageFormat createThumbnailsStorageFormat(ImageDataSetInformation imageDataSetInformation) {
        ThumbnailsStorageFormat thumbnailsStorageFormat = new ThumbnailsStorageFormat();
        thumbnailsStorageFormat.setFileFormat(imageDataSetInformation.getFileFormatTypeCode());
        thumbnailsStorageFormat.setThumbnailsFileName(String.format("thumbnails_%dx%d.h5ar", imageDataSetInformation.getMaximumImageWidth(), imageDataSetInformation.getMaximumImageHeight()));
        return thumbnailsStorageFormat;
    }

    private void calculateBoundingBox(ImageDataSetInformation imageDataSetInformation, ImageDataSetStructure imageDataSetStructure, File incomingDirectory) {
        ImageLibraryInfo imageLibrary = imageDataSetStructure.getImageStorageConfiguraton().tryGetImageLibrary();
        List<ImageFileInfo> images = imageDataSetStructure.getImages();
        if (imageDataSetInformation.isGenerateOverviewImagesFromRegisteredImages()) {
            IHierarchicalContent content = ServiceProvider.getHierarchicalContentProvider().asContent(imageDataSetInformation.tryGetContainerDatasetPermId());
            try {
                for (ImageFileInfo imageFileInfo : images) {
                    this.setBoundingBox(imageDataSetInformation, content.getNode(imageFileInfo.getImageRelativePath()), imageLibrary);
                }
            }
            finally {
                if (content != null) {
                    content.close();
                }
            }
        } else {
            for (ImageFileInfo imageFileInfo : images) {
                File file = new File(incomingDirectory, imageFileInfo.getImageRelativePath());
                this.setBoundingBox(imageDataSetInformation, (IHierarchicalContentNode)new FileBasedContentNode(file), imageLibrary);
            }
        }
    }

    private void setBoundingBox(ImageDataSetInformation imageDataSetInformation, IHierarchicalContentNode content, ImageLibraryInfo imageLibrary) {
        Size size = Utils.loadUnchangedImageSize(content, null, imageLibrary);
        imageDataSetInformation.setMaximumImageWidth(Math.max(imageDataSetInformation.getMaximumImageWidth(), size.getWidth()));
        imageDataSetInformation.setMaximumImageHeight(Math.max(imageDataSetInformation.getMaximumImageHeight(), size.getHeight()));
        if (imageDataSetInformation.getColorDepth() == null) {
            imageDataSetInformation.setColorDepth(Utils.loadUnchangedImageColorDepth(content, null, imageLibrary));
        }
    }

    private File prependOriginalDirectory(String directoryPath) {
        return new File(String.valueOf(this.originalDirName) + File.separator + directoryPath);
    }

    private void generateThumbnails(ImageDataSetStructure imageDataSetStructure, File incomingDirectory, IDataSet thumbnailDataset, ThumbnailsStorageFormat thumbnailsStorageFormatOrNull, ThumbnailsInfo thumbnailPaths, boolean registerOriginalImageAsThumbnail, IHierarchicalContent content) {
        String thumbnailFile = thumbnailsStorageFormatOrNull == null ? this.createNewFile(thumbnailDataset, "thumbnails.h5ar") : this.createNewFile(thumbnailDataset, thumbnailsStorageFormatOrNull.getThumbnailsFileName());
        Hdf5ThumbnailGenerator.tryGenerateThumbnails(imageDataSetStructure, incomingDirectory, thumbnailFile, imageDataSetStructure.getImageStorageConfiguraton(), thumbnailDataset.getDataSetCode(), thumbnailsStorageFormatOrNull, thumbnailPaths, registerOriginalImageAsThumbnail, content);
        ImagingDataSetRegistrationTransaction.enhanceWithResolution(thumbnailDataset, thumbnailPaths);
    }

    private static void enhanceWithResolution(IDataSet thumbnailDataset, ThumbnailsInfo thumbnailPaths) {
        Size size = thumbnailPaths.tryGetDimension(thumbnailDataset.getDataSetCode());
        if (size != null) {
            thumbnailDataset.setPropertyValue("$RESOLUTION", String.valueOf(size.getWidth()) + "x" + size.getHeight());
        }
    }

    private IDataSet createThumbnailDataset(DataSetInformation imageDataSetInformation, ThumbnailsStorageFormat thumbnailsStorageFormat) {
        String thumbnailsDatasetTypeCode = ImagingDataSetRegistrationTransaction.findThumbnailsDatasetTypeCode(imageDataSetInformation);
        IDataSet thumbnailDataset = this.createNewDataSet(thumbnailsDatasetTypeCode);
        thumbnailDataset.setFileFormatType(thumbnailsStorageFormat.getFileFormat().getOpenBISFileType());
        thumbnailDataset.setMeasuredData(false);
        return thumbnailDataset;
    }

    private ImageContainerDataSet createImageContainerDataset(IDataSet mainDataset, DataSetInformation imageDataSetInformation, List<String> containedDataSetCodes) {
        String containerDatasetTypeCode = ImagingDataSetRegistrationTransaction.findContainerDatasetTypeCode(imageDataSetInformation);
        ImageContainerDataSet containerDataset = (ImageContainerDataSet)this.createNewDataSet(this.imageContainerDatasetFactory, containerDatasetTypeCode);
        ImagingDataSetRegistrationTransaction.setSameDatasetOwner((IDataSetImmutable)mainDataset, containerDataset);
        ImagingDataSetRegistrationTransaction.moveDatasetRelations(mainDataset, containerDataset);
        containerDataset.setContainedDataSetCodes(containedDataSetCodes);
        return containerDataset;
    }

    private FeatureVectorContainerDataSet createFeatureVectorContainerDataSet(FeatureVectorDataSet mainDataset) {
        String containerDatasetTypeCode = FeatureVectorContainerDataSet.getContainerAnalysisType(mainDataset.getDataSetType());
        FeatureVectorContainerDataSet containerDataSet = (FeatureVectorContainerDataSet)this.createNewDataSet(this.factory.featureVectorContainerDatasetFactory, containerDatasetTypeCode);
        containerDataSet.setContainedDataSetCodes(Collections.singletonList(mainDataset.getDataSetCode()));
        containerDataSet.setOriginalDataSet(mainDataset);
        return containerDataSet;
    }

    private static void moveDatasetRelations(IDataSet mainDataset, IDataSet containerDataset) {
        containerDataset.setParentDatasets(mainDataset.getParentDatasets());
        mainDataset.setParentDatasets(Collections.emptyList());
        for (String propertyCode : mainDataset.getAllPropertyCodes()) {
            containerDataset.setPropertyValue(propertyCode, mainDataset.getPropertyValue(propertyCode));
            mainDataset.setPropertyValue(propertyCode, null);
        }
    }

    private static boolean isHCSImageDataSetType(String mainDatasetTypeCode) {
        String prefix = "HCS_IMAGE";
        if (mainDatasetTypeCode.startsWith(prefix)) {
            if (mainDatasetTypeCode.contains("_CONTAINER")) {
                throw UserFailureException.fromTemplate((String)"The specified image dataset type '%s' should not be of container type, but contains '%s' in the type code.", (Object[])new Object[]{mainDatasetTypeCode, "_CONTAINER"});
            }
            return true;
        }
        return false;
    }

    private static boolean isMicroscopyImageDataSetType(String dataSetTypeCode) {
        return dataSetTypeCode.contains("IMG") && !dataSetTypeCode.contains("IMG_CONTAINER");
    }

    private static String findContainerDatasetTypeCode(DataSetInformation imageDataSetInformation) {
        String dataSetTypeCode = imageDataSetInformation.getDataSetType().getCode().toUpperCase();
        String prefix = "HCS_IMAGE";
        if (ImagingDataSetRegistrationTransaction.isHCSImageDataSetType(dataSetTypeCode)) {
            return String.valueOf(prefix) + "_CONTAINER" + dataSetTypeCode.substring(prefix.length());
        }
        if (ImagingDataSetRegistrationTransaction.isMicroscopyImageDataSetType(dataSetTypeCode)) {
            return dataSetTypeCode.replace("IMG", "IMG_CONTAINER");
        }
        throw UserFailureException.fromTemplate((String)"The image dataset type '%s' is neither standard HCS type (starts with '%s') nor a microscopy type (contains '%s').", (Object[])new Object[]{dataSetTypeCode, prefix, ".*IMG.*"});
    }

    private static String findThumbnailsDatasetTypeCode(DataSetInformation imageDataSetInformation) {
        String dataSetTypeCode = imageDataSetInformation.getDataSetType().getCode().toUpperCase();
        if (ImagingDataSetRegistrationTransaction.isHCSImageDataSetType(dataSetTypeCode)) {
            return "HCS_IMAGE_OVERVIEW";
        }
        if (ImagingDataSetRegistrationTransaction.isMicroscopyImageDataSetType(dataSetTypeCode)) {
            return dataSetTypeCode.replace("IMG", "IMG_OVERVIEW");
        }
        throw UserFailureException.fromTemplate((String)"The image dataset type '%s' is neither standard HCS type (starts with '%s') nor a microscopy type (contains '%s').", (Object[])new Object[]{dataSetTypeCode, "HCS_IMAGE", ".*IMG.*"});
    }

    private static void setSameDatasetOwner(IDataSetImmutable templateDataset, IDataSet destinationDataset) {
        destinationDataset.setExperiment(templateDataset.getExperiment());
        destinationDataset.setSample(templateDataset.getSample());
    }

    public IDataSet createNewDataSet(DataSetRegistrationDetails registrationDetails) {
        if (registrationDetails.getDataSetInformation() instanceof ImageDataSetInformation) {
            DataSetRegistrationDetails imageRegistrationDetails = registrationDetails;
            return this.createNewImageDataSet((DataSetRegistrationDetails<ImageDataSetInformation>)imageRegistrationDetails);
        }
        if (registrationDetails.getDataSetInformation() instanceof FeatureVectorDataSetInformation) {
            DataSetRegistrationDetails featureRegistrationDetails = registrationDetails;
            return this.createFeatureVectorDataSet((DataSetRegistrationDetails<FeatureVectorDataSetInformation>)featureRegistrationDetails);
        }
        return super.createNewDataSet(registrationDetails);
    }

    public String moveFile(String src, IDataSet dst) {
        return this.moveFile(src, dst, new File(src).getName());
    }

    public String moveFile(String src, IDataSet dst, String dstInDataset) {
        ImageContainerDataSet imageContainerDataset = ImagingDataSetRegistrationTransaction.tryAsImageContainerDataset(dst);
        if (imageContainerDataset != null) {
            String destination = this.getDestinationInOriginal(dstInDataset);
            DataSet<ImageDataSetInformation> originalDataset = imageContainerDataset.getOriginalDataset();
            if (originalDataset == null) {
                throw new UserFailureException("Cannot move the files because the original dataset is missing: " + src);
            }
            ImageDataSetInformation dataSetInformation = (ImageDataSetInformation)originalDataset.getRegistrationDetails().getDataSetInformation();
            if (dataSetInformation.getDatasetRelativeImagesFolderPath() == null) {
                dataSetInformation.setDatasetRelativeImagesFolderPath(new File(destination));
            }
            return super.moveFile(src, originalDataset, destination);
        }
        FeatureVectorContainerDataSet featureContainer = ImagingDataSetRegistrationTransaction.tryAsFeatureVectorContainerDataset(dst);
        if (featureContainer != null) {
            IDataSet originalDataSet = featureContainer.getOriginalDataset();
            if (originalDataSet == null) {
                throw new UserFailureException("Cannot move the files because the original dataset is missing: " + src);
            }
            return super.moveFile(src, originalDataSet, dstInDataset);
        }
        return super.moveFile(src, dst, dstInDataset);
    }

    private String getDestinationInOriginal(String dstInDataset) {
        String destination = dstInDataset;
        if (!destination.startsWith(this.originalDirName)) {
            destination = this.prependOriginalDirectory(destination).getPath();
        }
        return destination;
    }

    private static FeatureVectorContainerDataSet tryAsFeatureVectorContainerDataset(IDataSet dataset) {
        if (dataset instanceof FeatureVectorContainerDataSet) {
            return (FeatureVectorContainerDataSet)dataset;
        }
        return null;
    }

    private static ImageContainerDataSet tryAsImageContainerDataset(IDataSet dataset) {
        if (dataset instanceof ImageContainerDataSet) {
            return (ImageContainerDataSet)dataset;
        }
        return null;
    }
}

